/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.web.support;

import java.util.concurrent.Callable;
import org.neo4j.ogm.session.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.neo4j.transaction.SessionHolder;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.async.CallableProcessingInterceptorAdapter;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.context.request.async.DeferredResultProcessingInterceptor;

class AsyncRequestInterceptor
extends CallableProcessingInterceptorAdapter
implements DeferredResultProcessingInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(AsyncRequestInterceptor.class);
    private final SessionFactory sessionFactory;
    private final SessionHolder sessionHolder;
    private volatile boolean timeoutInProgress;

    public AsyncRequestInterceptor(SessionFactory sessionFactory, SessionHolder sessionHolder) {
        this.sessionFactory = sessionFactory;
        this.sessionHolder = sessionHolder;
    }

    public <T> void preProcess(NativeWebRequest request, Callable<T> task) {
        this.bindSession();
    }

    public void bindSession() {
        this.timeoutInProgress = false;
        TransactionSynchronizationManager.bindResource((Object)this.sessionFactory, (Object)((Object)this.sessionHolder));
    }

    public <T> void postProcess(NativeWebRequest request, Callable<T> task, Object concurrentResult) {
        TransactionSynchronizationManager.unbindResource((Object)this.sessionFactory);
    }

    public <T> Object handleTimeout(NativeWebRequest request, Callable<T> task) {
        this.timeoutInProgress = true;
        return RESULT_NONE;
    }

    public <T> void afterCompletion(NativeWebRequest request, Callable<T> task) throws Exception {
        this.closeAfterTimeout();
    }

    private void closeAfterTimeout() {
        if (this.timeoutInProgress) {
            logger.debug("Closing Neo4j OGM Session after async request timeout");
        }
    }

    public <T> void beforeConcurrentHandling(NativeWebRequest request, DeferredResult<T> deferredResult) {
    }

    public <T> void preProcess(NativeWebRequest request, DeferredResult<T> deferredResult) {
    }

    public <T> void postProcess(NativeWebRequest request, DeferredResult<T> deferredResult, Object result) {
    }

    public <T> boolean handleTimeout(NativeWebRequest request, DeferredResult<T> deferredResult) {
        this.timeoutInProgress = true;
        return true;
    }

    public <T> void afterCompletion(NativeWebRequest nativeWebRequest, DeferredResult<T> deferredResult) throws Exception {
    }
}

