/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.mapping;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Optional;
import org.neo4j.ogm.annotation.EndNode;
import org.neo4j.ogm.annotation.Id;
import org.neo4j.ogm.annotation.Relationship;
import org.neo4j.ogm.annotation.StartNode;
import org.neo4j.ogm.annotation.Version;
import org.neo4j.ogm.metadata.ClassInfo;
import org.neo4j.ogm.metadata.FieldInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.AnnotationBasedPersistentProperty;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.neo4j.annotation.QueryResult;

public class Neo4jPersistentProperty
extends AnnotationBasedPersistentProperty<Neo4jPersistentProperty> {
    private static final Logger logger = LoggerFactory.getLogger(Neo4jPersistentProperty.class);
    private final PropertyType propertyType;

    public Neo4jPersistentProperty(ClassInfo owningClassInfo, Property property, PersistentEntity<?, Neo4jPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder) {
        super(property, owner, simpleTypeHolder);
        if (owningClassInfo == null) {
            logger.warn("Owning ClassInfo is null for property: {}", (Object)property);
        }
        this.propertyType = owningClassInfo == null || Neo4jPersistentProperty.owningClassIsSimple(owningClassInfo, simpleTypeHolder) || Neo4jPersistentProperty.owningClassDoesNotSupportIdProperties(owningClassInfo) || Neo4jPersistentProperty.owningPropertyIsEnum(owner) ? PropertyType.REGULAR_PROPERTY : (Neo4jPersistentProperty.isInternalIdentityField(owningClassInfo, property) ? PropertyType.INTERNAL_ID_PROPERTY : (Neo4jPersistentProperty.isExplicitIdentityField(owningClassInfo, property) ? PropertyType.ID_PROPERTY : PropertyType.REGULAR_PROPERTY));
    }

    private static boolean owningPropertyIsEnum(PersistentEntity<?, Neo4jPersistentProperty> owner) {
        return owner.getType().isEnum();
    }

    private static boolean owningClassIsSimple(ClassInfo owningClassInfo, SimpleTypeHolder simpleTypeHolder) {
        return owningClassInfo.getUnderlyingClass() != null && simpleTypeHolder.isSimpleType(owningClassInfo.getUnderlyingClass());
    }

    private static boolean owningClassDoesNotSupportIdProperties(ClassInfo owningClassInfo) {
        return owningClassInfo.isInterface() || owningClassInfo.annotationsInfo().get(QueryResult.class.getName()) != null || owningClassInfo.isEnum();
    }

    private static boolean isInternalIdentityField(ClassInfo owningClassInfo, Property property) {
        Optional<Field> optionalInternalIdentityField = Optional.ofNullable(owningClassInfo.identityFieldOrNull()).map(FieldInfo::getField);
        return property.getField().equals(optionalInternalIdentityField);
    }

    private static boolean isExplicitIdentityField(ClassInfo owningClassInfo, Property property) {
        return property.getField().map(field -> (Id)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, Id.class)).isPresent();
    }

    public boolean isIdProperty() {
        return this.propertyType.idProperty;
    }

    PropertyType getPropertyType() {
        return this.propertyType;
    }

    public boolean isVersionProperty() {
        return this.isAnnotationPresent(Version.class);
    }

    public boolean usePropertyAccess() {
        logger.debug("[property].usePropertyAccess() returns false");
        return false;
    }

    public boolean isAssociation() {
        return !this.isTransient() && (this.isAnnotationPresent(Relationship.class) || this.isAnnotationPresent(StartNode.class) || this.isAnnotationPresent(EndNode.class));
    }

    protected Association<Neo4jPersistentProperty> createAssociation() {
        return new Association((PersistentProperty)this, null);
    }

    static enum PropertyType {
        REGULAR_PROPERTY(false),
        INTERNAL_ID_PROPERTY(true),
        ID_PROPERTY(true);

        private final boolean idProperty;

        private PropertyType(boolean idProperty) {
            this.idProperty = idProperty;
        }
    }
}

