/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.neo4j.core.schema;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.neo4j.core.convert.Neo4jConversionService;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverter;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyConverterFactory;
import org.springframework.data.neo4j.core.convert.Neo4jPersistentPropertyToMapConverter;
import org.springframework.data.neo4j.core.mapping.Neo4jPersistentProperty;
import org.springframework.data.neo4j.core.schema.CompositeProperty;
import org.springframework.data.neo4j.core.schema.CompositePropertyConverter;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

final class CompositePropertyConverterFactory
implements Neo4jPersistentPropertyConverterFactory {
    private static final String KEY_TYPE_KEY = "K";
    private static final String PROPERTY_TYPE_KEY = "P";
    private final BeanFactory beanFactory;
    private final Neo4jConversionService conversionServiceDelegate;

    CompositePropertyConverterFactory(@Nullable BeanFactory beanFactory, @Nullable Neo4jConversionService conversionServiceDelegate) {
        this.beanFactory = beanFactory;
        this.conversionServiceDelegate = conversionServiceDelegate;
    }

    @Override
    public Neo4jPersistentPropertyConverter<?> getPropertyConverterFor(Neo4jPersistentProperty persistentProperty) {
        Function<Object, String> keyWriter;
        Function<String, Object> keyReader;
        Class componentType;
        CompositeProperty config = (CompositeProperty)persistentProperty.getRequiredAnnotation(CompositeProperty.class);
        Class delegateClass = config.converter();
        Neo4jPersistentPropertyToMapConverter delegate = null;
        if (StringUtils.hasText((String)config.converterRef())) {
            if (this.beanFactory == null) {
                throw new IllegalStateException("The default composite converter factory has been configured without a bean factory and cannot use a converter from the application context");
            }
            delegate = (CompositeProperty.DefaultToMapConverter)this.beanFactory.getBean(config.converterRef(), Neo4jPersistentPropertyToMapConverter.class);
            delegateClass = delegate.getClass();
        }
        if (persistentProperty.isMap()) {
            componentType = persistentProperty.getComponentType();
        } else {
            if (delegateClass == CompositeProperty.DefaultToMapConverter.class) {
                throw new IllegalArgumentException("@" + CompositeProperty.class.getSimpleName() + " can only be used on Map properties without additional configuration. Was " + CompositePropertyConverterFactory.generateLocation(persistentProperty));
            }
            Map<String, Type> typeVariableMap = GenericTypeResolver.getTypeVariableMap(delegateClass).entrySet().stream().collect(Collectors.toMap(e -> ((TypeVariable)e.getKey()).getName(), Map.Entry::getValue));
            Assert.isTrue((boolean)typeVariableMap.containsKey(KEY_TYPE_KEY), () -> "SDN could not determine the key type of your toMap converter " + CompositePropertyConverterFactory.generateLocation(persistentProperty));
            Assert.isTrue((boolean)typeVariableMap.containsKey(PROPERTY_TYPE_KEY), () -> "SDN could not determine the property type of your toMap converter " + CompositePropertyConverterFactory.generateLocation(persistentProperty));
            Type type = typeVariableMap.get(PROPERTY_TYPE_KEY);
            if (persistentProperty.isCollectionLike() && type instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)type;
                if (persistentProperty.getType().equals(pt.getRawType()) && pt.getActualTypeArguments().length == 1) {
                    type = ((ParameterizedType)type).getActualTypeArguments()[0];
                }
            }
            if (persistentProperty.getActualType() != type) {
                throw new IllegalArgumentException("The property type `" + typeVariableMap.get(PROPERTY_TYPE_KEY).getTypeName() + "` created by `" + delegateClass.getName() + "` " + CompositePropertyConverterFactory.generateLocation(persistentProperty) + " doesn't match the actual property type");
            }
            componentType = (Class)typeVariableMap.get(KEY_TYPE_KEY);
        }
        boolean isEnum = componentType.isEnum();
        if (componentType != String.class && !isEnum) {
            throw new IllegalArgumentException("@" + CompositeProperty.class.getSimpleName() + " can only be used on Map properties with a key type of String or enum. Was " + CompositePropertyConverterFactory.generateLocation(persistentProperty));
        }
        BiFunction keyTransformation = (BiFunction)BeanUtils.instantiateClass(config.transformKeysWith());
        if (isEnum) {
            keyReader = key -> Enum.valueOf(componentType, (String)keyTransformation.apply(CompositeProperty.Phase.READ, key));
            keyWriter = key -> (String)keyTransformation.apply(CompositeProperty.Phase.WRITE, key.name());
        } else {
            keyReader = key -> keyTransformation.apply(CompositeProperty.Phase.READ, key);
            keyWriter = key -> (String)keyTransformation.apply(CompositeProperty.Phase.WRITE, key);
        }
        if (delegate == null) {
            delegate = delegateClass == CompositeProperty.DefaultToMapConverter.class ? new CompositeProperty.DefaultToMapConverter(TypeInformation.of((Class)persistentProperty.getActualType())) : (Neo4jPersistentPropertyToMapConverter)BeanUtils.instantiateClass(delegateClass);
        }
        String prefixWithDelimiter = persistentProperty.computePrefixWithDelimiter();
        return new CompositePropertyConverter(delegate, prefixWithDelimiter, this.conversionServiceDelegate, componentType, keyWriter, keyReader);
    }

    private static String generateLocation(Neo4jPersistentProperty persistentProperty) {
        return "used on `" + persistentProperty.getFieldName() + "` in `" + persistentProperty.getOwner().getName() + "`";
    }
}

