/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jredis;

import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jredis.ClientRuntimeException;
import org.jredis.RedisException;
import org.jredis.RedisType;
import org.jredis.Sort;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.connection.util.DecodeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JredisUtils {
    public static DataAccessException convertJredisAccessException(RedisException ex) {
        return new InvalidDataAccessApiUsageException(ex.getMessage(), (Throwable)ex);
    }

    public static DataAccessException convertJredisAccessException(ClientRuntimeException ex) {
        return new InvalidDataAccessResourceUsageException(ex.getMessage(), (Throwable)ex);
    }

    static DataType convertDataType(RedisType type) {
        switch (type) {
            case NONE: {
                return DataType.NONE;
            }
            case string: {
                return DataType.STRING;
            }
            case list: {
                return DataType.LIST;
            }
            case set: {
                return DataType.SET;
            }
            case hash: {
                return DataType.HASH;
            }
        }
        return null;
    }

    static String decode(byte[] bytes) {
        return DecodeUtils.decode(bytes);
    }

    static byte[] encode(String string) {
        return DecodeUtils.encode(string);
    }

    static String[] decodeMultiple(byte[] ... bytes) {
        return DecodeUtils.decodeMultiple(bytes);
    }

    static Map<byte[], byte[]> encodeMap(Map<String, byte[]> map) {
        return DecodeUtils.encodeMap(map);
    }

    static Map<String, byte[]> decodeMap(Map<byte[], byte[]> tuple) {
        return DecodeUtils.decodeMap(tuple);
    }

    static Set<byte[]> convertToSet(Collection<String> keys) {
        return DecodeUtils.convertToSet(keys);
    }

    static Sort applySortingParams(Sort jredisSort, SortParameters params, byte[] storeKey) {
        if (params != null) {
            Boolean isAlpha;
            SortParameters.Order order;
            SortParameters.Range limit;
            byte[][] getPattern;
            byte[] byPattern = params.getByPattern();
            if (byPattern != null) {
                jredisSort.BY(JredisUtils.decode(byPattern));
            }
            if ((getPattern = params.getGetPattern()) != null && getPattern.length > 0) {
                for (byte[] bs : getPattern) {
                    jredisSort.GET(JredisUtils.decode(bs));
                }
            }
            if ((limit = params.getLimit()) != null) {
                jredisSort.LIMIT(limit.getStart(), limit.getCount());
            }
            if ((order = params.getOrder()) != null && order.equals((Object)SortParameters.Order.DESC)) {
                jredisSort.DESC();
            }
            if ((isAlpha = params.isAlphabetic()) != null && isAlpha.booleanValue()) {
                jredisSort.ALPHA();
            }
        }
        if (storeKey != null) {
            jredisSort.STORE(JredisUtils.decode(storeKey));
        }
        return jredisSort;
    }

    static Properties info(Map<String, String> map) {
        Properties info = new Properties();
        info.putAll(map);
        return info;
    }
}

