/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.query;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.redis.connection.SortParameters;
import org.springframework.data.redis.core.query.DefaultSortQuery;
import org.springframework.data.redis.core.query.SortCriterion;
import org.springframework.data.redis.core.query.SortQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DefaultSortCriterion<K>
implements SortCriterion<K> {
    private final K key;
    private String by;
    private final List<String> getKeys = new ArrayList<String>(4);
    private SortParameters.Range limit;
    private SortParameters.Order order;
    private Boolean alpha;

    DefaultSortCriterion(K key) {
        this.key = key;
    }

    @Override
    public SortCriterion<K> alphabetical(boolean alpha) {
        this.alpha = alpha;
        return this;
    }

    @Override
    public SortQuery<K> build() {
        return new DefaultSortQuery<K>(this.key, this.by, this.limit, this.order, this.alpha, this.getKeys);
    }

    @Override
    public SortCriterion<K> limit(long offset, long count) {
        this.limit = new SortParameters.Range(offset, count);
        return this;
    }

    @Override
    public SortCriterion<K> limit(SortParameters.Range range) {
        this.limit = range;
        return this;
    }

    @Override
    public SortCriterion<K> order(SortParameters.Order order) {
        this.order = order;
        return this;
    }

    @Override
    public SortCriterion<K> get(String getPattern) {
        this.getKeys.add(getPattern);
        return this;
    }

    SortCriterion<K> addBy(String keyPattern) {
        this.by = keyPattern;
        return this;
    }
}

