/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cache.Cache;
import org.springframework.cache.transaction.AbstractTransactionSupportingCacheManager;
import org.springframework.cache.transaction.TransactionAwareCacheDecorator;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.cache.DefaultRedisCachePrefix;
import org.springframework.data.redis.cache.RedisCache;
import org.springframework.data.redis.cache.RedisCachePrefix;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class RedisCacheManager
extends AbstractTransactionSupportingCacheManager {
    private final Log logger = LogFactory.getLog(RedisCacheManager.class);
    private final RedisOperations redisOperations;
    private boolean usePrefix = false;
    private RedisCachePrefix cachePrefix = new DefaultRedisCachePrefix();
    private boolean loadRemoteCachesOnStartup = false;
    private boolean dynamic = true;
    private long defaultExpiration = 0L;
    private Map<String, Long> expires = null;
    private Set<String> configuredCacheNames;

    public RedisCacheManager(RedisOperations redisOperations) {
        this(redisOperations, Collections.emptyList());
    }

    public RedisCacheManager(RedisOperations redisOperations, Collection<String> cacheNames) {
        this.redisOperations = redisOperations;
        this.setCacheNames(cacheNames);
    }

    public Cache getCache(String name) {
        Cache cache = super.getCache(name);
        if (cache == null && this.dynamic) {
            return this.createAndAddCache(name);
        }
        return cache;
    }

    public void setCacheNames(Collection<String> cacheNames) {
        HashSet<String> newCacheNames = CollectionUtils.isEmpty(cacheNames) ? Collections.emptySet() : new HashSet<String>(cacheNames);
        this.configuredCacheNames = newCacheNames;
        this.dynamic = newCacheNames.isEmpty();
    }

    public void setUsePrefix(boolean usePrefix) {
        this.usePrefix = usePrefix;
    }

    public void setCachePrefix(RedisCachePrefix cachePrefix) {
        this.cachePrefix = cachePrefix;
    }

    public void setDefaultExpiration(long defaultExpireTime) {
        this.defaultExpiration = defaultExpireTime;
    }

    public void setExpires(Map<String, Long> expires) {
        this.expires = expires != null ? new ConcurrentHashMap<String, Long>(expires) : null;
    }

    public void setLoadRemoteCachesOnStartup(boolean loadRemoteCachesOnStartup) {
        this.loadRemoteCachesOnStartup = loadRemoteCachesOnStartup;
    }

    protected Collection<? extends Cache> loadCaches() {
        Assert.notNull((Object)this.redisOperations, (String)"A redis template is required in order to interact with data store");
        return this.addConfiguredCachesIfNecessary(this.loadRemoteCachesOnStartup ? this.loadAndInitRemoteCaches() : Collections.emptyList());
    }

    protected Collection<? extends Cache> addConfiguredCachesIfNecessary(Collection<? extends Cache> caches) {
        Assert.notNull(caches, (String)"Caches must not be null!");
        ArrayList<? extends Cache> result = new ArrayList<Cache>(caches);
        for (String cacheName : this.getCacheNames()) {
            boolean configuredCacheAlreadyPresent = false;
            for (Cache cache : caches) {
                if (!cache.getName().equals(cacheName)) continue;
                configuredCacheAlreadyPresent = true;
                break;
            }
            if (configuredCacheAlreadyPresent) continue;
            result.add((Cache)this.getCache(cacheName));
        }
        return result;
    }

    protected Cache createAndAddCache(String cacheName) {
        this.addCache(this.createCache(cacheName));
        return super.getCache(cacheName);
    }

    protected RedisCache createCache(String cacheName) {
        long expiration = this.computeExpiration(cacheName);
        return new RedisCache(cacheName, this.usePrefix ? this.cachePrefix.prefix(cacheName) : null, this.redisOperations, expiration);
    }

    protected long computeExpiration(String name) {
        Long expiration = null;
        if (this.expires != null) {
            expiration = this.expires.get(name);
        }
        return expiration != null ? expiration : this.defaultExpiration;
    }

    protected List<Cache> loadAndInitRemoteCaches() {
        ArrayList<Cache> caches;
        block4: {
            caches = new ArrayList<Cache>();
            try {
                Set<String> cacheNames = this.loadRemoteCacheKeys();
                if (!CollectionUtils.isEmpty(cacheNames)) {
                    for (String cacheName : cacheNames) {
                        if (null != super.getCache(cacheName)) continue;
                        caches.add(this.createCache(cacheName));
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block4;
                this.logger.warn((Object)"Failed to initialize cache with remote cache keys.", (Throwable)e);
            }
        }
        return caches;
    }

    protected Set<String> loadRemoteCacheKeys() {
        return this.redisOperations.execute(new RedisCallback<Set<String>>(){

            @Override
            public Set<String> doInRedis(RedisConnection connection) throws DataAccessException {
                Set<byte[]> keys = connection.keys(RedisCacheManager.this.redisOperations.getKeySerializer().serialize("*~keys"));
                LinkedHashSet<String> cacheKeys = new LinkedHashSet<String>();
                if (!CollectionUtils.isEmpty(keys)) {
                    for (byte[] key : keys) {
                        cacheKeys.add(RedisCacheManager.this.redisOperations.getKeySerializer().deserialize(key).toString().replace("~keys", ""));
                    }
                }
                return cacheKeys;
            }
        });
    }

    protected RedisOperations getRedisOperations() {
        return this.redisOperations;
    }

    protected RedisCachePrefix getCachePrefix() {
        return this.cachePrefix;
    }

    protected boolean isUsePrefix() {
        return this.usePrefix;
    }

    public void afterPropertiesSet() {
        if (!CollectionUtils.isEmpty(this.configuredCacheNames)) {
            for (String cacheName : this.configuredCacheNames) {
                this.createAndAddCache(cacheName);
            }
            this.configuredCacheNames.clear();
        }
        super.afterPropertiesSet();
    }

    protected Cache decorateCache(Cache cache) {
        if (this.isCacheAlreadyDecorated(cache)) {
            return cache;
        }
        return super.decorateCache(cache);
    }

    protected boolean isCacheAlreadyDecorated(Cache cache) {
        return this.isTransactionAware() && cache instanceof TransactionAwareCacheDecorator;
    }
}

