/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Set;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.SimpleIndexedPropertyValue;
import org.springframework.data.redis.util.ByteUtils;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

class IndexWriter {
    private final RedisConnection connection;
    private final RedisConverter converter;

    public IndexWriter(RedisConnection connection, RedisConverter converter) {
        Assert.notNull((Object)connection, (String)"RedisConnection cannot be null!");
        Assert.notNull((Object)converter, (String)"RedisConverter cannot be null!");
        this.connection = connection;
        this.converter = converter;
    }

    public void updateIndexes(Object key, Iterable<IndexedData> indexValues) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (indexValues == null) {
            return;
        }
        byte[] binKey = this.toBytes(key);
        this.removeKeyFromExistingIndexes(binKey, indexValues);
        this.addKeyToIndexes(binKey, indexValues);
    }

    public void removeKeyFromIndexes(String keyspace, Object key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        byte[] binKey = this.toBytes(key);
        byte[] indexHelperKey = ByteUtils.concatAll(this.toBytes(keyspace + ":"), binKey, this.toBytes(":idx"));
        for (byte[] indexKey : this.connection.sMembers(indexHelperKey)) {
            this.connection.sRem(indexKey, new byte[][]{binKey});
        }
        this.connection.del(new byte[][]{indexHelperKey});
    }

    public void removeAllIndexes(String keyspace) {
        Set<byte[]> potentialIndex = this.connection.keys(this.toBytes(keyspace + ":*"));
        if (!potentialIndex.isEmpty()) {
            this.connection.del((byte[][])potentialIndex.toArray((T[])new byte[potentialIndex.size()][]));
        }
    }

    private void removeKeyFromExistingIndexes(byte[] key, Iterable<IndexedData> indexValues) {
        for (IndexedData indexData : indexValues) {
            this.removeKeyFromExistingIndexes(key, indexData);
        }
    }

    protected void removeKeyFromExistingIndexes(byte[] key, IndexedData indexedData) {
        Assert.notNull((Object)indexedData, (String)"IndexedData must not be null!");
        Set<byte[]> existingKeys = this.connection.keys(this.toBytes(indexedData.getKeyspace() + ":" + indexedData.getIndexName() + ":*"));
        if (!CollectionUtils.isEmpty(existingKeys)) {
            for (byte[] existingKey : existingKeys) {
                this.connection.sRem(existingKey, new byte[][]{key});
            }
        }
    }

    private void addKeyToIndexes(byte[] key, Iterable<IndexedData> indexValues) {
        for (IndexedData indexData : indexValues) {
            this.addKeyToIndex(key, indexData);
        }
    }

    protected void addKeyToIndex(byte[] key, IndexedData indexedData) {
        Object value;
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)indexedData, (String)"IndexedData must not be null!");
        if (indexedData instanceof SimpleIndexedPropertyValue) {
            value = ((SimpleIndexedPropertyValue)indexedData).getValue();
            if (value == null) {
                return;
            }
        } else {
            throw new IllegalArgumentException(String.format("Cannot write index data for unknown index type %s", indexedData.getClass()));
        }
        byte[] indexKey = this.toBytes(indexedData.getKeyspace() + ":" + indexedData.getIndexName() + ":");
        indexKey = ByteUtils.concat(indexKey, this.toBytes(value));
        this.connection.sAdd(indexKey, new byte[][]{key});
        this.connection.sAdd(ByteUtils.concatAll(this.toBytes(indexedData.getKeyspace() + ":"), key, this.toBytes(":idx")), new byte[][]{indexKey});
    }

    private byte[] toBytes(Object source) {
        if (source == null) {
            return new byte[0];
        }
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        if (this.converter.getConversionService().canConvert(source.getClass(), byte[].class)) {
            return (byte[])this.converter.getConversionService().convert(source, byte[].class);
        }
        throw new InvalidDataAccessApiUsageException(String.format("Cannot convert %s to binary representation for index key generation. Are you missing a Converter? Did you register a non PathBasedRedisIndexDefinition that might apply to a complex type?", source.getClass()));
    }
}

