/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.CollectionFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.EntityInstantiator;
import org.springframework.data.convert.EntityInstantiators;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.keyvalue.core.mapping.KeySpaceResolver;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentEntity;
import org.springframework.data.keyvalue.core.mapping.KeyValuePersistentProperty;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.mapping.model.ParameterValueProvider;
import org.springframework.data.mapping.model.PersistentEntityParameterValueProvider;
import org.springframework.data.mapping.model.PropertyValueProvider;
import org.springframework.data.redis.core.convert.Bucket;
import org.springframework.data.redis.core.convert.CustomConversions;
import org.springframework.data.redis.core.convert.IndexResolver;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.data.redis.core.convert.PathIndexResolver;
import org.springframework.data.redis.core.convert.RedisConverter;
import org.springframework.data.redis.core.convert.RedisData;
import org.springframework.data.redis.core.convert.ReferenceResolver;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.ClassTypeInformation;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.comparator.NullSafeComparator;

public class MappingRedisConverter
implements RedisConverter,
InitializingBean {
    private final RedisMappingContext mappingContext;
    private final GenericConversionService conversionService;
    private final EntityInstantiators entityInstantiators;
    private final TypeMapper<RedisData> typeMapper;
    private final Comparator<String> listKeyComparator = new NullSafeComparator((Comparator)NaturalOrderingKeyComparator.INSTANCE, true);
    private ReferenceResolver referenceResolver;
    private IndexResolver indexResolver;
    private CustomConversions customConversions;

    MappingRedisConverter(RedisMappingContext context) {
        this(context, null, null);
    }

    public MappingRedisConverter(RedisMappingContext mappingContext, IndexResolver indexResolver, ReferenceResolver referenceResolver) {
        this.mappingContext = mappingContext != null ? mappingContext : new RedisMappingContext();
        this.entityInstantiators = new EntityInstantiators();
        this.conversionService = new DefaultConversionService();
        this.customConversions = new CustomConversions();
        this.typeMapper = new DefaultTypeMapper((TypeAliasAccessor)new RedisTypeAliasAccessor((ConversionService)this.conversionService));
        this.referenceResolver = referenceResolver;
        this.indexResolver = indexResolver != null ? indexResolver : new PathIndexResolver(this.mappingContext);
    }

    public <R> R read(Class<R> type, RedisData source) {
        return this.readInternal("", type, source);
    }

    private <R> R readInternal(final String path, Class<R> type, final RedisData source) {
        if (source.getBucket() == null || source.getBucket().isEmpty()) {
            return null;
        }
        TypeInformation readType = this.typeMapper.readType((Object)source);
        TypeInformation typeToUse = readType != null ? readType : ClassTypeInformation.from(type);
        final RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity((TypeInformation<?>)typeToUse);
        if (this.customConversions.hasCustomReadTarget(Map.class, typeToUse.getType())) {
            HashMap<String, byte[]> partial = new HashMap<String, byte[]>();
            if (!path.isEmpty()) {
                for (Map.Entry<String, byte[]> entry : source.getBucket().extract(path + ".").entrySet()) {
                    partial.put(entry.getKey().substring(path.length() + 1), entry.getValue());
                }
            } else {
                partial.putAll(source.getBucket().asMap());
            }
            Object instance = this.conversionService.convert(partial, typeToUse.getType());
            if (entity.hasIdProperty()) {
                entity.getPropertyAccessor(instance).setProperty(entity.getIdProperty(), (Object)source.getId());
            }
            return (R)instance;
        }
        if (this.conversionService.canConvert(byte[].class, typeToUse.getType())) {
            return (R)this.conversionService.convert((Object)source.getBucket().get(StringUtils.hasText((String)path) ? path : "_raw"), typeToUse.getType());
        }
        EntityInstantiator instantiator = this.entityInstantiators.getInstantiatorFor(entity);
        Object instance = instantiator.createInstance(entity, (ParameterValueProvider)new PersistentEntityParameterValueProvider(entity, (PropertyValueProvider)new ConverterAwareParameterValueProvider(source, (ConversionService)this.conversionService), null));
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(instance);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<KeyValuePersistentProperty>(){

            public void doWithPersistentProperty(KeyValuePersistentProperty persistentProperty) {
                String currentPath = !path.isEmpty() ? path + "." + persistentProperty.getName() : persistentProperty.getName();
                PreferredConstructor constructor = entity.getPersistenceConstructor();
                if (constructor.isConstructorParameter((PersistentProperty)persistentProperty)) {
                    return;
                }
                if (persistentProperty.isMap()) {
                    if (MappingRedisConverter.this.conversionService.canConvert(byte[].class, persistentProperty.getMapValueType())) {
                        accessor.setProperty((PersistentProperty)persistentProperty, (Object)MappingRedisConverter.this.readMapOfSimpleTypes(currentPath, persistentProperty.getType(), persistentProperty.getComponentType(), persistentProperty.getMapValueType(), source));
                    } else {
                        accessor.setProperty((PersistentProperty)persistentProperty, (Object)MappingRedisConverter.this.readMapOfComplexTypes(currentPath, persistentProperty.getType(), persistentProperty.getComponentType(), persistentProperty.getMapValueType(), source));
                    }
                } else if (persistentProperty.isCollectionLike()) {
                    if (MappingRedisConverter.this.conversionService.canConvert(byte[].class, persistentProperty.getComponentType())) {
                        accessor.setProperty((PersistentProperty)persistentProperty, (Object)MappingRedisConverter.this.readCollectionOfSimpleTypes(currentPath, persistentProperty.getType(), persistentProperty.getTypeInformation().getComponentType().getActualType().getType(), source));
                    } else {
                        accessor.setProperty((PersistentProperty)persistentProperty, (Object)MappingRedisConverter.this.readCollectionOfComplexTypes(currentPath, persistentProperty.getType(), persistentProperty.getTypeInformation().getComponentType().getActualType().getType(), source.getBucket()));
                    }
                } else if (persistentProperty.isEntity() && !MappingRedisConverter.this.conversionService.canConvert(byte[].class, persistentProperty.getTypeInformation().getActualType().getType())) {
                    Class targetType = persistentProperty.getTypeInformation().getActualType().getType();
                    Bucket bucket = source.getBucket().extract(currentPath + ".");
                    RedisData source2 = new RedisData(bucket);
                    byte[] type = bucket.get(currentPath + "._class");
                    if (type != null && type.length > 0) {
                        source2.getBucket().put("_class", type);
                    }
                    accessor.setProperty((PersistentProperty)persistentProperty, MappingRedisConverter.this.readInternal(currentPath, targetType, source2));
                } else {
                    if (persistentProperty.isIdProperty() && StringUtils.isEmpty((Object)path.isEmpty())) {
                        if (source.getBucket().get(currentPath) == null) {
                            accessor.setProperty((PersistentProperty)persistentProperty, MappingRedisConverter.this.fromBytes(source.getBucket().get(currentPath), persistentProperty.getActualType()));
                        } else {
                            accessor.setProperty((PersistentProperty)persistentProperty, (Object)source.getId());
                        }
                    }
                    accessor.setProperty((PersistentProperty)persistentProperty, MappingRedisConverter.this.fromBytes(source.getBucket().get(currentPath), persistentProperty.getActualType()));
                }
            }
        });
        this.readAssociation(path, source, entity, accessor);
        return (R)instance;
    }

    private void readAssociation(final String path, final RedisData source, KeyValuePersistentEntity<?> entity, final PersistentPropertyAccessor accessor) {
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<KeyValuePersistentProperty>(){

            public void doWithAssociation(Association<KeyValuePersistentProperty> association) {
                String currentPath;
                String string = currentPath = !path.isEmpty() ? path + "." + ((KeyValuePersistentProperty)association.getInverse()).getName() : ((KeyValuePersistentProperty)association.getInverse()).getName();
                if (((KeyValuePersistentProperty)association.getInverse()).isCollectionLike()) {
                    Bucket bucket = source.getBucket().extract(currentPath + ".[");
                    Collection target = CollectionFactory.createCollection((Class)((KeyValuePersistentProperty)association.getInverse()).getType(), (Class)((KeyValuePersistentProperty)association.getInverse()).getComponentType(), (int)bucket.size());
                    for (Map.Entry<String, byte[]> entry : bucket.entrySet()) {
                        String referenceKey = MappingRedisConverter.this.fromBytes(entry.getValue(), String.class);
                        String[] args = referenceKey.split(":");
                        Map<byte[], byte[]> rawHash = MappingRedisConverter.this.referenceResolver.resolveReference((Serializable)((Object)args[1]), args[0]);
                        if (CollectionUtils.isEmpty(rawHash)) continue;
                        target.add(MappingRedisConverter.this.read(((KeyValuePersistentProperty)association.getInverse()).getActualType(), new RedisData(rawHash)));
                    }
                    accessor.setProperty(association.getInverse(), (Object)target);
                } else {
                    byte[] binKey = source.getBucket().get(currentPath);
                    if (binKey == null || binKey.length == 0) {
                        return;
                    }
                    String key = MappingRedisConverter.this.fromBytes(binKey, String.class);
                    String[] args = key.split(":");
                    Map<byte[], byte[]> rawHash = MappingRedisConverter.this.referenceResolver.resolveReference((Serializable)((Object)args[1]), args[0]);
                    if (!CollectionUtils.isEmpty(rawHash)) {
                        accessor.setProperty(association.getInverse(), MappingRedisConverter.this.read(((KeyValuePersistentProperty)association.getInverse()).getActualType(), new RedisData(rawHash)));
                    }
                }
            }
        });
    }

    public void write(Object source, RedisData sink) {
        RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity(source.getClass());
        if (!this.customConversions.hasCustomWriteTarget(source.getClass())) {
            this.typeMapper.writeType(ClassUtils.getUserClass((Object)source), (Object)sink);
        }
        sink.setKeyspace(entity.getKeySpace());
        this.writeInternal(entity.getKeySpace(), "", source, entity.getTypeInformation(), sink);
        sink.setId((String)this.getConversionService().convert(entity.getIdentifierAccessor(source).getIdentifier(), String.class));
        Long ttl = entity.getTimeToLiveAccessor().getTimeToLive(source);
        if (ttl != null && ttl > 0L) {
            sink.setTimeToLive(ttl);
        }
        for (IndexedData indexeData : this.indexResolver.resolveIndexesFor(entity.getTypeInformation(), source)) {
            sink.addIndexedData(indexeData);
        }
    }

    private void writeInternal(final String keyspace, final String path, Object value, TypeInformation<?> typeHint, final RedisData sink) {
        if (value == null) {
            return;
        }
        if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
            if (this.customConversions.getCustomWriteTarget(value.getClass()).equals(byte[].class)) {
                sink.getBucket().put(StringUtils.hasText((String)path) ? path : "_raw", (byte[])this.conversionService.convert(value, byte[].class));
            } else {
                this.writeToBucket(path, value, sink);
            }
            return;
        }
        if (value.getClass() != typeHint.getType()) {
            sink.getBucket().put(!path.isEmpty() ? path + "._class" : "_class", this.toBytes(value.getClass().getName()));
        }
        RedisPersistentEntity<?> entity = this.mappingContext.getPersistentEntity(value.getClass());
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        entity.doWithProperties((PropertyHandler)new PropertyHandler<KeyValuePersistentProperty>(){

            public void doWithPersistentProperty(KeyValuePersistentProperty persistentProperty) {
                String propertyStringPath = (!path.isEmpty() ? path + "." : "") + persistentProperty.getName();
                if (persistentProperty.isIdProperty()) {
                    sink.getBucket().put(propertyStringPath, MappingRedisConverter.this.toBytes(accessor.getProperty((PersistentProperty)persistentProperty)));
                    return;
                }
                if (persistentProperty.isMap()) {
                    MappingRedisConverter.this.writeMap(keyspace, propertyStringPath, persistentProperty.getMapValueType(), (Map)accessor.getProperty((PersistentProperty)persistentProperty), sink);
                } else if (persistentProperty.isCollectionLike()) {
                    MappingRedisConverter.this.writeCollection(keyspace, propertyStringPath, (Collection)accessor.getProperty((PersistentProperty)persistentProperty), persistentProperty.getTypeInformation().getComponentType(), sink);
                } else if (persistentProperty.isEntity()) {
                    MappingRedisConverter.this.writeInternal(keyspace, propertyStringPath, accessor.getProperty((PersistentProperty)persistentProperty), persistentProperty.getTypeInformation().getActualType(), sink);
                } else {
                    Object propertyValue = accessor.getProperty((PersistentProperty)persistentProperty);
                    sink.getBucket().put(propertyStringPath, MappingRedisConverter.this.toBytes(propertyValue));
                }
            }
        });
        this.writeAssiciation(keyspace, path, entity, value, sink);
    }

    private void writeAssiciation(String keyspace, final String path, KeyValuePersistentEntity<?> entity, Object value, final RedisData sink) {
        if (value == null) {
            return;
        }
        final PersistentPropertyAccessor accessor = entity.getPropertyAccessor(value);
        entity.doWithAssociations((AssociationHandler)new AssociationHandler<KeyValuePersistentProperty>(){

            public void doWithAssociation(Association<KeyValuePersistentProperty> association) {
                Object refObject = accessor.getProperty(association.getInverse());
                if (refObject == null) {
                    return;
                }
                if (((KeyValuePersistentProperty)association.getInverse()).isCollectionLike()) {
                    RedisPersistentEntity<?> ref = MappingRedisConverter.this.mappingContext.getPersistentEntity((TypeInformation<?>)((KeyValuePersistentProperty)association.getInverse()).getTypeInformation().getComponentType().getActualType());
                    String keyspace = ref.getKeySpace();
                    String propertyStringPath = (!path.isEmpty() ? path + "." : "") + ((KeyValuePersistentProperty)association.getInverse()).getName();
                    int i = 0;
                    for (Object o : (Collection)refObject) {
                        Object refId = ref.getPropertyAccessor(o).getProperty(ref.getIdProperty());
                        sink.getBucket().put(propertyStringPath + ".[" + i + "]", MappingRedisConverter.this.toBytes(keyspace + ":" + refId));
                        ++i;
                    }
                } else {
                    RedisPersistentEntity<?> ref = MappingRedisConverter.this.mappingContext.getPersistentEntity((TypeInformation<?>)((KeyValuePersistentProperty)association.getInverse()).getTypeInformation());
                    String keyspace = ref.getKeySpace();
                    Object refId = ref.getPropertyAccessor(refObject).getProperty(ref.getIdProperty());
                    String propertyStringPath = (!path.isEmpty() ? path + "." : "") + ((KeyValuePersistentProperty)association.getInverse()).getName();
                    sink.getBucket().put(propertyStringPath, MappingRedisConverter.this.toBytes(keyspace + ":" + refId));
                }
            }
        });
    }

    private void writeCollection(String keyspace, String path, Collection<?> values, TypeInformation<?> typeHint, RedisData sink) {
        if (values == null) {
            return;
        }
        int i = 0;
        for (Object value : values) {
            String currentPath = path + ".[" + i + "]";
            if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
                this.writeToBucket(currentPath, value, sink);
            } else {
                this.writeInternal(keyspace, currentPath, value, typeHint, sink);
            }
            ++i;
        }
    }

    private void writeToBucket(String path, Object value, RedisData sink) {
        if (value == null) {
            return;
        }
        if (this.customConversions.hasCustomWriteTarget(value.getClass())) {
            Class<?> targetType = this.customConversions.getCustomWriteTarget(value.getClass());
            if (ClassUtils.isAssignable(Map.class, targetType)) {
                Map map = (Map)this.conversionService.convert(value, targetType);
                for (Map.Entry entry : map.entrySet()) {
                    sink.getBucket().put(path + (StringUtils.hasText((String)path) ? "." : "") + entry.getKey(), this.toBytes(entry.getValue()));
                }
            } else if (ClassUtils.isAssignable(byte[].class, targetType)) {
                sink.getBucket().put(path, this.toBytes(value));
            } else {
                throw new IllegalArgumentException(String.format("Cannot convert value '%s' of type %s to bytes.", value, value.getClass()));
            }
        }
    }

    private Collection<?> readCollectionOfSimpleTypes(String path, Class<?> collectionType, Class<?> valueType, RedisData source) {
        Bucket partial = source.getBucket().extract(path + ".[");
        ArrayList<String> keys = new ArrayList<String>(partial.keySet());
        keys.sort(this.listKeyComparator);
        Collection target = CollectionFactory.createCollection(collectionType, valueType, (int)partial.size());
        for (String key : keys) {
            target.add(this.fromBytes(partial.get(key), valueType));
        }
        return target;
    }

    private Collection<?> readCollectionOfComplexTypes(String path, Class<?> collectionType, Class<?> valueType, Bucket source) {
        ArrayList<String> keys = new ArrayList<String>(source.extractAllKeysFor(path));
        keys.sort(this.listKeyComparator);
        Collection target = CollectionFactory.createCollection(collectionType, valueType, (int)keys.size());
        for (String key : keys) {
            Bucket elementData = source.extract(key);
            byte[] typeInfo = elementData.get(key + "._class");
            if (typeInfo != null && typeInfo.length > 0) {
                elementData.put("_class", typeInfo);
            }
            Object o = this.readInternal(key, valueType, new RedisData(elementData));
            target.add(o);
        }
        return target;
    }

    private void writeMap(String keyspace, String path, Class<?> mapValueType, Map<?, ?> source, RedisData sink) {
        if (CollectionUtils.isEmpty(source)) {
            return;
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            if (entry.getValue() == null || entry.getKey() == null) continue;
            String currentPath = path + ".[" + entry.getKey() + "]";
            if (this.customConversions.hasCustomWriteTarget(entry.getValue().getClass())) {
                this.writeToBucket(currentPath, entry.getValue(), sink);
                continue;
            }
            this.writeInternal(keyspace, currentPath, entry.getValue(), (TypeInformation<?>)ClassTypeInformation.from(mapValueType), sink);
        }
    }

    private Map<?, ?> readMapOfSimpleTypes(String path, Class<?> mapType, Class<?> keyType, Class<?> valueType, RedisData source) {
        Bucket partial = source.getBucket().extract(path + ".[");
        Map target = CollectionFactory.createMap(mapType, (int)partial.size());
        for (Map.Entry<String, byte[]> entry : partial.entrySet()) {
            String regex = "^(" + Pattern.quote(path) + "\\.\\[)(.*?)(\\])";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(entry.getKey());
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format("Cannot extract map value for key '%s' in path '%s'.", entry.getKey(), path));
            }
            String key = matcher.group(2);
            target.put(key, this.fromBytes(entry.getValue(), valueType));
        }
        return target;
    }

    private Map<?, ?> readMapOfComplexTypes(String path, Class<?> mapType, Class<?> keyType, Class<?> valueType, RedisData source) {
        Set<String> keys = source.getBucket().extractAllKeysFor(path);
        Map target = CollectionFactory.createMap(mapType, (int)keys.size());
        for (String key : keys) {
            String regex = "^(" + Pattern.quote(path) + "\\.\\[)(.*?)(\\])";
            Pattern pattern = Pattern.compile(regex);
            Matcher matcher = pattern.matcher(key);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format("Cannot extract map value for key '%s' in path '%s'.", key, path));
            }
            String mapKey = matcher.group(2);
            Bucket partial = source.getBucket().extract(key);
            byte[] typeInfo = partial.get(key + "._class");
            if (typeInfo != null && typeInfo.length > 0) {
                partial.put("_class", typeInfo);
            }
            Object o = this.readInternal(key, valueType, new RedisData(partial));
            target.put(mapKey, o);
        }
        return target;
    }

    public byte[] toBytes(Object source) {
        if (source instanceof byte[]) {
            return (byte[])source;
        }
        return (byte[])this.conversionService.convert(source, byte[].class);
    }

    public <T> T fromBytes(byte[] source, Class<T> type) {
        return (T)this.conversionService.convert((Object)source, type);
    }

    public void setCustomConversions(CustomConversions customConversions) {
        this.customConversions = customConversions != null ? customConversions : new CustomConversions();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setIndexResolver(IndexResolver indexResolver) {
        this.indexResolver = indexResolver;
    }

    public RedisMappingContext getMappingContext() {
        return this.mappingContext;
    }

    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void afterPropertiesSet() {
        this.initializeConverters();
    }

    private void initializeConverters() {
        this.customConversions.registerConvertersIn(this.conversionService);
    }

    private static enum NaturalOrderingKeyComparator implements Comparator<String>
    {
        INSTANCE;


        @Override
        public int compare(String s1, String s2) {
            Part thatPart;
            Part thisPart;
            int s1offset = 0;
            for (int s2offset = 0; s1offset < s1.length() && s2offset < s2.length(); s1offset += thisPart.length(), s2offset += thatPart.length()) {
                thisPart = this.extractPart(s1, s1offset);
                int result = thisPart.compareTo(thatPart = this.extractPart(s2, s2offset));
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        private Part extractPart(String source, int offset) {
            StringBuilder builder = new StringBuilder();
            char c = source.charAt(offset);
            builder.append(c);
            boolean isDigit = Character.isDigit(c);
            for (int i = offset + 1; i < source.length(); ++i) {
                c = source.charAt(i);
                if (isDigit && !Character.isDigit(c) || !isDigit && Character.isDigit(c)) break;
                builder.append(c);
            }
            return new Part(builder.toString(), isDigit);
        }

        private static class Part
        implements Comparable<Part> {
            private final String rawValue;
            private final Long longValue;

            Part(String value, boolean isDigit) {
                this.rawValue = value;
                this.longValue = isDigit ? Long.valueOf(value) : null;
            }

            boolean isNumeric() {
                return this.longValue != null;
            }

            int length() {
                return this.rawValue.length();
            }

            @Override
            public int compareTo(Part that) {
                if (this.isNumeric() && that.isNumeric()) {
                    return this.longValue.compareTo(that.longValue);
                }
                return this.rawValue.compareTo(that.rawValue);
            }
        }
    }

    static enum ClassNameKeySpaceResolver implements KeySpaceResolver
    {
        INSTANCE;


        public String resolveKeySpace(Class<?> type) {
            Assert.notNull(type, (String)"Type must not be null!");
            return ClassUtils.getUserClass(type).getName();
        }
    }

    private static class RedisTypeAliasAccessor
    implements TypeAliasAccessor<RedisData> {
        private final String typeKey;
        private final ConversionService conversionService;

        RedisTypeAliasAccessor(ConversionService conversionService) {
            this(conversionService, "_class");
        }

        RedisTypeAliasAccessor(ConversionService conversionService, String typeKey) {
            this.conversionService = conversionService;
            this.typeKey = typeKey;
        }

        public Object readAliasFrom(RedisData source) {
            return this.conversionService.convert((Object)source.getBucket().get(this.typeKey), String.class);
        }

        public void writeTypeTo(RedisData sink, Object alias) {
            sink.getBucket().put(this.typeKey, (byte[])this.conversionService.convert(alias, byte[].class));
        }
    }

    private static class ConverterAwareParameterValueProvider
    implements PropertyValueProvider<KeyValuePersistentProperty> {
        private final RedisData source;
        private final ConversionService conversionService;

        public ConverterAwareParameterValueProvider(RedisData source, ConversionService conversionService) {
            this.source = source;
            this.conversionService = conversionService;
        }

        public <T> T getPropertyValue(KeyValuePersistentProperty property) {
            return (T)this.conversionService.convert((Object)this.source.getBucket().get(property.getName()), property.getActualType());
        }
    }
}

