/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import lombok.NonNull;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.convert.Converters;
import org.springframework.data.redis.connection.jedis.JedisConnection;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class JedisStringCommands
implements RedisStringCommands {
    @NonNull
    private final JedisConnection connection;

    @Override
    public byte[] get(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().get(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().get(key)));
                return null;
            }
            return this.connection.getJedis().get(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getSet(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().getSet(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().getSet(key, value)));
                return null;
            }
            return this.connection.getJedis().getSet(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public List<byte[]> mGet(byte[] ... keys) {
        Assert.notNull((Object)keys, (String)"Keys must not be null!");
        Assert.noNullElements((Object[])keys, (String)"Keys must not contain null elements!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().mget(keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().mget(keys)));
                return null;
            }
            return this.connection.getJedis().mget(keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean set(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().set(key, value), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().set(key, value), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.connection.getJedis().set(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean set(byte[] key, byte[] value, Expiration expiration, RedisStringCommands.SetOption option) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        Assert.notNull((Object)expiration, (String)"Expiration must not be null!");
        Assert.notNull((Object)((Object)option), (String)"Option must not be null!");
        if (expiration.isPersistent()) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
                return this.set(key, value);
            }
            try {
                byte[] nxxx = JedisConverters.toSetCommandNxXxArgument(option);
                if (this.isPipelined()) {
                    this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().set(key, value, nxxx), Converters.stringToBooleanConverter(), () -> false));
                    return null;
                }
                if (this.isQueueing()) {
                    this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().set(key, value, nxxx), Converters.stringToBooleanConverter(), () -> false));
                    return null;
                }
                return Converters.stringToBoolean(this.connection.getJedis().set(key, value, nxxx));
            }
            catch (Exception ex) {
                throw this.convertJedisAccessException(ex);
            }
        }
        if (ObjectUtils.nullSafeEquals((Object)((Object)RedisStringCommands.SetOption.UPSERT), (Object)((Object)option))) {
            if (ObjectUtils.nullSafeEquals((Object)((Object)TimeUnit.MILLISECONDS), (Object)((Object)expiration.getTimeUnit()))) {
                return this.pSetEx(key, expiration.getExpirationTime(), value);
            }
            return this.setEx(key, expiration.getExpirationTime(), value);
        }
        byte[] nxxx = JedisConverters.toSetCommandNxXxArgument(option);
        byte[] expx = JedisConverters.toSetCommandExPxArgument(expiration);
        try {
            if (this.isPipelined()) {
                if (expiration.getExpirationTime() > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Expiration.expirationTime must be less than Integer.MAX_VALUE for pipeline in Jedis.");
                }
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().set(key, value, nxxx, expx, (int)expiration.getExpirationTime()), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            if (this.isQueueing()) {
                if (expiration.getExpirationTime() > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Expiration.expirationTime must be less than Integer.MAX_VALUE for transactions in Jedis.");
                }
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().set(key, value, nxxx, expx, (int)expiration.getExpirationTime()), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            return Converters.stringToBoolean(this.connection.getJedis().set(key, value, nxxx, expx, expiration.getExpirationTime()));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setNX(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().setnx(key, value), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().setnx(key, value), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().setnx(key, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setEx(byte[] key, long seconds, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        if (seconds > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Time must be less than Integer.MAX_VALUE for setEx in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().setex(key, (int)seconds, value), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().setex(key, (int)seconds, value), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            return Converters.stringToBoolean(this.connection.getJedis().setex(key, (int)seconds, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean pSetEx(byte[] key, long milliseconds, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().psetex(key, milliseconds, value), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().psetex(key, milliseconds, value), Converters.stringToBooleanConverter(), () -> false));
                return null;
            }
            return Converters.stringToBoolean(this.connection.getJedis().psetex(key, milliseconds, value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean mSet(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().mset(JedisConverters.toByteArrays(tuples)), Converters.stringToBooleanConverter()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().mset(JedisConverters.toByteArrays(tuples)), Converters.stringToBooleanConverter()));
                return null;
            }
            return Converters.stringToBoolean(this.connection.getJedis().mset(JedisConverters.toByteArrays(tuples)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean mSetNX(Map<byte[], byte[]> tuples) {
        Assert.notNull(tuples, (String)"Tuples must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().msetnx(JedisConverters.toByteArrays(tuples)), JedisConverters.longToBoolean()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().msetnx(JedisConverters.toByteArrays(tuples)), JedisConverters.longToBoolean()));
                return null;
            }
            return JedisConverters.toBoolean(this.connection.getJedis().msetnx(JedisConverters.toByteArrays(tuples)));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incr(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().incr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().incr(key)));
                return null;
            }
            return this.connection.getJedis().incr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long incrBy(byte[] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().incrBy(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().incrBy(key, value)));
                return null;
            }
            return this.connection.getJedis().incrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Double incrBy(byte[] key, double value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().incrByFloat(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().incrByFloat(key, value)));
                return null;
            }
            return this.connection.getJedis().incrByFloat(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decr(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().decr(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().decr(key)));
                return null;
            }
            return this.connection.getJedis().decr(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long decrBy(byte[] key, long value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().decrBy(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().decrBy(key, value)));
                return null;
            }
            return this.connection.getJedis().decrBy(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long append(byte[] key, byte[] value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().append(key, value)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().append(key, value)));
                return null;
            }
            return this.connection.getJedis().append(key, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public byte[] getRange(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        if (start > Integer.MAX_VALUE || end > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Start and end must be less than Integer.MAX_VALUE for getRange in Jedis.");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().substr(key, (int)start, (int)end), JedisConverters.stringToBytes()));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().substr(key, (int)start, (int)end), JedisConverters.stringToBytes()));
                return null;
            }
            return this.connection.getJedis().substr(key, (int)start, (int)end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public void setRange(byte[] key, byte[] value, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        Assert.notNull((Object)value, (String)"Value must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newStatusResult(this.connection.getRequiredPipeline().setrange(key, offset, value)));
                return;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newStatusResult(this.connection.getRequiredTransaction().setrange(key, offset, value)));
                return;
            }
            this.connection.getJedis().setrange(key, offset, value);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean getBit(byte[] key, long offset) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().getbit(key, offset)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().getbit(key, offset)));
                return null;
            }
            Boolean getBit = this.connection.getJedis().getbit(key, offset);
            if (getBit instanceof Long) {
                return (Long)((Object)getBit) == 0L ? Boolean.FALSE : Boolean.TRUE;
            }
            return getBit;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Boolean setBit(byte[] key, long offset, boolean value) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().setbit(key, offset, JedisConverters.toBit(value))));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().setbit(key, offset, JedisConverters.toBit(value))));
                return null;
            }
            return this.connection.getJedis().setbit(key, offset, JedisConverters.toBit(value));
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().bitcount(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().bitcount(key)));
                return null;
            }
            return this.connection.getJedis().bitcount(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitCount(byte[] key, long start, long end) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().bitcount(key, start, end)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().bitcount(key, start, end)));
                return null;
            }
            return this.connection.getJedis().bitcount(key, start, end);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long bitOp(RedisStringCommands.BitOperation op, byte[] destination, byte[] ... keys) {
        Assert.notNull((Object)((Object)op), (String)"BitOperation must not be null!");
        Assert.notNull((Object)destination, (String)"Destination key must not be null!");
        if (op == RedisStringCommands.BitOperation.NOT && keys.length > 1) {
            throw new UnsupportedOperationException("Bitop NOT should only be performed against one key");
        }
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().bitop(JedisConverters.toBitOp(op), destination, keys)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().bitop(JedisConverters.toBitOp(op), destination, keys)));
                return null;
            }
            return this.connection.getJedis().bitop(JedisConverters.toBitOp(op), destination, keys);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    @Override
    public Long strLen(byte[] key) {
        Assert.notNull((Object)key, (String)"Key must not be null!");
        try {
            if (this.isPipelined()) {
                this.pipeline(this.connection.newJedisResult(this.connection.getRequiredPipeline().strlen(key)));
                return null;
            }
            if (this.isQueueing()) {
                this.transaction(this.connection.newJedisResult(this.connection.getRequiredTransaction().strlen(key)));
                return null;
            }
            return this.connection.getJedis().strlen(key);
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private boolean isPipelined() {
        return this.connection.isPipelined();
    }

    private void pipeline(JedisResult result) {
        this.connection.pipeline(result);
    }

    private boolean isQueueing() {
        return this.connection.isQueueing();
    }

    private void transaction(JedisResult result) {
        this.connection.transaction(result);
    }

    private RuntimeException convertJedisAccessException(Exception ex) {
        return this.connection.convertJedisAccessException(ex);
    }

    public JedisStringCommands(@NonNull JedisConnection connection) {
        if (connection == null) {
            throw new NullPointerException("connection");
        }
        this.connection = connection;
    }
}

