/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import org.springframework.data.redis.serializer.RedisSerializationContext;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultRedisSerializationContext<K, V>
implements RedisSerializationContext<K, V> {
    private final RedisSerializationContext.SerializationPair<K> keyTuple;
    private final RedisSerializationContext.SerializationPair<V> valueTuple;
    private final RedisSerializationContext.SerializationPair<?> hashKeyTuple;
    private final RedisSerializationContext.SerializationPair<?> hashValueTuple;
    private final RedisSerializationContext.SerializationPair<String> stringTuple;

    private DefaultRedisSerializationContext(RedisSerializationContext.SerializationPair<K> keyTuple, RedisSerializationContext.SerializationPair<V> valueTuple, RedisSerializationContext.SerializationPair<?> hashKeyTuple, RedisSerializationContext.SerializationPair<?> hashValueTuple, RedisSerializationContext.SerializationPair<String> stringTuple) {
        this.keyTuple = keyTuple;
        this.valueTuple = valueTuple;
        this.hashKeyTuple = hashKeyTuple;
        this.hashValueTuple = hashValueTuple;
        this.stringTuple = stringTuple;
    }

    @Override
    public RedisSerializationContext.SerializationPair<K> getKeySerializationPair() {
        return this.keyTuple;
    }

    @Override
    public RedisSerializationContext.SerializationPair<V> getValueSerializationPair() {
        return this.valueTuple;
    }

    @Override
    public <HK> RedisSerializationContext.SerializationPair<HK> getHashKeySerializationPair() {
        return this.hashKeyTuple;
    }

    @Override
    public <HV> RedisSerializationContext.SerializationPair<HV> getHashValueSerializationPair() {
        return this.hashValueTuple;
    }

    @Override
    public RedisSerializationContext.SerializationPair<String> getStringSerializationPair() {
        return this.stringTuple;
    }

    static class DefaultRedisSerializationContextBuilder<K, V>
    implements RedisSerializationContext.RedisSerializationContextBuilder<K, V> {
        @Nullable
        private RedisSerializationContext.SerializationPair<K> keyTuple;
        @Nullable
        private RedisSerializationContext.SerializationPair<V> valueTuple;
        @Nullable
        private RedisSerializationContext.SerializationPair<?> hashKeyTuple;
        @Nullable
        private RedisSerializationContext.SerializationPair<?> hashValueTuple;
        private RedisSerializationContext.SerializationPair<String> stringTuple = RedisSerializationContext.SerializationPair.fromSerializer(new StringRedisSerializer());

        DefaultRedisSerializationContextBuilder() {
        }

        @Override
        public RedisSerializationContext.RedisSerializationContextBuilder<K, V> key(RedisSerializationContext.SerializationPair<K> tuple) {
            Assert.notNull(tuple, (String)"SerializationPair must not be null!");
            this.keyTuple = tuple;
            return this;
        }

        @Override
        public RedisSerializationContext.RedisSerializationContextBuilder<K, V> value(RedisSerializationContext.SerializationPair<V> tuple) {
            Assert.notNull(tuple, (String)"SerializationPair must not be null!");
            this.valueTuple = tuple;
            return this;
        }

        @Override
        public RedisSerializationContext.RedisSerializationContextBuilder<K, V> hashKey(RedisSerializationContext.SerializationPair<?> tuple) {
            Assert.notNull(tuple, (String)"SerializationPair must not be null!");
            this.hashKeyTuple = tuple;
            return this;
        }

        @Override
        public RedisSerializationContext.RedisSerializationContextBuilder<K, V> hashValue(RedisSerializationContext.SerializationPair<?> tuple) {
            Assert.notNull(tuple, (String)"SerializationPair must not be null!");
            this.hashValueTuple = tuple;
            return this;
        }

        @Override
        public RedisSerializationContext.RedisSerializationContextBuilder<K, V> string(RedisSerializationContext.SerializationPair<String> tuple) {
            Assert.notNull(tuple, (String)"SerializationPair must not be null!");
            this.hashValueTuple = tuple;
            return this;
        }

        @Override
        public RedisSerializationContext<K, V> build() {
            Assert.notNull(this.keyTuple, (String)"Key SerializationPair must not be null!");
            Assert.notNull(this.valueTuple, (String)"Value SerializationPair must not be null!");
            Assert.notNull(this.hashKeyTuple, (String)"HashKey SerializationPair must not be null!");
            Assert.notNull(this.hashValueTuple, (String)"ValueKey SerializationPair must not be null!");
            return new DefaultRedisSerializationContext(this.keyTuple, this.valueTuple, this.hashKeyTuple, this.hashValueTuple, this.stringTuple);
        }
    }
}

