/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.List;
import java.util.Map;
import org.springframework.data.geo.Circle;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.GeoResults;
import org.springframework.data.geo.Metric;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.domain.geo.BoundingBox;
import org.springframework.data.redis.domain.geo.GeoReference;
import org.springframework.data.redis.domain.geo.GeoShape;
import org.springframework.lang.Nullable;

public interface GeoOperations<K, M> {
    @Nullable
    public Long add(K var1, Point var2, M var3);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, Point point, M member) {
        return this.add(key, point, member);
    }

    @Nullable
    public Long add(K var1, RedisGeoCommands.GeoLocation<M> var2);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, RedisGeoCommands.GeoLocation<M> location) {
        return this.add(key, location);
    }

    @Nullable
    public Long add(K var1, Map<M, Point> var2);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, Map<M, Point> memberCoordinateMap) {
        return this.add(key, memberCoordinateMap);
    }

    @Nullable
    public Long add(K var1, Iterable<RedisGeoCommands.GeoLocation<M>> var2);

    @Deprecated
    @Nullable
    default public Long geoAdd(K key, Iterable<RedisGeoCommands.GeoLocation<M>> locations) {
        return this.add(key, locations);
    }

    @Nullable
    public Distance distance(K var1, M var2, M var3);

    @Deprecated
    @Nullable
    default public Distance geoDist(K key, M member1, M member2) {
        return this.distance(key, member1, member2);
    }

    @Nullable
    public Distance distance(K var1, M var2, M var3, Metric var4);

    @Deprecated
    @Nullable
    default public Distance geoDist(K key, M member1, M member2, Metric metric) {
        return this.distance(key, member1, member2, metric);
    }

    @Nullable
    public List<String> hash(K var1, M ... var2);

    @Deprecated
    @Nullable
    default public List<String> geoHash(K key, M ... members) {
        return this.hash(key, members);
    }

    @Nullable
    public List<Point> position(K var1, M ... var2);

    @Deprecated
    @Nullable
    default public List<Point> geoPos(K key, M ... members) {
        return this.position(key, members);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, Circle var2);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(K key, Circle within) {
        return this.radius(key, within);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, Circle var2, RedisGeoCommands.GeoRadiusCommandArgs var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadius(K key, Circle within, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.radius(key, within, args);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, M var2, double var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, double radius) {
        return this.radius(key, member, radius);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, M var2, Distance var3);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, Distance distance) {
        return this.radius(key, member, distance);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> radius(K var1, M var2, Distance var3, RedisGeoCommands.GeoRadiusCommandArgs var4);

    @Deprecated
    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> geoRadiusByMember(K key, M member, Distance distance, RedisGeoCommands.GeoRadiusCommandArgs args) {
        return this.radius(key, member, distance, args);
    }

    @Nullable
    public Long remove(K var1, M ... var2);

    @Deprecated
    @Nullable
    default public Long geoRemove(K key, M ... members) {
        return this.remove(key, members);
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(K key, Circle within) {
        return this.search(key, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(K key, GeoReference<M> reference, Distance radius) {
        return this.search(key, reference, radius, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(K key, GeoReference<M> reference, Distance radius, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(key, reference, GeoShape.byRadius(radius), args);
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(K key, GeoReference<M> reference, BoundingBox boundingBox) {
        return this.search(key, reference, boundingBox, RedisGeoCommands.GeoSearchCommandArgs.newGeoSearchArgs());
    }

    @Nullable
    default public GeoResults<RedisGeoCommands.GeoLocation<M>> search(K key, GeoReference<M> reference, BoundingBox boundingBox, RedisGeoCommands.GeoSearchCommandArgs args) {
        return this.search(key, reference, GeoShape.byBox(boundingBox), args);
    }

    @Nullable
    public GeoResults<RedisGeoCommands.GeoLocation<M>> search(K var1, GeoReference<M> var2, GeoShape var3, RedisGeoCommands.GeoSearchCommandArgs var4);

    @Nullable
    default public Long searchAndStore(K key, K destKey, Circle within) {
        return this.searchAndStore(key, destKey, GeoReference.fromCircle(within), GeoShape.byRadius(within.getRadius()), RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    @Nullable
    default public Long searchAndStore(K key, K destKey, GeoReference<M> reference, Distance radius) {
        return this.searchAndStore(key, destKey, reference, radius, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    @Nullable
    default public Long searchAndStore(K key, K destKey, GeoReference<M> reference, Distance radius, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(key, destKey, reference, GeoShape.byRadius(radius), args);
    }

    @Nullable
    default public Long searchAndStore(K key, K destKey, GeoReference<M> reference, BoundingBox boundingBox) {
        return this.searchAndStore(key, destKey, reference, boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs.newGeoSearchStoreArgs());
    }

    @Nullable
    default public Long searchAndStore(K key, K destKey, GeoReference<M> reference, BoundingBox boundingBox, RedisGeoCommands.GeoSearchStoreCommandArgs args) {
        return this.searchAndStore(key, destKey, reference, GeoShape.byBox(boundingBox), args);
    }

    @Nullable
    public Long searchAndStore(K var1, K var2, GeoReference<M> var3, GeoShape var4, RedisGeoCommands.GeoSearchStoreCommandArgs var5);
}

