/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.jedis;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.ExceptionTranslationStrategy;
import org.springframework.data.redis.FallbackExceptionTranslationStrategy;
import org.springframework.data.redis.RedisSystemException;
import org.springframework.data.redis.connection.AbstractRedisConnection;
import org.springframework.data.redis.connection.FutureResult;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.data.redis.connection.RedisGeoCommands;
import org.springframework.data.redis.connection.RedisHashCommands;
import org.springframework.data.redis.connection.RedisHyperLogLogCommands;
import org.springframework.data.redis.connection.RedisKeyCommands;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPipelineException;
import org.springframework.data.redis.connection.RedisScriptingCommands;
import org.springframework.data.redis.connection.RedisServerCommands;
import org.springframework.data.redis.connection.RedisSetCommands;
import org.springframework.data.redis.connection.RedisStreamCommands;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.connection.RedisSubscribedConnectionException;
import org.springframework.data.redis.connection.RedisZSetCommands;
import org.springframework.data.redis.connection.Subscription;
import org.springframework.data.redis.connection.convert.TransactionResultConverter;
import org.springframework.data.redis.connection.jedis.JedisClientUtils;
import org.springframework.data.redis.connection.jedis.JedisConverters;
import org.springframework.data.redis.connection.jedis.JedisGeoCommands;
import org.springframework.data.redis.connection.jedis.JedisHashCommands;
import org.springframework.data.redis.connection.jedis.JedisHyperLogLogCommands;
import org.springframework.data.redis.connection.jedis.JedisInvoker;
import org.springframework.data.redis.connection.jedis.JedisKeyCommands;
import org.springframework.data.redis.connection.jedis.JedisListCommands;
import org.springframework.data.redis.connection.jedis.JedisMessageListener;
import org.springframework.data.redis.connection.jedis.JedisResult;
import org.springframework.data.redis.connection.jedis.JedisScriptingCommands;
import org.springframework.data.redis.connection.jedis.JedisSentinelConnection;
import org.springframework.data.redis.connection.jedis.JedisServerCommands;
import org.springframework.data.redis.connection.jedis.JedisSetCommands;
import org.springframework.data.redis.connection.jedis.JedisStreamCommands;
import org.springframework.data.redis.connection.jedis.JedisStringCommands;
import org.springframework.data.redis.connection.jedis.JedisSubscription;
import org.springframework.data.redis.connection.jedis.JedisZSetCommands;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.BinaryJedisPubSub;
import redis.clients.jedis.Client;
import redis.clients.jedis.Connection;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.MultiKeyPipelineBase;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.Response;
import redis.clients.jedis.Transaction;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.util.Pool;

public class JedisConnection
extends AbstractRedisConnection {
    private static final ExceptionTranslationStrategy EXCEPTION_TRANSLATION = new FallbackExceptionTranslationStrategy(JedisConverters.exceptionConverter());
    private final Jedis jedis;
    private final JedisInvoker invoker = new JedisInvoker((directFunction, pipelineFunction, converter, nullDefault) -> this.doInvoke(false, directFunction, pipelineFunction, (Converter<Object, Object>)converter, nullDefault));
    private final JedisInvoker statusInvoker = new JedisInvoker((directFunction, pipelineFunction, converter, nullDefault) -> this.doInvoke(true, directFunction, pipelineFunction, (Converter<Object, Object>)converter, nullDefault));
    @Nullable
    private final Pool<Jedis> pool;
    private final String clientName;
    private final JedisClientConfig nodeConfig;
    private final JedisClientConfig sentinelConfig;
    private List<JedisResult> pipelinedResults = new ArrayList<JedisResult>();
    private Queue<FutureResult<Response<?>>> txResults = new LinkedList();
    @Nullable
    private volatile JedisSubscription subscription;
    @Nullable
    private volatile Transaction transaction;
    @Nullable
    private volatile Pipeline pipeline;
    private boolean convertPipelineAndTxResults = true;

    public JedisConnection(Jedis jedis) {
        this(jedis, null, 0);
    }

    public JedisConnection(Jedis jedis, Pool<Jedis> pool, int dbIndex) {
        this(jedis, pool, dbIndex, null);
    }

    protected JedisConnection(Jedis jedis, @Nullable Pool<Jedis> pool, int dbIndex, @Nullable String clientName) {
        this(jedis, pool, (JedisClientConfig)JedisConnection.createConfig(dbIndex, clientName), (JedisClientConfig)JedisConnection.createConfig(dbIndex, clientName));
    }

    private static DefaultJedisClientConfig createConfig(int dbIndex, @Nullable String clientName) {
        return DefaultJedisClientConfig.builder().database(dbIndex).clientName(clientName).build();
    }

    protected JedisConnection(Jedis jedis, @Nullable Pool<Jedis> pool, JedisClientConfig nodeConfig, JedisClientConfig sentinelConfig) {
        this.jedis = jedis;
        this.pool = pool;
        this.clientName = nodeConfig.getClientName();
        this.nodeConfig = nodeConfig;
        this.sentinelConfig = sentinelConfig;
        if (nodeConfig.getDatabase() != jedis.getDB()) {
            try {
                this.select(nodeConfig.getDatabase());
            }
            catch (DataAccessException ex) {
                this.close();
                throw ex;
            }
        }
    }

    @Nullable
    private Object doInvoke(boolean status, Function<Jedis, Object> directFunction, Function<MultiKeyPipelineBase, Response<Object>> pipelineFunction, Converter<Object, Object> converter, Supplier<Object> nullDefault) {
        return this.doWithJedis((Jedis it) -> {
            if (this.isPipelined()) {
                Response response = (Response)pipelineFunction.apply((MultiKeyPipelineBase)this.getRequiredPipeline());
                this.pipeline(status ? this.newStatusResult(response) : this.newJedisResult(response, converter, nullDefault));
                return null;
            }
            if (this.isQueueing()) {
                Response response = (Response)pipelineFunction.apply((MultiKeyPipelineBase)this.getRequiredTransaction());
                this.transaction(status ? this.newStatusResult(response) : this.newJedisResult(response, converter, nullDefault));
                return null;
            }
            Object result = directFunction.apply(this.getJedis());
            if (result == null) {
                return nullDefault.get();
            }
            return converter.convert(result);
        });
    }

    protected DataAccessException convertJedisAccessException(Exception ex) {
        DataAccessException exception = EXCEPTION_TRANSLATION.translate(ex);
        return exception != null ? exception : new RedisSystemException(ex.getMessage(), ex);
    }

    @Override
    public RedisKeyCommands keyCommands() {
        return new JedisKeyCommands(this);
    }

    @Override
    public RedisStreamCommands streamCommands() {
        return new JedisStreamCommands(this);
    }

    @Override
    public RedisStringCommands stringCommands() {
        return new JedisStringCommands(this);
    }

    @Override
    public RedisListCommands listCommands() {
        return new JedisListCommands(this);
    }

    @Override
    public RedisSetCommands setCommands() {
        return new JedisSetCommands(this);
    }

    @Override
    public RedisZSetCommands zSetCommands() {
        return new JedisZSetCommands(this);
    }

    @Override
    public RedisHashCommands hashCommands() {
        return new JedisHashCommands(this);
    }

    @Override
    public RedisGeoCommands geoCommands() {
        return new JedisGeoCommands(this);
    }

    @Override
    public RedisScriptingCommands scriptingCommands() {
        return new JedisScriptingCommands(this);
    }

    @Override
    public RedisServerCommands serverCommands() {
        return new JedisServerCommands(this);
    }

    @Override
    public RedisHyperLogLogCommands hyperLogLogCommands() {
        return new JedisHyperLogLogCommands(this);
    }

    @Override
    public Object execute(String command, byte[] ... args) {
        return this.execute(command, args, Connection::getOne, JedisClientUtils::getResponse);
    }

    @Nullable
    <T> T execute(String command, byte[][] args, Function<Client, T> resultMapper, Function<Object, Response<?>> pipelineResponseMapper) {
        Assert.hasText((String)command, (String)"A valid command needs to be specified!");
        Assert.notNull((Object)args, (String)"Arguments must not be null!");
        return (T)this.doWithJedis((Jedis it) -> {
            Client client = JedisClientUtils.sendCommand(command, args, it);
            if (this.isQueueing() || this.isPipelined()) {
                Response result = (Response)pipelineResponseMapper.apply(this.isPipelined() ? this.getRequiredPipeline() : this.getRequiredTransaction());
                if (this.isPipelined()) {
                    this.pipeline(this.newJedisResult(result));
                } else {
                    this.transaction(this.newJedisResult(result));
                }
                return null;
            }
            return resultMapper.apply(client);
        });
    }

    @Override
    public void close() throws DataAccessException {
        super.close();
        if (this.pool != null) {
            this.jedis.close();
            return;
        }
        Exception exc = null;
        try {
            this.jedis.quit();
        }
        catch (Exception ex) {
            exc = ex;
        }
        try {
            this.jedis.disconnect();
        }
        catch (Exception ex) {
            exc = ex;
        }
        if (exc != null) {
            throw this.convertJedisAccessException(exc);
        }
    }

    public Jedis getNativeConnection() {
        return this.jedis;
    }

    @Override
    public boolean isClosed() {
        return this.doWithJedis((Jedis it) -> !it.isConnected());
    }

    @Override
    public boolean isQueueing() {
        return JedisClientUtils.isInMulti(this.jedis);
    }

    @Override
    public boolean isPipelined() {
        return this.pipeline != null;
    }

    @Override
    public void openPipeline() {
        if (this.pipeline == null) {
            this.pipeline = this.jedis.pipelined();
        }
    }

    @Override
    public List<Object> closePipeline() {
        if (this.pipeline != null) {
            try {
                List<Object> list = this.convertPipelineResults();
                return list;
            }
            finally {
                this.pipeline = null;
                this.pipelinedResults.clear();
            }
        }
        return Collections.emptyList();
    }

    private List<Object> convertPipelineResults() {
        ArrayList<Object> results = new ArrayList<Object>();
        this.getRequiredPipeline().sync();
        DataAccessException cause = null;
        for (JedisResult result : this.pipelinedResults) {
            try {
                Object data = result.get();
                if (result.isStatus()) continue;
                results.add(result.conversionRequired() ? result.convert(data) : data);
            }
            catch (JedisDataException e) {
                DataAccessException dataAccessException = this.convertJedisAccessException((Exception)((Object)e));
                if (cause == null) {
                    cause = dataAccessException;
                }
                results.add((Object)dataAccessException);
            }
            catch (DataAccessException e) {
                if (cause == null) {
                    cause = e;
                }
                results.add((Object)e);
            }
        }
        if (cause != null) {
            throw new RedisPipelineException((Exception)((Object)cause), (List<Object>)results);
        }
        return results;
    }

    void pipeline(JedisResult result) {
        if (this.isQueueing()) {
            this.transaction(result);
        } else {
            this.pipelinedResults.add(result);
        }
    }

    void transaction(FutureResult<Response<?>> result) {
        this.txResults.add(result);
    }

    @Override
    public byte[] echo(byte[] message) {
        Assert.notNull((Object)message, (String)"Message must not be null");
        return this.invoke().just(BinaryJedis::echo, PipelineBase::echo, message);
    }

    @Override
    public String ping() {
        return this.invoke().just(BinaryJedis::ping, MultiKeyPipelineBase::ping);
    }

    @Override
    public void discard() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newStatusResult(this.getRequiredPipeline().discard()));
                return;
            }
            this.getRequiredTransaction().discard();
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    @Override
    public List<Object> exec() {
        try {
            if (this.isPipelined()) {
                this.pipeline(this.newJedisResult(this.getRequiredPipeline().exec(), new TransactionResultConverter(new LinkedList(this.txResults), JedisConverters.exceptionConverter())));
                List<Object> list = null;
                return list;
            }
            if (this.transaction == null) {
                throw new InvalidDataAccessApiUsageException("No ongoing transaction. Did you forget to call multi?");
            }
            List<Object> results = this.transaction.exec();
            List<Object> list = !CollectionUtils.isEmpty((Collection)results) ? new TransactionResultConverter(this.txResults, JedisConverters.exceptionConverter()).convert(results) : results;
            return list;
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
        finally {
            this.txResults.clear();
            this.transaction = null;
        }
    }

    @Nullable
    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public Pipeline getRequiredPipeline() {
        Pipeline pipeline = this.getPipeline();
        if (pipeline == null) {
            throw new IllegalStateException("Connection has no active pipeline");
        }
        return pipeline;
    }

    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    public Transaction getRequiredTransaction() {
        Transaction transaction = this.getTransaction();
        if (transaction == null) {
            throw new IllegalStateException("Connection has no active transaction");
        }
        return transaction;
    }

    public Jedis getJedis() {
        return this.jedis;
    }

    JedisInvoker invoke() {
        return this.invoker;
    }

    JedisInvoker invokeStatus() {
        return this.statusInvoker;
    }

    <T> JedisResult<T, T> newJedisResult(Response<T> response) {
        return JedisResult.JedisResultBuilder.forResponse(response).build();
    }

    <T, R> JedisResult<T, R> newJedisResult(Response<T> response, Converter<T, R> converter) {
        return JedisResult.JedisResultBuilder.forResponse(response).mappedWith(converter).convertPipelineAndTxResults(this.convertPipelineAndTxResults).build();
    }

    <T, R> JedisResult<T, R> newJedisResult(Response<T> response, Converter<T, R> converter, Supplier<R> defaultValue) {
        return JedisResult.JedisResultBuilder.forResponse(response).mappedWith(converter).convertPipelineAndTxResults(this.convertPipelineAndTxResults).mapNullTo(defaultValue).build();
    }

    <T> JedisResult.JedisStatusResult<T, T> newStatusResult(Response<T> response) {
        return JedisResult.JedisResultBuilder.forResponse(response).buildStatusResult();
    }

    @Override
    public void multi() {
        if (this.isQueueing()) {
            return;
        }
        this.doWithJedis((Jedis it) -> {
            if (this.isPipelined()) {
                this.getRequiredPipeline().multi();
                return;
            }
            this.transaction = it.multi();
        });
    }

    @Override
    public void select(int dbIndex) {
        this.invokeStatus().just(BinaryJedis::select, MultiKeyPipelineBase::select, dbIndex);
    }

    @Override
    public void unwatch() {
        this.doWithJedis(BinaryJedis::unwatch);
    }

    @Override
    public void watch(byte[] ... keys) {
        if (this.isQueueing()) {
            throw new UnsupportedOperationException();
        }
        this.doWithJedis((Jedis it) -> {
            for (byte[] key : keys) {
                if (this.isPipelined()) {
                    this.pipeline(this.newStatusResult(this.getRequiredPipeline().watch((byte[][])new byte[][]{key})));
                    continue;
                }
                it.watch((byte[][])new byte[][]{key});
            }
        });
    }

    @Override
    public Long publish(byte[] channel, byte[] message) {
        return this.invoke().just(BinaryJedis::publish, MultiKeyPipelineBase::publish, channel, message);
    }

    @Override
    public Subscription getSubscription() {
        return this.subscription;
    }

    @Override
    public boolean isSubscribed() {
        return this.subscription != null && this.subscription.isAlive();
    }

    @Override
    public void pSubscribe(MessageListener listener, byte[] ... patterns) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        this.doWithJedis((Jedis it) -> {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, null, patterns);
            it.psubscribe((BinaryJedisPubSub)jedisPubSub, patterns);
        });
    }

    @Override
    public void subscribe(MessageListener listener, byte[] ... channels) {
        if (this.isSubscribed()) {
            throw new RedisSubscribedConnectionException("Connection already subscribed; use the connection Subscription to cancel or add new channels");
        }
        if (this.isQueueing() || this.isPipelined()) {
            throw new UnsupportedOperationException();
        }
        this.doWithJedis((Jedis it) -> {
            JedisMessageListener jedisPubSub = new JedisMessageListener(listener);
            this.subscription = new JedisSubscription(listener, jedisPubSub, channels, null);
            it.subscribe((BinaryJedisPubSub)jedisPubSub, channels);
        });
    }

    public void setConvertPipelineAndTxResults(boolean convertPipelineAndTxResults) {
        this.convertPipelineAndTxResults = convertPipelineAndTxResults;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isActive(RedisNode node) {
        Jedis verification = null;
        try {
            verification = this.getJedis(node);
            verification.connect();
            boolean bl = verification.ping().equalsIgnoreCase("pong");
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (verification != null) {
                verification.disconnect();
                verification.close();
            }
        }
    }

    @Override
    protected JedisSentinelConnection getSentinelConnection(RedisNode sentinel) {
        return new JedisSentinelConnection(this.getJedis(sentinel));
    }

    protected Jedis getJedis(RedisNode node) {
        return new Jedis(new HostAndPort(node.getHost(), node.getPort().intValue()), this.sentinelConfig);
    }

    @Nullable
    private <T> T doWithJedis(Function<Jedis, T> callback) {
        try {
            return callback.apply(this.getJedis());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }

    private void doWithJedis(Consumer<Jedis> callback) {
        try {
            callback.accept(this.getJedis());
        }
        catch (Exception ex) {
            throw this.convertJedisAccessException(ex);
        }
    }
}

