/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.connection.lettuce;

import java.util.Collection;
import org.springframework.data.redis.core.ScanCursor;
import org.springframework.data.redis.core.ScanIteration;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.lang.Nullable;

abstract class LettuceScanCursor<T>
extends ScanCursor<T> {
    @Nullable
    private io.lettuce.core.ScanCursor state;

    LettuceScanCursor(ScanOptions options) {
        super(options);
    }

    @Override
    protected ScanIteration<T> doScan(long cursorId, ScanOptions options) {
        if (this.state == null && cursorId == 0L) {
            return this.scanAndProcessState(io.lettuce.core.ScanCursor.INITIAL, options);
        }
        if (this.state != null && this.isMatchingCursor(cursorId)) {
            return this.scanAndProcessState(this.state, options);
        }
        throw new IllegalArgumentException(String.format("Current scan %s state and cursor %d do not match!", this.state != null ? this.state.getCursor() : "(none)", cursorId));
    }

    @Override
    protected boolean isFinished(long cursorId) {
        return this.state != null && this.isMatchingCursor(cursorId) ? this.state.isFinished() : super.isFinished(cursorId);
    }

    private ScanIteration<T> scanAndProcessState(io.lettuce.core.ScanCursor scanCursor, ScanOptions options) {
        LettuceScanIteration<T> iteration = this.doScan(scanCursor, options);
        this.state = ((LettuceScanIteration)iteration).cursor;
        return iteration;
    }

    private boolean isMatchingCursor(long cursorId) {
        return this.state != null && this.state.getCursor().equals(Long.toString(cursorId));
    }

    protected abstract LettuceScanIteration<T> doScan(io.lettuce.core.ScanCursor var1, ScanOptions var2);

    static class LettuceScanIteration<T>
    extends ScanIteration<T> {
        private final io.lettuce.core.ScanCursor cursor;

        LettuceScanIteration(io.lettuce.core.ScanCursor cursor, Collection<T> items) {
            super(Long.parseLong(cursor.getCursor()), items);
            this.cursor = cursor;
        }
    }
}

