/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core.convert;

import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.convert.IndexedData;
import org.springframework.util.ObjectUtils;

public class GeoIndexedPropertyValue
implements IndexedData {
    private final String keyspace;
    private final String indexName;
    private final Point value;

    public GeoIndexedPropertyValue(String keyspace, String indexName, Point value) {
        this.keyspace = keyspace;
        this.indexName = indexName;
        this.value = value;
    }

    @Override
    public String getIndexName() {
        return GeoIndexedPropertyValue.geoIndexName(this.indexName);
    }

    @Override
    public String getKeyspace() {
        return this.keyspace;
    }

    public Point getPoint() {
        return this.value;
    }

    public static String geoIndexName(String path) {
        int index = path.lastIndexOf(46);
        if (index == -1) {
            return path;
        }
        StringBuilder sb = new StringBuilder(path);
        sb.setCharAt(index, ':');
        return sb.toString();
    }

    public Point getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GeoIndexedPropertyValue)) {
            return false;
        }
        GeoIndexedPropertyValue that = (GeoIndexedPropertyValue)o;
        if (!ObjectUtils.nullSafeEquals((Object)this.keyspace, (Object)that.keyspace)) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals((Object)this.indexName, (Object)that.indexName)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals((Object)this.value, (Object)that.value);
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.keyspace);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.indexName);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.value);
        return result;
    }

    protected boolean canEqual(Object other) {
        return other instanceof GeoIndexedPropertyValue;
    }

    public String toString() {
        return "GeoIndexedPropertyValue(keyspace=" + this.getKeyspace() + ", indexName=" + this.getIndexName() + ", value=" + this.getValue() + ")";
    }
}

