/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.serializer;

import org.springframework.core.convert.converter.Converter;
import org.springframework.core.serializer.support.DeserializingConverter;
import org.springframework.core.serializer.support.SerializingConverter;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.SerializationException;
import org.springframework.data.redis.serializer.SerializationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class JdkSerializationRedisSerializer
implements RedisSerializer<Object> {
    private final Converter<Object, byte[]> serializer;
    private final Converter<byte[], Object> deserializer;

    public JdkSerializationRedisSerializer() {
        this((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter());
    }

    public JdkSerializationRedisSerializer(@Nullable ClassLoader classLoader) {
        this((Converter<Object, byte[]>)new SerializingConverter(), (Converter<byte[], Object>)new DeserializingConverter(classLoader));
    }

    public JdkSerializationRedisSerializer(Converter<Object, byte[]> serializer, Converter<byte[], Object> deserializer) {
        Assert.notNull(serializer, (String)"Serializer must not be null");
        Assert.notNull(deserializer, (String)"Deserializer must not be null");
        this.serializer = serializer;
        this.deserializer = deserializer;
    }

    @Override
    public byte[] serialize(@Nullable Object value) {
        if (value == null) {
            return SerializationUtils.EMPTY_ARRAY;
        }
        try {
            return (byte[])this.serializer.convert(value);
        }
        catch (Exception cause) {
            throw new SerializationException("Cannot serialize", cause);
        }
    }

    @Override
    public Object deserialize(@Nullable byte[] bytes) {
        if (SerializationUtils.isEmpty(bytes)) {
            return null;
        }
        try {
            return this.deserializer.convert((Object)bytes);
        }
        catch (Exception ex) {
            throw new SerializationException("Cannot deserialize", ex);
        }
    }
}

