/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.support.collections;

import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.RedisListCommands;
import org.springframework.data.redis.core.BoundListOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.data.redis.support.collections.AbstractRedisCollection;
import org.springframework.data.redis.support.collections.CollectionUtils;
import org.springframework.data.redis.support.collections.RedisIterator;
import org.springframework.data.redis.support.collections.RedisList;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultRedisList<E>
extends AbstractRedisCollection<E>
implements RedisList<E> {
    private volatile boolean capped = false;
    private volatile int maxSize = 0;
    private final BoundListOperations<String, E> listOps;

    public DefaultRedisList(String key, RedisOperations<String, E> operations) {
        this(operations.boundListOps(key));
    }

    public DefaultRedisList(String key, RedisOperations<String, E> operations, int maxSize) {
        this(operations.boundListOps(key), maxSize);
    }

    public DefaultRedisList(BoundListOperations<String, E> boundOps) {
        this(boundOps, 0);
    }

    public DefaultRedisList(BoundListOperations<String, E> boundOps, int maxSize) {
        super((String)boundOps.getKey(), boundOps.getOperations());
        this.listOps = boundOps;
        this.setMaxSize(maxSize);
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
        this.capped = maxSize > 0;
    }

    @Override
    public E moveFirstTo(RedisList<E> destination, RedisListCommands.Direction destinationPosition) {
        Assert.notNull(destination, (String)"Destination must not be null");
        Assert.notNull((Object)((Object)destinationPosition), (String)"Destination position must not be null");
        E result = this.listOps.move(RedisListCommands.Direction.first(), (String)destination.getKey(), destinationPosition);
        this.potentiallyCap(destination);
        return result;
    }

    @Override
    public E moveFirstTo(RedisList<E> destination, RedisListCommands.Direction destinationPosition, long timeout, TimeUnit unit) {
        Assert.notNull(destination, (String)"Destination must not be null");
        Assert.notNull((Object)((Object)destinationPosition), (String)"Destination position must not be null");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        E result = this.listOps.move(RedisListCommands.Direction.first(), (String)destination.getKey(), destinationPosition, timeout, unit);
        this.potentiallyCap(destination);
        return result;
    }

    @Override
    public E moveLastTo(RedisList<E> destination, RedisListCommands.Direction destinationPosition) {
        Assert.notNull(destination, (String)"Destination must not be null");
        Assert.notNull((Object)((Object)destinationPosition), (String)"Destination position must not be null");
        E result = this.listOps.move(RedisListCommands.Direction.last(), (String)destination.getKey(), destinationPosition);
        this.potentiallyCap(destination);
        return result;
    }

    @Override
    public E moveLastTo(RedisList<E> destination, RedisListCommands.Direction destinationPosition, long timeout, TimeUnit unit) {
        Assert.notNull(destination, (String)"Destination must not be null");
        Assert.notNull((Object)((Object)destinationPosition), (String)"Destination position must not be null");
        Assert.notNull((Object)((Object)unit), (String)"TimeUnit must not be null");
        E result = this.listOps.move(RedisListCommands.Direction.last(), (String)destination.getKey(), destinationPosition, timeout, unit);
        this.potentiallyCap(destination);
        return result;
    }

    private void potentiallyCap(RedisList<E> destination) {
        if (destination instanceof DefaultRedisList) {
            DefaultRedisList redisList = (DefaultRedisList)destination;
            redisList.cap();
        }
    }

    @Override
    public List<E> range(long start, long end) {
        return this.listOps.range(start, end);
    }

    @Override
    public RedisList<E> trim(int start, int end) {
        this.listOps.trim(start, end);
        return this;
    }

    @Override
    public RedisList<E> trim(long start, long end) {
        this.listOps.trim(start, end);
        return this;
    }

    @Override
    public Iterator<E> iterator() {
        List<E> list = this.content();
        this.checkResult(list);
        return new DefaultRedisListIterator(list.iterator());
    }

    @Override
    public int size() {
        Long size = this.listOps.size();
        this.checkResult(size);
        return size.intValue();
    }

    @Override
    public boolean add(E value) {
        this.listOps.rightPush(value);
        this.cap();
        return true;
    }

    @Override
    public void clear() {
        this.listOps.trim(this.size() + 1, 0L);
    }

    @Override
    public boolean remove(Object o) {
        Long result = this.listOps.remove(1L, o);
        return result != null && result > 0L;
    }

    @Override
    public void add(int index, E element) {
        if (index == 0) {
            this.addFirst(element);
            return;
        }
        int size = this.size();
        if (index == this.size()) {
            this.addLast(element);
            return;
        }
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        throw new IllegalArgumentException("Redis supports insertion only at the beginning or the end of the list");
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        if (index == 0) {
            CollectionUtils.reverse(collection).forEach(this::addFirst);
            return true;
        }
        int size = this.size();
        if (index == this.size()) {
            collection.forEach(this::addLast);
            return true;
        }
        if (index < 0 || index > size) {
            throw new IndexOutOfBoundsException();
        }
        throw new IllegalArgumentException("Redis supports insertion only at the beginning or the end of the list");
    }

    @Override
    public E get(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.listOps.index(index);
    }

    @Override
    public int indexOf(Object element) {
        Long index = this.listOps.indexOf(element);
        return index != null ? index.intValue() : -1;
    }

    @Override
    public int lastIndexOf(Object element) {
        Long index = this.listOps.lastIndexOf(element);
        return index != null ? index.intValue() : -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new ListItr(index);
    }

    @Override
    public E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E set(int index, E element) {
        E object = this.get(index);
        this.listOps.set(index, element);
        return object;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public E element() {
        E value = this.peek();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public boolean offer(E element) {
        return this.add(element);
    }

    @Override
    @Nullable
    public E peek() {
        return this.listOps.getFirst();
    }

    @Override
    @Nullable
    public E poll() {
        return this.listOps.leftPop();
    }

    @Override
    public E remove() {
        E value = this.poll();
        if (value == null) {
            throw new NoSuchElementException();
        }
        return value;
    }

    @Override
    public void addFirst(E element) {
        this.listOps.leftPush(element);
        this.cap();
    }

    @Override
    public void addLast(E element) {
        this.add(element);
    }

    @Override
    public Iterator<E> descendingIterator() {
        List<E> content = this.content();
        Collections.reverse(content);
        return new DefaultRedisListIterator(content.iterator());
    }

    @Override
    public E getFirst() {
        return this.element();
    }

    @Override
    public E getLast() {
        E element = this.peekLast();
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public boolean offerFirst(E element) {
        this.addFirst(element);
        return true;
    }

    @Override
    public boolean offerLast(E element) {
        this.addLast(element);
        return true;
    }

    @Override
    @Nullable
    public E peekFirst() {
        return this.peek();
    }

    @Override
    @Nullable
    public E peekLast() {
        return this.listOps.getLast();
    }

    @Override
    @Nullable
    public E pollFirst() {
        return this.poll();
    }

    @Override
    @Nullable
    public E pollLast() {
        return this.listOps.rightPop();
    }

    @Override
    public E pop() {
        E element = this.poll();
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public void push(E element) {
        this.addFirst(element);
    }

    @Override
    public E removeFirst() {
        return this.pop();
    }

    @Override
    public boolean removeFirstOccurrence(Object element) {
        return this.remove(element);
    }

    @Override
    public E removeLast() {
        E element = this.pollLast();
        if (element == null) {
            throw new NoSuchElementException();
        }
        return element;
    }

    @Override
    public boolean removeLastOccurrence(Object element) {
        Long result = this.listOps.remove(-1L, element);
        return result != null && result > 0L;
    }

    @Override
    public int drainTo(Collection<? super E> collection, int maxElements) {
        if (this.equals(collection)) {
            throw new IllegalArgumentException("Cannot drain a queue to itself");
        }
        int loop = Math.min(this.size(), maxElements);
        for (int index = 0; index < loop; ++index) {
            collection.add(this.poll());
        }
        return loop;
    }

    @Override
    public int drainTo(Collection<? super E> collection) {
        return this.drainTo(collection, this.size());
    }

    @Override
    public boolean offer(E element, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offer(element);
    }

    @Override
    @Nullable
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.listOps.leftPop(timeout, unit);
    }

    @Override
    public void put(E element) throws InterruptedException {
        this.offer(element);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    @Nullable
    public E take() throws InterruptedException {
        return this.poll(0L, TimeUnit.SECONDS);
    }

    @Override
    public boolean offerFirst(E element, long timeout, TimeUnit unit) {
        return this.offerFirst(element);
    }

    @Override
    public boolean offerLast(E element, long timeout, TimeUnit unit) {
        return this.offerLast(element);
    }

    @Override
    @Nullable
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        return this.poll(timeout, unit);
    }

    @Override
    @Nullable
    public E pollLast(long timeout, TimeUnit unit) {
        return this.listOps.rightPop(timeout, unit);
    }

    @Override
    public void putFirst(E element) {
        this.add(element);
    }

    @Override
    public void putLast(E element) throws InterruptedException {
        this.put(element);
    }

    @Override
    @Nullable
    public E takeFirst() throws InterruptedException {
        return this.take();
    }

    @Override
    @Nullable
    public E takeLast() {
        return this.pollLast(0L, TimeUnit.SECONDS);
    }

    @Override
    public DataType getType() {
        return DataType.LIST;
    }

    private List<E> content() {
        return this.listOps.range(0L, -1L);
    }

    private void cap() {
        if (this.capped) {
            this.listOps.trim(0L, this.maxSize - 1);
        }
    }

    private class DefaultRedisListIterator
    extends RedisIterator<E> {
        public DefaultRedisListIterator(Iterator<E> delegate) {
            super(delegate);
        }

        @Override
        protected void removeFromRedisStorage(E item) {
            DefaultRedisList.this.remove(item);
        }
    }

    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor > 0;
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void add(E element) {
            try {
                int index = this.cursor;
                DefaultRedisList.this.add(index, element);
                this.lastReturnedElementIndex = -1;
                this.lastReturnedElement = null;
                this.cursor = index + 1;
            }
            catch (IndexOutOfBoundsException ignore) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public E previous() {
            try {
                int index = this.cursor - 1;
                this.lastReturnedElement = DefaultRedisList.this.get(index);
                this.lastReturnedElementIndex = index;
                this.cursor = index;
                return this.lastReturnedElement;
            }
            catch (IndexOutOfBoundsException ignore) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void set(E element) {
            Assert.state((this.lastReturnedElement != null ? 1 : 0) != 0, (String)"next() or previous() must be called before set(:E)");
            try {
                DefaultRedisList.this.set(this.lastReturnedElementIndex, element);
            }
            catch (IndexOutOfBoundsException ignore) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr
    implements Iterator<E> {
        int cursor = 0;
        int lastReturnedElementIndex = -1;
        @Nullable
        E lastReturnedElement;

        private Itr() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < DefaultRedisList.this.size();
        }

        @Override
        public E next() {
            try {
                int index = this.cursor;
                this.lastReturnedElement = DefaultRedisList.this.get(index);
                this.cursor = index + 1;
                this.lastReturnedElementIndex = index;
                return this.lastReturnedElement;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new NoSuchElementException(ex);
            }
        }

        @Override
        public void remove() {
            Assert.state((this.lastReturnedElement != null ? 1 : 0) != 0, (String)"Next must be called before remove");
            if (!DefaultRedisList.this.remove(this.lastReturnedElement)) {
                throw new ConcurrentModificationException();
            }
            this.lastReturnedElementIndex = -1;
            this.lastReturnedElement = null;
            --this.cursor;
        }
    }
}

