/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.cache;

import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.springframework.data.redis.cache.BatchStrategies;
import org.springframework.data.redis.cache.BatchStrategy;
import org.springframework.data.redis.cache.CacheStatisticsCollector;
import org.springframework.data.redis.cache.CacheStatisticsProvider;
import org.springframework.data.redis.cache.DefaultRedisCacheWriter;
import org.springframework.data.redis.cache.FixedDurationTtlFunction;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface RedisCacheWriter
extends CacheStatisticsProvider {
    public static RedisCacheWriter nonLockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        return RedisCacheWriter.nonLockingRedisCacheWriter(connectionFactory, BatchStrategies.keys());
    }

    public static RedisCacheWriter nonLockingRedisCacheWriter(RedisConnectionFactory connectionFactory, BatchStrategy batchStrategy) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        Assert.notNull((Object)batchStrategy, (String)"BatchStrategy must not be null");
        return new DefaultRedisCacheWriter(connectionFactory, batchStrategy);
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory) {
        return RedisCacheWriter.lockingRedisCacheWriter(connectionFactory, BatchStrategies.keys());
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory, BatchStrategy batchStrategy) {
        return RedisCacheWriter.lockingRedisCacheWriter(connectionFactory, Duration.ofMillis(50L), TtlFunction.persistent(), batchStrategy);
    }

    public static RedisCacheWriter lockingRedisCacheWriter(RedisConnectionFactory connectionFactory, Duration sleepTime, TtlFunction lockTtlFunction, BatchStrategy batchStrategy) {
        Assert.notNull((Object)connectionFactory, (String)"ConnectionFactory must not be null");
        return new DefaultRedisCacheWriter(connectionFactory, sleepTime, lockTtlFunction, CacheStatisticsCollector.none(), batchStrategy);
    }

    @Nullable
    public byte[] get(String var1, byte[] var2);

    @Nullable
    default public byte[] get(String name, byte[] key, @Nullable Duration ttl) {
        return this.get(name, key);
    }

    default public byte[] get(String name, byte[] key, Supplier<byte[]> valueLoader, @Nullable Duration ttl, boolean timeToIdleEnabled) {
        byte[] bytes;
        byte[] byArray = bytes = timeToIdleEnabled ? this.get(name, key, ttl) : this.get(name, key);
        if (bytes == null) {
            bytes = valueLoader.get();
            this.put(name, key, bytes, ttl);
        }
        return bytes;
    }

    default public boolean supportsAsyncRetrieve() {
        return false;
    }

    default public CompletableFuture<byte[]> retrieve(String name, byte[] key) {
        return this.retrieve(name, key, null);
    }

    public CompletableFuture<byte[]> retrieve(String var1, byte[] var2, @Nullable Duration var3);

    public void put(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    public CompletableFuture<Void> store(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    @Nullable
    public byte[] putIfAbsent(String var1, byte[] var2, byte[] var3, @Nullable Duration var4);

    public void remove(String var1, byte[] var2);

    public void clean(String var1, byte[] var2);

    public void clearStatistics(String var1);

    public RedisCacheWriter withStatisticsCollector(CacheStatisticsCollector var1);

    @FunctionalInterface
    public static interface TtlFunction {
        public static final Duration NO_EXPIRATION = Duration.ZERO;

        public static TtlFunction just(Duration duration) {
            Assert.notNull((Object)duration, (String)"TTL Duration must not be null");
            return new FixedDurationTtlFunction(duration);
        }

        public static TtlFunction persistent() {
            return TtlFunction.just(NO_EXPIRATION);
        }

        public Duration getTimeToLive(Object var1, @Nullable Object var2);
    }
}

