/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.lang.reflect.Method;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.projection.DefaultMethodInvokingMethodInterceptor;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.connection.stream.ReadOffset;
import org.springframework.data.redis.connection.stream.StreamOffset;
import org.springframework.data.redis.core.BoundKeyOperations;
import org.springframework.data.redis.core.RedisOperations;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;

class BoundOperationsProxyFactory {
    private final Map<Method, Method> targetMethodCache = new ConcurrentHashMap<Method, Method>();

    BoundOperationsProxyFactory() {
    }

    public <T> T createProxy(Class<T> boundOperationsInterface, Object key, DataType type, RedisOperations<?, ?> operations, Function<RedisOperations<?, ?>, Object> operationsTargetFunction) {
        DefaultBoundKeyOperations delegate = new DefaultBoundKeyOperations(type, key, operations);
        Object operationsTarget = operationsTargetFunction.apply(operations);
        ProxyFactory proxyFactory = new ProxyFactory();
        proxyFactory.addInterface(boundOperationsInterface);
        proxyFactory.addAdvice((Advice)new DefaultMethodInvokingMethodInterceptor());
        proxyFactory.addAdvice((Advice)new BoundOperationsMethodInterceptor(key, operations, boundOperationsInterface, operationsTarget, delegate));
        return (T)proxyFactory.getProxy(this.getClass().getClassLoader());
    }

    Method lookupRequiredMethod(Method method, Class<?> targetClass, boolean considerKeyArgument) {
        Method target = this.lookupMethod(method, targetClass, considerKeyArgument);
        if (target == null) {
            throw new IllegalArgumentException("Cannot lookup target method for %s in class %s; This appears to be a bug".formatted(method, targetClass.getName()));
        }
        return target;
    }

    @Nullable
    Method lookupMethod(Method method, Class<?> targetClass, boolean considerKeyArgument) {
        return this.targetMethodCache.computeIfAbsent(method, it -> {
            Class[] paramTypes;
            if (this.isStreamRead(method)) {
                paramTypes = new Class[it.getParameterCount()];
                System.arraycopy(it.getParameterTypes(), 0, paramTypes, 0, paramTypes.length - 1);
                paramTypes[paramTypes.length - 1] = StreamOffset[].class;
            } else if (considerKeyArgument) {
                paramTypes = new Class[it.getParameterCount() + 1];
                paramTypes[0] = Object.class;
                System.arraycopy(it.getParameterTypes(), 0, paramTypes, 1, paramTypes.length - 1);
            } else {
                paramTypes = it.getParameterTypes();
            }
            return ReflectionUtils.findMethod((Class)targetClass, (String)method.getName(), (Class[])paramTypes);
        });
    }

    private boolean isStreamRead(Method method) {
        return method.getName().equals("read") && method.getParameterTypes()[method.getParameterCount() - 1].equals(ReadOffset.class);
    }

    static class DefaultBoundKeyOperations
    implements BoundKeyOperations<Object> {
        private final DataType type;
        private Object key;
        private final RedisOperations<Object, ?> ops;

        DefaultBoundKeyOperations(DataType type, Object key, RedisOperations<Object, ?> operations) {
            this.type = type;
            this.key = key;
            this.ops = operations;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Boolean expire(long timeout, TimeUnit unit) {
            return this.ops.expire(this.key, timeout, unit);
        }

        @Override
        public Boolean expireAt(Date date) {
            return this.ops.expireAt(this.key, date);
        }

        @Override
        public Long getExpire() {
            return this.ops.getExpire(this.key);
        }

        @Override
        public Boolean persist() {
            return this.ops.persist(this.key);
        }

        @Override
        public void rename(Object newKey) {
            if (this.ops.hasKey(this.key).booleanValue()) {
                this.ops.rename(this.key, newKey);
            }
            this.key = newKey;
        }

        @Override
        public DataType getType() {
            return this.type;
        }

        @Override
        public RedisOperations<Object, ?> getOperations() {
            return this.ops;
        }
    }

    class BoundOperationsMethodInterceptor
    implements MethodInterceptor {
        private final Class<?> boundOperationsInterface;
        private final Object operationsTarget;
        private final DefaultBoundKeyOperations delegate;

        public BoundOperationsMethodInterceptor(Object key, RedisOperations<?, ?> operations, Class<?> boundOperationsInterface, Object operationsTarget, DefaultBoundKeyOperations delegate) {
            this.boundOperationsInterface = boundOperationsInterface;
            this.operationsTarget = operationsTarget;
            this.delegate = delegate;
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            return switch (method.getName()) {
                case "getKey" -> this.delegate.getKey();
                case "rename" -> {
                    this.delegate.rename(invocation.getArguments()[0]);
                    yield null;
                }
                case "getOperations" -> this.delegate.getOperations();
                default -> method.getDeclaringClass() == this.boundOperationsInterface ? this.doInvoke(invocation, method, this.operationsTarget, true) : this.doInvoke(invocation, method, this.delegate, false);
            };
        }

        @Nullable
        private Object doInvoke(MethodInvocation invocation, Method method, Object target, boolean considerKeyArgument) {
            Object[] args;
            Method backingMethod = BoundOperationsProxyFactory.this.lookupRequiredMethod(method, target.getClass(), considerKeyArgument);
            Object[] invocationArguments = invocation.getArguments();
            if (BoundOperationsProxyFactory.this.isStreamRead(method)) {
                args = new Object[backingMethod.getParameterCount()];
                System.arraycopy(invocationArguments, 0, args, 0, args.length - 1);
                args[args.length - 1] = new StreamOffset[]{StreamOffset.create(this.delegate.getKey(), (ReadOffset)invocationArguments[invocationArguments.length - 1])};
            } else if (backingMethod.getParameterCount() > 0 && backingMethod.getParameterTypes()[0].equals(Object.class)) {
                args = new Object[backingMethod.getParameterCount()];
                args[0] = this.delegate.getKey();
                System.arraycopy(invocationArguments, 0, args, 1, args.length - 1);
            } else {
                args = invocationArguments;
            }
            try {
                return backingMethod.invoke(target, args);
            }
            catch (ReflectiveOperationException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
                throw new UnsupportedOperationException("Should not happen", ex);
            }
        }
    }
}

