/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.core;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.springframework.lang.Nullable;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public enum RedisCommand {
    APPEND("rw", 2, 2),
    AUTH("rw", 1, 1),
    BGREWRITEAOF("r", 0, 0, "bgwriteaof"),
    BGSAVE("r", 0, 0),
    BITCOUNT("r", 1, 3),
    BITOP("rw", 3),
    BITPOS("r", 2, 4),
    BLPOP("rw", 2),
    BRPOP("rw", 2),
    BRPOPLPUSH("rw", 3),
    CLIENT_KILL("rw", 1, 1),
    CLIENT_LIST("r", 0, 0),
    CLIENT_GETNAME("r", 0, 0),
    CLIENT_PAUSE("rw", 1, 1),
    CLIENT_SETNAME("w", 1, 1),
    CONFIG_GET("r", 1, 1, "getconfig"),
    CONFIG_REWRITE("rw", 0, 0),
    CONFIG_SET("w", 2, 2, "setconfig"),
    CONFIG_RESETSTAT("w", 0, 0, "resetconfigstats"),
    DBSIZE("r", 0, 0),
    DECR("w", 1, 1),
    DECRBY("w", 2, 2),
    DEL("rw", 1),
    DISCARD("rw", 0, 0),
    DUMP("r", 1, 1),
    ECHO("r", 1, 1),
    EVAL("rw", 2),
    EVALSHA("rw", 2),
    EXEC("rw", 0, 0),
    EXISTS("r", 1, 1),
    EXPIRE("rw", 2),
    EXPIREAT("rw", 2),
    FLUSHALL("w", 0, 0),
    FLUSHDB("w", 0, 0),
    GET("r", 1, 1),
    GETBIT("r", 2, 2),
    GETRANGE("r", 3, 3),
    GETSET("rw", 2, 2),
    GEOADD("w", 3),
    GEODIST("r", 2),
    GEOHASH("r", 2),
    GEOPOS("r", 2),
    GEORADIUS("r", 4),
    GEORADIUSBYMEMBER("r", 3),
    HDEL("rw", 2),
    HEXISTS("r", 2, 2),
    HGET("r", 2, 2),
    HGETALL("r", 1, 1),
    HINCRBY("rw", 3, 3),
    HINCBYFLOAT("rw", 3, 3),
    HKEYS("r", 1),
    HLEN("r", 1),
    HMGET("r", 2),
    HMSET("w", 3),
    HSET("w", 3, 3),
    HSETNX("w", 3, 3),
    HVALS("r", 1, 1),
    HEXPIRE("w", 5),
    HEXPIREAT("w", 5),
    HPEXPIRE("w", 5),
    HPEXPIREAT("w", 5),
    HPERSIST("w", 4),
    HTTL("r", 4),
    HPTTL("r", 4),
    INCR("rw", 1),
    INCRBYFLOAT("rw", 2, 2),
    INFO("r", 0),
    KEYS("r", 1),
    LASTSAVE("r", 0),
    LINDEX("r", 2, 2),
    LINSERT("rw", 4, 4),
    LLEN("r", 1, 1),
    LPOP("rw", 1, 1),
    LPUSH("rw", 2),
    LPUSHX("rw", 2),
    LRANGE("r", 3, 3),
    LREM("rw", 3, 3),
    LSET("w", 3, 3),
    LTRIM("w", 3, 3),
    MGET("r", 1),
    MIGRATE("rw", 0),
    MONITOR("rw", 0, 0),
    MOVE("rw", 2, 2),
    MSET("w", 2),
    MSETNX("w", 2),
    MULTI("rw", 0, 0),
    PERSIST("rw", 1, 1),
    PEXPIRE("rw", 2),
    PEXPIREAT("rw", 2),
    PING("r", 0, 0),
    PSETEX("w", 3),
    PSUBSCRIBE("r", 1),
    PTTL("r", 1, 1),
    QUIT("rw", 0, 0),
    RANDOMKEY("r", 0, 0),
    RENAME("w", 2, 2),
    RENAMENX("w", 2, 2),
    REPLICAOF("w", 2),
    RESTORE("w", 3, 3),
    RPOP("rw", 1, 1),
    RPOPLPUSH("rw", 2, 2),
    RPUSH("rw", 2),
    RPUSHX("rw", 2, 2),
    SADD("rw", 2),
    SAVE("rw", 0, 0),
    SCARD("r", 1, 1),
    SCRIPT_EXISTS("r", 1),
    SCRIPT_FLUSH("rw", 0, 0),
    SCRIPT_KILL("rw", 0, 0),
    SCRIPT_LOAD("rw", 1, 1),
    SDIFF("r", 1),
    SDIFFSTORE("rw", 2),
    SELECT("rw", 1, 1),
    SET("w", 2),
    SETBIT("rw", 3, 3),
    SETEX("w", 3, 3),
    SETNX("w", 2, 2),
    SETRANGE("rw", 3, 3),
    SHUTDOWN("rw", 0),
    SINTER("r", 1),
    SINTERSTORE("rw", 2),
    SISMEMBER("r", 2),
    SLAVEOF("w", 2),
    SLOWLOG("rw", 1),
    SMEMBERS("r", 1, 1),
    SMOVE("rw", 3, 3),
    SORT("rw", 1),
    SPOP("rw", 1, 1),
    SRANDMEMBER("r", 1, 1),
    SREM("rw", 2),
    STRLEN("r", 1, 1),
    SUBSCRIBE("rw", 1),
    SUNION("r", 1),
    SUNIONSTORE("rw ", 2),
    SYNC("rw", 0, 0),
    TIME("r", 0, 0),
    TTL("r", 1, 1),
    TYPE("r", 1, 1),
    UNSUBSCRIBE("rw", 0),
    UNWATCH("rw", 0, 0),
    WATCH("rw", 1),
    ZADD("rw", 3),
    ZCARD("r", 1),
    ZCOUNT("r", 3, 3),
    ZINCRBY("rw", 3),
    ZINTERSTORE("rw", 3),
    ZRANGE("r", 3),
    ZRANGEBYSCORE("r", 3),
    ZRANK("r", 2, 2),
    ZREM("rw", 2),
    ZREMRANGEBYRANK("rw", 3, 3),
    ZREMRANGEBYSCORE("rw", 3, 3),
    ZREVRANGE("r", 3),
    ZREVRANGEBYSCORE("r", 3),
    ZREVRANK("r", 2, 2),
    ZSCORE("r", 2, 2),
    ZUNIONSTORE("rw", 3),
    SCAN("r", 1),
    SSCAN("r", 2),
    HSCAN("r", 2),
    ZSCAN("r", 2),
    UNKNOWN("rw", -1);

    private static final Map<String, RedisCommand> commandLookup;
    private final boolean read;
    private final boolean write;
    private final int minArgs;
    private final int maxArgs;
    @Nullable
    private final String alias;

    private static Map<String, RedisCommand> buildCommandLookupTable() {
        RedisCommand[] commands = RedisCommand.values();
        HashMap<String, RedisCommand> map = new HashMap<String, RedisCommand>(commands.length + 5, 1.0f);
        for (RedisCommand command : commands) {
            map.put(command.name().toLowerCase(), command);
            if (ObjectUtils.isEmpty((Object)command.alias)) continue;
            map.put(command.alias, command);
        }
        return Collections.unmodifiableMap(map);
    }

    public static RedisCommand failsafeCommandLookup(String key) {
        return StringUtils.hasText((String)key) ? commandLookup.getOrDefault(key.toLowerCase(), UNKNOWN) : UNKNOWN;
    }

    private RedisCommand(String mode, int minArgs) {
        this(mode, minArgs, -1);
    }

    private RedisCommand(String mode, int minArgs, int maxArgs) {
        this(mode, minArgs, maxArgs, null);
    }

    private RedisCommand(String mode, @Nullable int minArgs, int maxArgs, String alias) {
        if (StringUtils.hasText((String)mode)) {
            this.read = mode.toLowerCase().contains("r");
            this.write = mode.toLowerCase().contains("w");
        } else {
            this.read = true;
            this.write = true;
        }
        this.minArgs = minArgs;
        this.maxArgs = maxArgs;
        this.alias = alias;
    }

    public boolean requiresArguments() {
        return this.minArgs > 0;
    }

    public boolean requiresExactNumberOfArguments() {
        return this.maxArgs == 0 || this.minArgs == this.maxArgs;
    }

    Set<String> getAliases() {
        return ObjectUtils.isEmpty((Object)this.alias) ? Collections.emptySet() : Collections.singleton(this.alias);
    }

    public boolean isRead() {
        return this.read;
    }

    public boolean isWrite() {
        return this.write;
    }

    public boolean isReadonly() {
        return this.isRead() && !this.isWrite();
    }

    public boolean isRepresentedBy(String command) {
        return StringUtils.hasText((String)command) && (this.toString().equalsIgnoreCase(command) || command.toLowerCase().equals(this.alias));
    }

    public void validateArgumentCount(int argumentCount) {
        if (this.requiresArguments()) {
            if (this.requiresExactNumberOfArguments() && argumentCount != this.maxArgs) {
                throw new IllegalArgumentException("%s command requires %d %s".formatted(this.name(), this.maxArgs, this.arguments(this.maxArgs)));
            }
            if (argumentCount < this.minArgs) {
                throw new IllegalArgumentException("%s command requires at least %d %s".formatted(this.name(), this.minArgs, this.arguments(this.maxArgs)));
            }
            if (this.maxArgs > 0 && argumentCount > this.maxArgs) {
                throw new IllegalArgumentException("%s command requires at most %s %s".formatted(this.name(), this.maxArgs, this.arguments(this.maxArgs)));
            }
        }
    }

    private String arguments(int count) {
        return count == 1 ? "argument" : "arguments";
    }

    static {
        commandLookup = RedisCommand.buildCommandLookupTable();
    }
}

