/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.conversion;

import java.util.HashMap;
import java.util.Map;
import lombok.NonNull;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.relational.core.conversion.DbActionExecutionException;
import org.springframework.data.relational.core.conversion.Interpreter;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.lang.Nullable;

public interface DbAction<T> {
    public Class<T> getEntityType();

    default public void executeWith(Interpreter interpreter) {
        try {
            this.doExecuteWith(interpreter);
        }
        catch (Exception e) {
            throw new DbActionExecutionException(this, (Throwable)e);
        }
    }

    public void doExecuteWith(Interpreter var1);

    public static interface WithPropertyPath<T>
    extends DbAction<T> {
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath();

        @Override
        default public Class<T> getEntityType() {
            return ((RelationalPersistentProperty)this.getPropertyPath().getRequiredLeafProperty()).getActualType();
        }
    }

    public static interface WithGeneratedId<T>
    extends WithEntity<T> {
        @Nullable
        public Object getGeneratedId();

        @Override
        default public Class<T> getEntityType() {
            return this.getEntity().getClass();
        }
    }

    public static interface WithEntity<T>
    extends DbAction<T> {
        public T getEntity();

        @Override
        default public Class<T> getEntityType() {
            return this.getEntity().getClass();
        }
    }

    public static interface WithDependingOn<T>
    extends WithPropertyPath<T>,
    WithEntity<T> {
        public WithEntity<?> getDependingOn();

        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifiers();

        @Override
        default public Class<T> getEntityType() {
            return WithEntity.super.getEntityType();
        }
    }

    public static final class DeleteAllRoot<T>
    implements DbAction<T> {
        @NonNull
        private final Class<T> entityType;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        public DeleteAllRoot(@NonNull Class<T> entityType) {
            if (entityType == null) {
                throw new IllegalArgumentException("entityType is marked non-null but is null");
            }
            this.entityType = entityType;
        }

        @Override
        @NonNull
        public Class<T> getEntityType() {
            return this.entityType;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteAllRoot)) {
                return false;
            }
            DeleteAllRoot other = (DeleteAllRoot)o;
            Class<T> this$entityType = this.getEntityType();
            Class<T> other$entityType = other.getEntityType();
            return !(this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $entityType = this.getEntityType();
            result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.DeleteAllRoot(entityType=" + this.getEntityType() + ")";
        }
    }

    public static final class DeleteAll<T>
    implements WithPropertyPath<T> {
        @NonNull
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        public DeleteAll(@NonNull PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            if (propertyPath == null) {
                throw new IllegalArgumentException("propertyPath is marked non-null but is null");
            }
            this.propertyPath = propertyPath;
        }

        @Override
        @NonNull
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteAll)) {
                return false;
            }
            DeleteAll other = (DeleteAll)o;
            PersistentPropertyPath<RelationalPersistentProperty> this$propertyPath = this.getPropertyPath();
            PersistentPropertyPath<RelationalPersistentProperty> other$propertyPath = other.getPropertyPath();
            return !(this$propertyPath == null ? other$propertyPath != null : !this$propertyPath.equals(other$propertyPath));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            PersistentPropertyPath<RelationalPersistentProperty> $propertyPath = this.getPropertyPath();
            result = result * 59 + ($propertyPath == null ? 43 : $propertyPath.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.DeleteAll(propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static final class DeleteRoot<T>
    implements DbAction<T> {
        @NonNull
        private final Class<T> entityType;
        @NonNull
        private final Object rootId;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        public DeleteRoot(@NonNull Class<T> entityType, @NonNull Object rootId) {
            if (entityType == null) {
                throw new IllegalArgumentException("entityType is marked non-null but is null");
            }
            if (rootId == null) {
                throw new IllegalArgumentException("rootId is marked non-null but is null");
            }
            this.entityType = entityType;
            this.rootId = rootId;
        }

        @Override
        @NonNull
        public Class<T> getEntityType() {
            return this.entityType;
        }

        @NonNull
        public Object getRootId() {
            return this.rootId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DeleteRoot)) {
                return false;
            }
            DeleteRoot other = (DeleteRoot)o;
            Class<T> this$entityType = this.getEntityType();
            Class<T> other$entityType = other.getEntityType();
            if (this$entityType == null ? other$entityType != null : !this$entityType.equals(other$entityType)) {
                return false;
            }
            Object this$rootId = this.getRootId();
            Object other$rootId = other.getRootId();
            return !(this$rootId == null ? other$rootId != null : !this$rootId.equals(other$rootId));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Class<T> $entityType = this.getEntityType();
            result = result * 59 + ($entityType == null ? 43 : $entityType.hashCode());
            Object $rootId = this.getRootId();
            result = result * 59 + ($rootId == null ? 43 : $rootId.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.DeleteRoot(entityType=" + this.getEntityType() + ", rootId=" + this.getRootId() + ")";
        }
    }

    public static final class Delete<T>
    implements WithPropertyPath<T> {
        @NonNull
        private final Object rootId;
        @NonNull
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        public Delete(@NonNull Object rootId, @NonNull PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            if (rootId == null) {
                throw new IllegalArgumentException("rootId is marked non-null but is null");
            }
            if (propertyPath == null) {
                throw new IllegalArgumentException("propertyPath is marked non-null but is null");
            }
            this.rootId = rootId;
            this.propertyPath = propertyPath;
        }

        @NonNull
        public Object getRootId() {
            return this.rootId;
        }

        @Override
        @NonNull
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Delete)) {
                return false;
            }
            Delete other = (Delete)o;
            Object this$rootId = this.getRootId();
            Object other$rootId = other.getRootId();
            if (this$rootId == null ? other$rootId != null : !this$rootId.equals(other$rootId)) {
                return false;
            }
            PersistentPropertyPath<RelationalPersistentProperty> this$propertyPath = this.getPropertyPath();
            PersistentPropertyPath<RelationalPersistentProperty> other$propertyPath = other.getPropertyPath();
            return !(this$propertyPath == null ? other$propertyPath != null : !this$propertyPath.equals(other$propertyPath));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Object $rootId = this.getRootId();
            result = result * 59 + ($rootId == null ? 43 : $rootId.hashCode());
            PersistentPropertyPath<RelationalPersistentProperty> $propertyPath = this.getPropertyPath();
            result = result * 59 + ($propertyPath == null ? 43 : $propertyPath.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.Delete(rootId=" + this.getRootId() + ", propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static final class Merge<T>
    implements WithDependingOn<T>,
    WithPropertyPath<T> {
        @NonNull
        private final T entity;
        @NonNull
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;
        @NonNull
        private final WithEntity<?> dependingOn;
        private final Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object>();

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        public Merge(@NonNull T entity, @NonNull PersistentPropertyPath<RelationalPersistentProperty> propertyPath, @NonNull WithEntity<?> dependingOn) {
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked non-null but is null");
            }
            if (propertyPath == null) {
                throw new IllegalArgumentException("propertyPath is marked non-null but is null");
            }
            if (dependingOn == null) {
                throw new IllegalArgumentException("dependingOn is marked non-null but is null");
            }
            this.entity = entity;
            this.propertyPath = propertyPath;
            this.dependingOn = dependingOn;
        }

        @Override
        @NonNull
        public T getEntity() {
            return this.entity;
        }

        @Override
        @NonNull
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        @NonNull
        public WithEntity<?> getDependingOn() {
            return this.dependingOn;
        }

        @Override
        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifiers() {
            return this.qualifiers;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Merge)) {
                return false;
            }
            Merge other = (Merge)o;
            T this$entity = this.getEntity();
            T other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            PersistentPropertyPath<RelationalPersistentProperty> this$propertyPath = this.getPropertyPath();
            PersistentPropertyPath<RelationalPersistentProperty> other$propertyPath = other.getPropertyPath();
            if (this$propertyPath == null ? other$propertyPath != null : !this$propertyPath.equals(other$propertyPath)) {
                return false;
            }
            WithEntity<?> this$dependingOn = this.getDependingOn();
            WithEntity<?> other$dependingOn = other.getDependingOn();
            if (this$dependingOn == null ? other$dependingOn != null : !this$dependingOn.equals(other$dependingOn)) {
                return false;
            }
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> this$qualifiers = this.getQualifiers();
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> other$qualifiers = other.getQualifiers();
            return !(this$qualifiers == null ? other$qualifiers != null : !((Object)this$qualifiers).equals(other$qualifiers));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            PersistentPropertyPath<RelationalPersistentProperty> $propertyPath = this.getPropertyPath();
            result = result * 59 + ($propertyPath == null ? 43 : $propertyPath.hashCode());
            WithEntity<?> $dependingOn = this.getDependingOn();
            result = result * 59 + ($dependingOn == null ? 43 : $dependingOn.hashCode());
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> $qualifiers = this.getQualifiers();
            result = result * 59 + ($qualifiers == null ? 43 : ((Object)$qualifiers).hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.Merge(entity=" + this.getEntity() + ", propertyPath=" + this.getPropertyPath() + ", dependingOn=" + this.getDependingOn() + ", qualifiers=" + this.getQualifiers() + ")";
        }
    }

    public static final class UpdateRoot<T>
    implements WithEntity<T> {
        @NonNull
        private final T entity;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        public UpdateRoot(@NonNull T entity) {
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked non-null but is null");
            }
            this.entity = entity;
        }

        @Override
        @NonNull
        public T getEntity() {
            return this.entity;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateRoot)) {
                return false;
            }
            UpdateRoot other = (UpdateRoot)o;
            T this$entity = this.getEntity();
            T other$entity = other.getEntity();
            return !(this$entity == null ? other$entity != null : !this$entity.equals(other$entity));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.UpdateRoot(entity=" + this.getEntity() + ")";
        }
    }

    public static final class Update<T>
    implements WithEntity<T> {
        @NonNull
        private final T entity;
        @NonNull
        private final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        public Update(@NonNull T entity, @NonNull PersistentPropertyPath<RelationalPersistentProperty> propertyPath) {
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked non-null but is null");
            }
            if (propertyPath == null) {
                throw new IllegalArgumentException("propertyPath is marked non-null but is null");
            }
            this.entity = entity;
            this.propertyPath = propertyPath;
        }

        @Override
        @NonNull
        public T getEntity() {
            return this.entity;
        }

        @NonNull
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Update)) {
                return false;
            }
            Update other = (Update)o;
            T this$entity = this.getEntity();
            T other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            PersistentPropertyPath<RelationalPersistentProperty> this$propertyPath = this.getPropertyPath();
            PersistentPropertyPath<RelationalPersistentProperty> other$propertyPath = other.getPropertyPath();
            return !(this$propertyPath == null ? other$propertyPath != null : !this$propertyPath.equals(other$propertyPath));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            PersistentPropertyPath<RelationalPersistentProperty> $propertyPath = this.getPropertyPath();
            result = result * 59 + ($propertyPath == null ? 43 : $propertyPath.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.Update(entity=" + this.getEntity() + ", propertyPath=" + this.getPropertyPath() + ")";
        }
    }

    public static class InsertRoot<T>
    implements WithEntity<T>,
    WithGeneratedId<T> {
        @NonNull
        private final T entity;
        private Object generatedId;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        @Override
        @NonNull
        public T getEntity() {
            return this.entity;
        }

        @Override
        public Object getGeneratedId() {
            return this.generatedId;
        }

        public void setGeneratedId(Object generatedId) {
            this.generatedId = generatedId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InsertRoot)) {
                return false;
            }
            InsertRoot other = (InsertRoot)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$entity = this.getEntity();
            T other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            Object this$generatedId = this.getGeneratedId();
            Object other$generatedId = other.getGeneratedId();
            return !(this$generatedId == null ? other$generatedId != null : !this$generatedId.equals(other$generatedId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InsertRoot;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            Object $generatedId = this.getGeneratedId();
            result = result * 59 + ($generatedId == null ? 43 : $generatedId.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.InsertRoot(entity=" + this.getEntity() + ", generatedId=" + this.getGeneratedId() + ")";
        }

        public InsertRoot(@NonNull T entity) {
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked non-null but is null");
            }
            this.entity = entity;
        }
    }

    public static class Insert<T>
    implements WithGeneratedId<T>,
    WithDependingOn<T> {
        @NonNull
        final T entity;
        @NonNull
        final PersistentPropertyPath<RelationalPersistentProperty> propertyPath;
        @NonNull
        final WithEntity<?> dependingOn;
        Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers = new HashMap<PersistentPropertyPath<RelationalPersistentProperty>, Object>();
        private Object generatedId;

        @Override
        public void doExecuteWith(Interpreter interpreter) {
            interpreter.interpret(this);
        }

        @Override
        public Class<T> getEntityType() {
            return WithDependingOn.super.getEntityType();
        }

        public Insert(@NonNull T entity, @NonNull PersistentPropertyPath<RelationalPersistentProperty> propertyPath, @NonNull WithEntity<?> dependingOn) {
            if (entity == null) {
                throw new IllegalArgumentException("entity is marked non-null but is null");
            }
            if (propertyPath == null) {
                throw new IllegalArgumentException("propertyPath is marked non-null but is null");
            }
            if (dependingOn == null) {
                throw new IllegalArgumentException("dependingOn is marked non-null but is null");
            }
            this.entity = entity;
            this.propertyPath = propertyPath;
            this.dependingOn = dependingOn;
        }

        @Override
        @NonNull
        public T getEntity() {
            return this.entity;
        }

        @Override
        @NonNull
        public PersistentPropertyPath<RelationalPersistentProperty> getPropertyPath() {
            return this.propertyPath;
        }

        @Override
        @NonNull
        public WithEntity<?> getDependingOn() {
            return this.dependingOn;
        }

        @Override
        public Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> getQualifiers() {
            return this.qualifiers;
        }

        @Override
        public Object getGeneratedId() {
            return this.generatedId;
        }

        public void setQualifiers(Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> qualifiers) {
            this.qualifiers = qualifiers;
        }

        public void setGeneratedId(Object generatedId) {
            this.generatedId = generatedId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Insert)) {
                return false;
            }
            Insert other = (Insert)o;
            if (!other.canEqual(this)) {
                return false;
            }
            T this$entity = this.getEntity();
            T other$entity = other.getEntity();
            if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) {
                return false;
            }
            PersistentPropertyPath<RelationalPersistentProperty> this$propertyPath = this.getPropertyPath();
            PersistentPropertyPath<RelationalPersistentProperty> other$propertyPath = other.getPropertyPath();
            if (this$propertyPath == null ? other$propertyPath != null : !this$propertyPath.equals(other$propertyPath)) {
                return false;
            }
            WithEntity<?> this$dependingOn = this.getDependingOn();
            WithEntity<?> other$dependingOn = other.getDependingOn();
            if (this$dependingOn == null ? other$dependingOn != null : !this$dependingOn.equals(other$dependingOn)) {
                return false;
            }
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> this$qualifiers = this.getQualifiers();
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> other$qualifiers = other.getQualifiers();
            if (this$qualifiers == null ? other$qualifiers != null : !((Object)this$qualifiers).equals(other$qualifiers)) {
                return false;
            }
            Object this$generatedId = this.getGeneratedId();
            Object other$generatedId = other.getGeneratedId();
            return !(this$generatedId == null ? other$generatedId != null : !this$generatedId.equals(other$generatedId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Insert;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T $entity = this.getEntity();
            result = result * 59 + ($entity == null ? 43 : $entity.hashCode());
            PersistentPropertyPath<RelationalPersistentProperty> $propertyPath = this.getPropertyPath();
            result = result * 59 + ($propertyPath == null ? 43 : $propertyPath.hashCode());
            WithEntity<?> $dependingOn = this.getDependingOn();
            result = result * 59 + ($dependingOn == null ? 43 : $dependingOn.hashCode());
            Map<PersistentPropertyPath<RelationalPersistentProperty>, Object> $qualifiers = this.getQualifiers();
            result = result * 59 + ($qualifiers == null ? 43 : ((Object)$qualifiers).hashCode());
            Object $generatedId = this.getGeneratedId();
            result = result * 59 + ($generatedId == null ? 43 : $generatedId.hashCode());
            return result;
        }

        public String toString() {
            return "DbAction.Insert(entity=" + this.getEntity() + ", propertyPath=" + this.getPropertyPath() + ", dependingOn=" + this.getDependingOn() + ", qualifiers=" + this.getQualifiers() + ", generatedId=" + this.getGeneratedId() + ")";
        }
    }
}

