/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.dialect;

import java.util.OptionalLong;
import java.util.function.Function;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.render.SelectRenderContext;

public abstract class AbstractDialect
implements Dialect {
    @Override
    public SelectRenderContext getSelectContext() {
        Function<Select, CharSequence> afterOrderBy = this.getAfterOrderBy();
        return new DialectSelectRenderContext(afterOrderBy);
    }

    protected Function<Select, CharSequence> getAfterOrderBy() {
        AfterOrderByLimitRenderFunction afterOrderBy;
        LimitClause limit = this.limit();
        switch (limit.getClausePosition()) {
            case AFTER_ORDER_BY: {
                afterOrderBy = new AfterOrderByLimitRenderFunction(limit);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Clause position %s not supported!", limit));
            }
        }
        return afterOrderBy.andThen(PrependWithLeadingWhitespace.INSTANCE);
    }

    static enum PrependWithLeadingWhitespace implements Function<CharSequence, CharSequence>
    {
        INSTANCE;


        @Override
        public CharSequence apply(CharSequence charSequence) {
            if (charSequence.length() == 0) {
                return charSequence;
            }
            return " " + charSequence;
        }
    }

    static class AfterOrderByLimitRenderFunction
    implements Function<Select, CharSequence> {
        private final LimitClause clause;

        @Override
        public CharSequence apply(Select select) {
            OptionalLong limit = select.getLimit();
            OptionalLong offset = select.getOffset();
            if (limit.isPresent() && offset.isPresent()) {
                return this.clause.getLimitOffset(limit.getAsLong(), offset.getAsLong());
            }
            if (limit.isPresent()) {
                return this.clause.getLimit(limit.getAsLong());
            }
            if (offset.isPresent()) {
                return this.clause.getOffset(offset.getAsLong());
            }
            return "";
        }

        public AfterOrderByLimitRenderFunction(LimitClause clause) {
            this.clause = clause;
        }
    }

    class DialectSelectRenderContext
    implements SelectRenderContext {
        private final Function<Select, ? extends CharSequence> afterOrderBy;

        DialectSelectRenderContext(Function<Select, ? extends CharSequence> afterOrderBy) {
            this.afterOrderBy = afterOrderBy;
        }

        @Override
        public Function<Select, ? extends CharSequence> afterOrderBy(boolean hasOrderBy) {
            return this.afterOrderBy;
        }
    }
}

