/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.relational.core.sql.AbstractSegment;
import org.springframework.data.relational.core.sql.Aliased;
import org.springframework.data.relational.core.sql.AsteriskFromTable;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Segment;
import org.springframework.util.Assert;

public class Table
extends AbstractSegment {
    private final String name;

    Table(String name) {
        super(new Segment[0]);
        this.name = name;
    }

    public static Table create(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        return new Table(name);
    }

    public static Table aliased(String name, String alias) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        Assert.hasText((String)alias, (String)"Alias must not be null or empty!");
        return new AliasedTable(name, alias);
    }

    public Table as(String alias) {
        Assert.hasText((String)alias, (String)"Alias must not be null or empty!");
        return new AliasedTable(this.name, alias);
    }

    public Column column(String name) {
        Assert.hasText((String)name, (String)"Name must not be null or empty!");
        return new Column(name, this);
    }

    public List<Column> columns(String ... names) {
        Assert.notNull((Object)names, (String)"Names must not be null");
        return this.columns(Arrays.asList(names));
    }

    public List<Column> columns(Collection<String> names) {
        Assert.notNull(names, (String)"Names must not be null");
        ArrayList<Column> columns = new ArrayList<Column>();
        for (String name : names) {
            columns.add(this.column(name));
        }
        return columns;
    }

    public AsteriskFromTable asterisk() {
        return new AsteriskFromTable(this);
    }

    public String getName() {
        return this.name;
    }

    public String getReferenceName() {
        return this.name;
    }

    @Override
    public String toString() {
        return this.name;
    }

    static class AliasedTable
    extends Table
    implements Aliased {
        private final String alias;

        AliasedTable(String name, String alias) {
            super(name);
            Assert.hasText((String)alias, (String)"Alias must not be null or empty!");
            this.alias = alias;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public String getReferenceName() {
            return this.getAlias();
        }

        @Override
        public String toString() {
            return this.getName() + " AS " + this.getAlias();
        }
    }
}

