/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.repository.query;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.data.relational.core.query.Criteria;
import org.springframework.data.relational.repository.query.CriteriaFactory;
import org.springframework.data.relational.repository.query.ParameterMetadataProvider;
import org.springframework.data.relational.repository.query.RelationalParameterAccessor;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.util.Streamable;
import org.springframework.util.Assert;

public abstract class RelationalQueryCreator<T>
extends AbstractQueryCreator<T, Criteria> {
    private final CriteriaFactory criteriaFactory;

    public RelationalQueryCreator(PartTree tree, RelationalParameterAccessor accessor) {
        super(tree);
        Assert.notNull((Object)accessor, (String)"RelationalParameterAccessor must not be null");
        this.criteriaFactory = new CriteriaFactory(new ParameterMetadataProvider(accessor));
    }

    protected Criteria create(Part part, Iterator<Object> iterator) {
        return this.criteriaFactory.createCriteria(part);
    }

    protected Criteria and(Part part, Criteria base, Iterator<Object> iterator) {
        return base.and(this.criteriaFactory.createCriteria(part));
    }

    protected Criteria or(Criteria base, Criteria criteria) {
        return base.or(criteria);
    }

    public static void validate(PartTree tree, Parameters<?, ?> parameters) {
        int argCount = 0;
        Iterable parts = () -> tree.stream().flatMap(Streamable::stream).iterator();
        for (Part part : parts) {
            int numberOfArguments = part.getNumberOfArguments();
            for (int i = 0; i < numberOfArguments; ++i) {
                RelationalQueryCreator.throwExceptionOnArgumentMismatch(part, parameters, argCount);
                ++argCount;
            }
        }
    }

    private static void throwExceptionOnArgumentMismatch(Part part, Parameters<?, ?> parameters, int index) {
        Part.Type type = part.getType();
        String property = part.getProperty().toDotPath();
        if (!parameters.getBindableParameters().hasParameterAt(index)) {
            String msgTemplate = "Query method expects at least %d arguments but only found %d. This leaves an operator of type %s for property %s unbound.";
            String formattedMsg = String.format(msgTemplate, index + 1, index, type.name(), property);
            throw new IllegalStateException(formattedMsg);
        }
        Parameter parameter = parameters.getBindableParameter(index);
        if (RelationalQueryCreator.expectsCollection(type) && !RelationalQueryCreator.parameterIsCollectionLike(parameter)) {
            String message = RelationalQueryCreator.wrongParameterTypeMessage(property, type, "Collection", parameter);
            throw new IllegalStateException(message);
        }
        if (!RelationalQueryCreator.expectsCollection(type) && !RelationalQueryCreator.parameterIsScalarLike(parameter)) {
            String message = RelationalQueryCreator.wrongParameterTypeMessage(property, type, "scalar", parameter);
            throw new IllegalStateException(message);
        }
    }

    private static boolean expectsCollection(Part.Type type) {
        return type == Part.Type.IN || type == Part.Type.NOT_IN;
    }

    private static boolean parameterIsCollectionLike(Parameter parameter) {
        return parameter.getType().isArray() || Collection.class.isAssignableFrom(parameter.getType());
    }

    private static boolean parameterIsScalarLike(Parameter parameter) {
        return !Collection.class.isAssignableFrom(parameter.getType());
    }

    private static String wrongParameterTypeMessage(String property, Part.Type operatorType, String expectedArgumentType, Parameter parameter) {
        return String.format("Operator %s on %s requires a %s argument, found %s", operatorType.name(), property, expectedArgumentType, parameter.getType());
    }
}

