/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.DefaultInsert;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Insert;
import org.springframework.data.relational.core.sql.InsertBuilder;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class DefaultInsertBuilder
implements InsertBuilder,
InsertBuilder.InsertIntoColumnsAndValuesWithBuild,
InsertBuilder.InsertValuesWithBuild {
    @Nullable
    private Table into;
    private List<Column> columns = new ArrayList<Column>();
    private List<Expression> values = new ArrayList<Expression>();

    DefaultInsertBuilder() {
    }

    @Override
    public InsertBuilder.InsertIntoColumnsAndValuesWithBuild into(Table table) {
        Assert.notNull((Object)table, (String)"Insert Into Table must not be null!");
        this.into = table;
        return this;
    }

    @Override
    public InsertBuilder.InsertIntoColumnsAndValuesWithBuild column(Column column) {
        Assert.notNull((Object)column, (String)"Column must not be null!");
        this.columns.add(column);
        return this;
    }

    @Override
    public InsertBuilder.InsertIntoColumnsAndValuesWithBuild columns(Column ... columns) {
        Assert.notNull((Object)columns, (String)"Columns must not be null!");
        return this.columns(Arrays.asList(columns));
    }

    @Override
    public InsertBuilder.InsertIntoColumnsAndValuesWithBuild columns(Collection<Column> columns) {
        Assert.notNull(columns, (String)"Columns must not be null!");
        this.columns.addAll(columns);
        return this;
    }

    @Override
    public InsertBuilder.InsertValuesWithBuild value(Expression value) {
        Assert.notNull((Object)value, (String)"Value must not be null!");
        this.values.add(value);
        return this;
    }

    @Override
    public InsertBuilder.InsertValuesWithBuild values(Expression ... values) {
        Assert.notNull((Object)values, (String)"Values must not be null!");
        return this.values(Arrays.asList(values));
    }

    @Override
    public InsertBuilder.InsertValuesWithBuild values(Collection<? extends Expression> values) {
        Assert.notNull(values, (String)"Values must not be null!");
        this.values.addAll(values);
        return this;
    }

    @Override
    public Insert build() {
        return new DefaultInsert(this.into, this.columns, this.values);
    }
}

