/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.relational.core.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.springframework.data.relational.core.sql.Column;
import org.springframework.data.relational.core.sql.Comparison;
import org.springframework.data.relational.core.sql.Condition;
import org.springframework.data.relational.core.sql.DefaultSelect;
import org.springframework.data.relational.core.sql.Expression;
import org.springframework.data.relational.core.sql.Join;
import org.springframework.data.relational.core.sql.LockMode;
import org.springframework.data.relational.core.sql.OrderByField;
import org.springframework.data.relational.core.sql.Select;
import org.springframework.data.relational.core.sql.SelectBuilder;
import org.springframework.data.relational.core.sql.SelectValidator;
import org.springframework.data.relational.core.sql.Table;
import org.springframework.data.relational.core.sql.TableLike;
import org.springframework.lang.Nullable;

class DefaultSelectBuilder
implements SelectBuilder,
SelectBuilder.SelectAndFrom,
SelectBuilder.SelectFromAndJoin,
SelectBuilder.SelectWhereAndOr {
    private boolean distinct = false;
    private final List<Expression> selectList = new ArrayList<Expression>();
    private final List<TableLike> from = new ArrayList<TableLike>();
    private long limit = -1L;
    private long offset = -1L;
    private final List<Join> joins = new ArrayList<Join>();
    @Nullable
    private Condition where;
    private final List<OrderByField> orderBy = new ArrayList<OrderByField>();
    @Nullable
    private LockMode lockMode;

    DefaultSelectBuilder() {
    }

    @Override
    public SelectBuilder top(int count) {
        this.limit = count;
        return this;
    }

    @Override
    public DefaultSelectBuilder select(Expression expression) {
        this.selectList.add(expression);
        return this;
    }

    @Override
    public DefaultSelectBuilder select(Expression ... expressions) {
        this.selectList.addAll(Arrays.asList(expressions));
        return this;
    }

    @Override
    public DefaultSelectBuilder select(Collection<? extends Expression> expressions) {
        this.selectList.addAll(expressions);
        return this;
    }

    @Override
    public DefaultSelectBuilder distinct() {
        this.distinct = true;
        return this;
    }

    @Override
    public SelectBuilder.SelectFromAndJoin from(String table) {
        return this.from((TableLike)Table.create(table));
    }

    @Override
    public SelectBuilder.SelectFromAndJoin from(TableLike table) {
        this.from.add(table);
        return this;
    }

    @Override
    public SelectBuilder.SelectFromAndJoin from(TableLike ... tables) {
        this.from.addAll(Arrays.asList(tables));
        return this;
    }

    @Override
    public SelectBuilder.SelectFromAndJoin from(Collection<? extends TableLike> tables) {
        this.from.addAll(tables);
        return this;
    }

    @Override
    public SelectBuilder.SelectFromAndJoin limitOffset(long limit, long offset) {
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    @Override
    public SelectBuilder.SelectFromAndJoin limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public SelectBuilder.SelectFromAndJoin offset(long offset) {
        this.offset = offset;
        return this;
    }

    @Override
    public DefaultSelectBuilder orderBy(OrderByField ... orderByFields) {
        this.orderBy.addAll(Arrays.asList(orderByFields));
        return this;
    }

    @Override
    public DefaultSelectBuilder orderBy(Collection<? extends OrderByField> orderByFields) {
        this.orderBy.addAll(orderByFields);
        return this;
    }

    @Override
    public DefaultSelectBuilder orderBy(Column ... columns) {
        for (Column column : columns) {
            this.orderBy.add(OrderByField.from(column));
        }
        return this;
    }

    @Override
    public SelectBuilder.SelectWhereAndOr where(Condition condition) {
        this.where = condition;
        return this;
    }

    @Override
    public SelectBuilder.SelectWhereAndOr and(Condition condition) {
        this.where = this.where.and(condition);
        return this;
    }

    @Override
    public SelectBuilder.SelectWhereAndOr or(Condition condition) {
        this.where = this.where.or(condition);
        return this;
    }

    @Override
    public SelectBuilder.SelectOn join(String table) {
        return this.join(Table.create(table));
    }

    @Override
    public SelectBuilder.SelectOn join(TableLike table) {
        return new JoinBuilder(table, this);
    }

    @Override
    public SelectBuilder.SelectOn leftOuterJoin(TableLike table) {
        return new JoinBuilder(table, this, Join.JoinType.LEFT_OUTER_JOIN);
    }

    public DefaultSelectBuilder join(Join join) {
        this.joins.add(join);
        return this;
    }

    @Override
    public SelectBuilder.SelectLock lock(LockMode lockMode) {
        this.lockMode = lockMode;
        return this;
    }

    @Override
    public Select build() {
        DefaultSelect select = new DefaultSelect(this.distinct, this.selectList, this.from, this.limit, this.offset, this.joins, this.where, this.orderBy, this.lockMode);
        SelectValidator.validate(select);
        return select;
    }

    static class JoinBuilder
    implements SelectBuilder.SelectOn,
    SelectBuilder.SelectOnConditionComparison,
    SelectBuilder.SelectFromAndJoinCondition {
        private final TableLike table;
        private final DefaultSelectBuilder selectBuilder;
        private final Join.JoinType joinType;
        @Nullable
        private Expression from;
        @Nullable
        private Expression to;
        @Nullable
        private Condition condition;

        JoinBuilder(TableLike table, DefaultSelectBuilder selectBuilder, Join.JoinType joinType) {
            this.table = table;
            this.selectBuilder = selectBuilder;
            this.joinType = joinType;
        }

        JoinBuilder(TableLike table, DefaultSelectBuilder selectBuilder) {
            this(table, selectBuilder, Join.JoinType.JOIN);
        }

        @Override
        public SelectBuilder.SelectOnConditionComparison on(Expression column) {
            this.from = column;
            return this;
        }

        @Override
        public SelectBuilder.SelectFromAndJoinCondition on(Condition condition) {
            this.condition = this.condition == null ? condition : this.condition.and(condition);
            return this;
        }

        @Override
        public JoinBuilder equals(Expression column) {
            this.to = column;
            return this;
        }

        @Override
        public SelectBuilder.SelectOnConditionComparison and(Expression column) {
            this.finishCondition();
            this.from = column;
            return this;
        }

        private void finishCondition() {
            if (this.from == null && this.to == null) {
                return;
            }
            Comparison comparison = Comparison.create(this.from, "=", this.to);
            this.condition = this.condition == null ? comparison : this.condition.and(comparison);
        }

        private Join finishJoin() {
            this.finishCondition();
            return new Join(this.joinType, this.table, this.condition);
        }

        @Override
        public SelectBuilder.SelectOrdered orderBy(OrderByField ... orderByFields) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.orderBy(orderByFields);
        }

        @Override
        public SelectBuilder.SelectOrdered orderBy(Collection<? extends OrderByField> orderByFields) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.orderBy((Collection)orderByFields);
        }

        @Override
        public SelectBuilder.SelectOrdered orderBy(Column ... columns) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.orderBy(columns);
        }

        @Override
        public SelectBuilder.SelectWhereAndOr where(Condition condition) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.where(condition);
        }

        @Override
        public SelectBuilder.SelectOn join(String table) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.join(table);
        }

        @Override
        public SelectBuilder.SelectOn join(TableLike table) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.join(table);
        }

        @Override
        public SelectBuilder.SelectOn leftOuterJoin(TableLike table) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.leftOuterJoin(table);
        }

        @Override
        public SelectBuilder.SelectFromAndJoin limitOffset(long limit, long offset) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.limitOffset(limit, offset);
        }

        @Override
        public SelectBuilder.SelectFromAndJoin limit(long limit) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.limit(limit);
        }

        @Override
        public SelectBuilder.SelectFromAndJoin offset(long offset) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.offset(offset);
        }

        @Override
        public SelectBuilder.SelectLock lock(LockMode lockMode) {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.lock(lockMode);
        }

        @Override
        public Select build() {
            this.selectBuilder.join(this.finishJoin());
            return this.selectBuilder.build();
        }
    }
}

