/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;

public class BaseUriAwareResource<T>
extends Resource<T> {
    @JsonIgnore
    private URI baseUri;

    public BaseUriAwareResource() {
    }

    public BaseUriAwareResource(T content, Link ... links) {
        super(content, links);
    }

    public BaseUriAwareResource(T content, Iterable<Link> links) {
        super(content, links);
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    public BaseUriAwareResource<T> setBaseUri(URI baseUri) {
        this.baseUri = baseUri;
        return this;
    }

    public List<Link> getLinks() {
        String baseUriStr = this.baseUri.toString();
        ArrayList<Link> links = new ArrayList<Link>();
        for (Link l : super.getLinks()) {
            if (!l.getHref().startsWith(baseUriStr) && !l.getHref().startsWith("http")) {
                links.add(new Link(UriUtils.buildUri((URI)this.baseUri, (String[])new String[]{l.getHref()}).toString(), l.getRel()));
                continue;
            }
            links.add(l);
        }
        return links;
    }

    public Link getLink(String rel) {
        Link l = super.getLink(rel);
        if (null == l) {
            return null;
        }
        if (!l.getHref().startsWith(this.baseUri.toString()) && !l.getHref().startsWith("http")) {
            return new Link(UriUtils.buildUri((URI)this.baseUri, (String[])new String[]{l.getHref()}).toString(), l.getRel());
        }
        return l;
    }
}

