/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.context;

import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.core.GenericTypeResolver;
import org.springframework.data.rest.repository.context.AfterCreateEvent;
import org.springframework.data.rest.repository.context.AfterDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkDeleteEvent;
import org.springframework.data.rest.repository.context.AfterLinkSaveEvent;
import org.springframework.data.rest.repository.context.AfterSaveEvent;
import org.springframework.data.rest.repository.context.BeforeCreateEvent;
import org.springframework.data.rest.repository.context.BeforeDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkDeleteEvent;
import org.springframework.data.rest.repository.context.BeforeLinkSaveEvent;
import org.springframework.data.rest.repository.context.BeforeSaveEvent;
import org.springframework.data.rest.repository.context.RepositoryEvent;

public abstract class AbstractRepositoryEventListener<T>
implements ApplicationListener<RepositoryEvent>,
ApplicationContextAware {
    private final Class<?> INTERESTED_TYPE = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractRepositoryEventListener.class);
    protected ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public final void onApplicationEvent(RepositoryEvent event) {
        Class<?> srcType = event.getSource().getClass();
        if (null != this.INTERESTED_TYPE && !this.INTERESTED_TYPE.isAssignableFrom(srcType)) {
            return;
        }
        if (event instanceof BeforeSaveEvent) {
            this.onBeforeSave(event.getSource());
        } else if (event instanceof BeforeCreateEvent) {
            this.onBeforeCreate(event.getSource());
        } else if (event instanceof AfterCreateEvent) {
            this.onAfterCreate(event.getSource());
        } else if (event instanceof AfterSaveEvent) {
            this.onAfterSave(event.getSource());
        } else if (event instanceof BeforeLinkSaveEvent) {
            this.onBeforeLinkSave(event.getSource(), ((BeforeLinkSaveEvent)event).getLinked());
        } else if (event instanceof AfterLinkSaveEvent) {
            this.onAfterLinkSave(event.getSource(), ((AfterLinkSaveEvent)event).getLinked());
        } else if (event instanceof BeforeLinkDeleteEvent) {
            this.onBeforeLinkDelete(event.getSource(), ((BeforeLinkDeleteEvent)event).getLinked());
        } else if (event instanceof AfterLinkDeleteEvent) {
            this.onAfterLinkDelete(event.getSource(), ((AfterLinkDeleteEvent)event).getLinked());
        } else if (event instanceof BeforeDeleteEvent) {
            this.onBeforeDelete(event.getSource());
        } else if (event instanceof AfterDeleteEvent) {
            this.onAfterDelete(event.getSource());
        }
    }

    protected void onBeforeCreate(T entity) {
    }

    protected void onAfterCreate(T entity) {
    }

    protected void onBeforeSave(T entity) {
    }

    protected void onAfterSave(T entity) {
    }

    protected void onBeforeLinkSave(T parent, Object linked) {
    }

    protected void onAfterLinkSave(T parent, Object linked) {
    }

    protected void onBeforeLinkDelete(T parent, Object linked) {
    }

    protected void onAfterLinkDelete(T parent, Object linked) {
    }

    protected void onBeforeDelete(T entity) {
    }

    protected void onAfterDelete(T entity) {
    }
}

