/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.json;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class Jackson2DatatypeHelper {
    private static final Logger LOG = LoggerFactory.getLogger(Jackson2DatatypeHelper.class);
    private static final boolean IS_HIBERNATE4_MODULE_AVAILABLE = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module", (ClassLoader)Jackson2DatatypeHelper.class.getClassLoader());
    private static final boolean IS_JODA_MODULE_AVAILABLE = ClassUtils.isPresent((String)"com.fasterxml.jackson.datatype.joda.JodaModule", (ClassLoader)Jackson2DatatypeHelper.class.getClassLoader());

    public static void configureObjectMapper(ObjectMapper mapper) {
        block7: {
            block6: {
                if (IS_HIBERNATE4_MODULE_AVAILABLE) {
                    try {
                        mapper.registerModule((Module)Class.forName("com.fasterxml.jackson.datatype.hibernate4.Hibernate4Module").newInstance());
                    }
                    catch (Throwable t) {
                        if (!LOG.isDebugEnabled()) break block6;
                        LOG.debug(t.getMessage(), t);
                    }
                }
            }
            if (IS_JODA_MODULE_AVAILABLE) {
                try {
                    mapper.registerModule((Module)Class.forName("com.fasterxml.jackson.datatype.joda.JodaModule").newInstance());
                }
                catch (Throwable t) {
                    if (!LOG.isDebugEnabled()) break block7;
                    LOG.debug(t.getMessage(), t);
                }
            }
        }
    }
}

