/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.repository.json;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.mapping.Association;
import org.springframework.data.mapping.AssociationHandler;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.annotation.Description;
import org.springframework.data.rest.repository.json.JsonSchema;
import org.springframework.data.rest.repository.json.PersistentEntityJackson2Module;
import org.springframework.data.rest.repository.support.RepositoryInformationSupport;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.util.StringUtils;

public class PersistentEntityToJsonSchemaConverter
extends RepositoryInformationSupport
implements ConditionalGenericConverter,
InitializingBean {
    private static final TypeDescriptor STRING_TYPE = TypeDescriptor.valueOf(String.class);
    private static final TypeDescriptor SCHEMA_TYPE = TypeDescriptor.valueOf(JsonSchema.class);
    private Set<GenericConverter.ConvertiblePair> convertiblePairs = new HashSet<GenericConverter.ConvertiblePair>();

    public void afterPropertiesSet() throws Exception {
        for (Class domainType : this.repositories) {
            this.convertiblePairs.add(new GenericConverter.ConvertiblePair(domainType, JsonSchema.class));
        }
    }

    public boolean matches(TypeDescriptor sourceType, TypeDescriptor targetType) {
        return Class.class.isAssignableFrom(sourceType.getType()) && JsonSchema.class.isAssignableFrom(targetType.getType());
    }

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return this.convertiblePairs;
    }

    public JsonSchema convert(Class<?> domainType) {
        return (JsonSchema)((Object)this.convert(domainType, STRING_TYPE, SCHEMA_TYPE));
    }

    public Object convert(Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity((Class)source);
        final RepositoryInformation repoInfo = this.repositories.getRepositoryInformationFor(persistentEntity.getType());
        ResourceMapping repoMapping = ResourceMappingUtils.getResourceMapping(this.config, repoInfo);
        final ResourceMapping entityMapping = ResourceMappingUtils.getResourceMapping(this.config, persistentEntity);
        final URI baseEntityUri = UriUtils.buildUri((URI)this.config.getBaseUri(), (String[])new String[]{repoMapping.getPath(), "{id}"});
        String entityDesc = persistentEntity.getType().isAnnotationPresent(Description.class) ? persistentEntity.getType().getAnnotation(Description.class).value() : null;
        final JsonSchema jsonSchema = new JsonSchema(persistentEntity.getName(), entityDesc);
        persistentEntity.doWithProperties(new PropertyHandler(){

            public void doWithPersistentProperty(PersistentProperty persistentProperty) {
                boolean notNull;
                Class propertyType = persistentProperty.getType();
                String type = StringUtils.uncapitalize((String)propertyType.getSimpleName());
                boolean bl = notNull = persistentProperty.getField().isAnnotationPresent(Nonnull.class) || persistentProperty.getGetter().isAnnotationPresent(Nonnull.class) || persistentProperty.getField().isAnnotationPresent(NotNull.class) || persistentProperty.getGetter().isAnnotationPresent(NotNull.class);
                String desc = persistentProperty.getField().isAnnotationPresent(Description.class) ? persistentProperty.getField().getAnnotation(Description.class).value() : (persistentProperty.getGetter().isAnnotationPresent(Description.class) ? persistentProperty.getGetter().getAnnotation(Description.class).value() : null);
                JsonSchema.Property property = persistentProperty.isCollectionLike() ? new JsonSchema.ArrayProperty("array", desc, notNull) : new JsonSchema.Property(type, desc, notNull);
                jsonSchema.addProperty(persistentProperty.getName(), property);
            }
        });
        final ArrayList links = new ArrayList();
        persistentEntity.doWithAssociations(new AssociationHandler(){

            public void doWithAssociation(Association association) {
                PersistentProperty persistentProperty = association.getInverse();
                ResourceMapping propertyMapping = entityMapping.getResourceMappingFor(persistentProperty.getName());
                if (null != propertyMapping && !propertyMapping.isExported()) {
                    return;
                }
                PersistentEntityJackson2Module.maybeAddAssociationLink(PersistentEntityToJsonSchemaConverter.this.repositories, PersistentEntityToJsonSchemaConverter.this.config, baseEntityUri, repoInfo, entityMapping, propertyMapping, persistentProperty, links);
            }
        });
        jsonSchema.add(links);
        return jsonSchema;
    }
}

