/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.net.URI;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.webmvc.annotation.BaseURI;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public class BaseUriMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    @Autowired
    private RepositoryRestConfiguration config;

    public BaseUriMethodArgumentResolver() {
    }

    public BaseUriMethodArgumentResolver(RepositoryRestConfiguration config) {
        this.config = config;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return null != parameter.getParameterAnnotation(BaseURI.class) && parameter.getParameterType() == URI.class;
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest servletRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        if (null == this.config.getBaseUri()) {
            URI baseUri = ServletUriComponentsBuilder.fromServletMapping((HttpServletRequest)servletRequest).build().toUri();
            this.config.setBaseUri(baseUri);
        }
        return this.config.getBaseUri();
    }
}

