/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Sort;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.repository.PagingAndSorting;
import org.springframework.data.web.PageableDefaults;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PagingAndSortingMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final int DEFAULT_PAGE = 1;
    @Autowired
    private RepositoryRestConfiguration config;

    public PagingAndSortingMethodArgumentResolver() {
    }

    public PagingAndSortingMethodArgumentResolver(RepositoryRestConfiguration config) {
        this.config = config;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable((Class)parameter.getParameterType(), PagingAndSorting.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest();
        PageRequest pr = null;
        for (Annotation annotation : parameter.getParameterAnnotations()) {
            if (!(annotation instanceof PageableDefaults)) continue;
            PageableDefaults defaults = (PageableDefaults)annotation;
            pr = new PageRequest(defaults.pageNumber(), defaults.value());
            break;
        }
        if (null == pr) {
            int page = 1;
            String sPage = request.getParameter(this.config.getPageParamName());
            if (StringUtils.hasText((String)sPage)) {
                try {
                    page = Integer.parseInt(sPage);
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            int limit = this.config.getDefaultPageSize();
            String sLimit = request.getParameter(this.config.getLimitParamName());
            if (StringUtils.hasText((String)sLimit)) {
                try {
                    limit = Math.min(Integer.parseInt(sLimit), this.config.getMaxPageSize());
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
            }
            Sort sort = null;
            ArrayList<Sort.Order> orders = new ArrayList<Sort.Order>();
            String[] orderValues = request.getParameterValues(this.config.getSortParamName());
            if (null != orderValues) {
                for (String orderParam : orderValues) {
                    String sortDir = request.getParameter(orderParam + ".dir");
                    Sort.Direction dir = null != sortDir ? Sort.Direction.valueOf((String)sortDir.toUpperCase()) : Sort.Direction.ASC;
                    orders.add(new Sort.Order(dir, orderParam));
                }
                if (!orders.isEmpty()) {
                    sort = new Sort(orders);
                }
            }
            pr = null != sort ? new PageRequest(page - 1, limit, sort) : new PageRequest(page - 1, limit);
        }
        return new PagingAndSorting(this.config, pr);
    }
}

