/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.rest.repository.support.RepositoryInformationSupport;
import org.springframework.util.ClassUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.util.UrlPathHelper;

public class RepositoryInformationHandlerMethodArgumentResolver
extends RepositoryInformationSupport
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter parameter) {
        return ClassUtils.isAssignable((Class)parameter.getParameterType(), RepositoryInformation.class);
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        String[] parts;
        HttpServletRequest request = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        String requestUri = new UrlPathHelper().getLookupPathForRequest(request);
        if (requestUri.startsWith("/")) {
            requestUri = requestUri.substring(1);
        }
        if ((parts = requestUri.split("/")).length == 0) {
            return null;
        }
        return this.findRepositoryInfoFor(parts[0]);
    }
}

