/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.BeanWrapper;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.repository.BaseUriAwareResource;
import org.springframework.data.rest.repository.PersistentEntityResource;
import org.springframework.data.rest.repository.invoke.RepositoryMethod;
import org.springframework.data.rest.repository.invoke.RepositoryMethodInvoker;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryRestRequest;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.hateoas.EntityLinks;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Resource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/{repository}/search"})
public class RepositorySearchController
extends AbstractRepositoryRestController {
    public RepositorySearchController(Repositories repositories, RepositoryRestConfiguration config, DomainClassConverter domainClassConverter, ConversionService conversionService, EntityLinks entityLinks) {
        super(repositories, config, domainClassConverter, conversionService, entityLinks);
    }

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-compact+json"})
    @ResponseBody
    public Resource<?> list(RepositoryRestRequest repoRequest) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.addAll(this.queryMethodLinks(repoRequest.getBaseUri(), repoRequest.getPersistentEntity().getType()));
        return new Resource(Collections.emptyList(), links);
    }

    @RequestMapping(value={"/{method}"}, method={RequestMethod.GET}, produces={"application/json", "application/x-spring-data-verbose+json"})
    @ResponseBody
    public Resource<?> query(RepositoryRestRequest repoRequest, @PathVariable String method) throws ResourceNotFoundException {
        BaseUriAwareResource resources;
        RepositoryMethodInvoker repoMethodInvoker = repoRequest.getRepositoryMethodInvoker();
        if (repoMethodInvoker.getQueryMethods().isEmpty()) {
            throw new ResourceNotFoundException();
        }
        ResourceMapping repoMapping = repoRequest.getRepositoryResourceMapping();
        String methodName = repoMapping.getNameForPath(method);
        RepositoryMethod repoMethod = (RepositoryMethod)repoMethodInvoker.getQueryMethods().get(methodName);
        if (null == repoMethod) {
            for (RepositoryMethod queryMethod : repoMethodInvoker.getQueryMethods().values()) {
                String path = ResourceMappingUtils.findPath((Method)queryMethod.getMethod());
                if (!path.equals(method)) continue;
                repoMethod = queryMethod;
                break;
            }
            if (null == repoMethod) {
                throw new ResourceNotFoundException();
            }
        }
        List methodParams = repoMethod.getParameters();
        Object[] paramValues = new Object[methodParams.size()];
        if (!methodParams.isEmpty()) {
            for (int i = 0; i < paramValues.length; ++i) {
                MethodParameter param = (MethodParameter)methodParams.get(i);
                if (Pageable.class.isAssignableFrom(param.getParameterType())) {
                    paramValues[i] = new PageRequest(repoRequest.getPagingAndSorting().getPageNumber(), repoRequest.getPagingAndSorting().getPageSize(), repoRequest.getPagingAndSorting().getSort());
                    continue;
                }
                if (Sort.class.isAssignableFrom(param.getParameterType())) {
                    paramValues[i] = repoRequest.getPagingAndSorting().getSort();
                    continue;
                }
                String paramName = (String)repoMethod.getParameterNames().get(i);
                String[] queryParamVals = repoRequest.getRequest().getParameterValues(paramName);
                if (null == queryParamVals) {
                    if (paramName.startsWith("arg")) {
                        throw new IllegalArgumentException("No @Param annotation found on query method " + repoMethod.getMethod().getName() + " for parameter " + param.getParameterName());
                    }
                    throw new IllegalArgumentException("No query parameter specified for " + repoMethod.getMethod().getName() + " param '" + paramName + "'");
                }
                paramValues[i] = this.methodParameterConversionService.convert((Object)queryParamVals, param);
            }
        }
        ArrayList<Link> links = new ArrayList<Link>();
        Object result = repoMethodInvoker.invokeQueryMethod(repoMethod, paramValues);
        if (result instanceof Page) {
            Page page = (Page)result;
            if (page.hasPreviousPage()) {
                repoRequest.addPrevLink(page, links);
            }
            if (page.hasNextPage()) {
                repoRequest.addNextLink(page, links);
            }
            resources = page.hasContent() ? this.entitiesToResource(repoRequest, page.getContent()) : new BaseUriAwareResource((Object)EMPTY_RESOURCE_LIST, new Link[0]);
        } else if (result instanceof Iterable) {
            resources = this.entitiesToResource(repoRequest, (Iterable)result);
        } else if (null == result) {
            resources = new BaseUriAwareResource((Object)EMPTY_RESOURCE_LIST, new Link[0]);
        } else {
            PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)repoRequest.getPersistentEntity(), (Object)result, (URI)repoRequest.getBaseUri());
            BeanWrapper wrapper = BeanWrapper.create((Object)result, (ConversionService)this.conversionService);
            Link selfLink = this.entityLinks.linkForSingleResource(result.getClass(), wrapper.getProperty(repoRequest.getPersistentEntity().getIdProperty())).withSelfRel();
            per.add(selfLink);
            resources = per;
        }
        resources.setBaseUri(repoRequest.getBaseUri()).add(links);
        return resources;
    }

    @RequestMapping(value={"/{method}"}, method={RequestMethod.GET}, produces={"application/x-spring-data-compact+json"})
    @ResponseBody
    public Resource<?> queryCompact(RepositoryRestRequest repoRequest, @PathVariable String method) throws ResourceNotFoundException {
        ArrayList<Link> links = new ArrayList<Link>();
        Resource<?> resource = this.query(repoRequest, method);
        links.addAll(resource.getLinks());
        if (resource.getContent() instanceof Iterable) {
            Iterable iter = (Iterable)resource.getContent();
            for (Object obj : iter) {
                if (null == obj || !(obj instanceof Resource)) continue;
                Resource res = (Resource)obj;
                links.add(this.resourceLink(repoRequest, res));
            }
        } else if (resource.getContent() instanceof Resource) {
            Resource res = (Resource)resource.getContent();
            links.add(this.resourceLink(repoRequest, res));
        }
        return new Resource((Object)EMPTY_RESOURCE_LIST, links);
    }

    private BaseUriAwareResource entitiesToResource(RepositoryRestRequest repoRequest, Iterable entities) {
        ArrayList<Object> resources = new ArrayList<Object>();
        for (Object obj : entities) {
            if (null == obj) {
                resources.add(null);
                break;
            }
            PersistentEntity persistentEntity = this.repositories.getPersistentEntity(obj.getClass());
            if (null == persistentEntity) {
                resources.add(new BaseUriAwareResource(obj, new Link[0]).setBaseUri(repoRequest.getBaseUri()));
                continue;
            }
            BeanWrapper wrapper = BeanWrapper.create(obj, (ConversionService)this.conversionService);
            PersistentEntityResource per = PersistentEntityResource.wrap((PersistentEntity)persistentEntity, obj, (URI)repoRequest.getBaseUri());
            Link selfLink = this.entityLinks.linkForSingleResource(persistentEntity.getType(), wrapper.getProperty(persistentEntity.getIdProperty())).withSelfRel();
            per.add(selfLink);
            resources.add(per);
        }
        return new BaseUriAwareResource(resources, new Link[0]).setBaseUri(repoRequest.getBaseUri());
    }
}

