/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.data.repository.support.DomainClassConverter;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.convert.ISO8601DateConverter;
import org.springframework.data.rest.convert.UUIDConverter;
import org.springframework.data.rest.repository.UriDomainClassConverter;
import org.springframework.data.rest.repository.context.AnnotatedHandlerBeanPostProcessor;
import org.springframework.data.rest.repository.context.RepositoriesFactoryBean;
import org.springframework.data.rest.repository.context.ValidatingRepositoryEventListener;
import org.springframework.data.rest.repository.json.Jackson2DatatypeHelper;
import org.springframework.data.rest.repository.json.PersistentEntityJackson2Module;
import org.springframework.data.rest.repository.json.PersistentEntityToJsonSchemaConverter;
import org.springframework.data.rest.repository.support.DomainObjectMerger;
import org.springframework.data.rest.webmvc.BaseUriMethodArgumentResolver;
import org.springframework.data.rest.webmvc.PagingAndSortingMethodArgumentResolver;
import org.springframework.data.rest.webmvc.PersistentEntityResourceHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RepositoryController;
import org.springframework.data.rest.webmvc.RepositoryEntityController;
import org.springframework.data.rest.webmvc.RepositoryInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RepositoryPropertyReferenceController;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerAdapter;
import org.springframework.data.rest.webmvc.RepositoryRestHandlerMapping;
import org.springframework.data.rest.webmvc.RepositoryRestRequestHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.RepositorySearchController;
import org.springframework.data.rest.webmvc.ServerHttpRequestMethodArgumentResolver;
import org.springframework.data.rest.webmvc.convert.UriListHttpMessageConverter;
import org.springframework.data.rest.webmvc.support.JpaHelper;
import org.springframework.data.rest.webmvc.support.RepositoryEntityLinks;
import org.springframework.data.rest.webmvc.support.ValidationExceptionHandler;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.hateoas.EntityLinks;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.util.ClassUtils;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.mvc.method.annotation.ExceptionHandlerExceptionResolver;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ImportResource(value={"classpath*:META-INF/spring-data-rest/**/*.xml"})
public class RepositoryRestMvcConfiguration {
    private static final boolean IS_JAVAX_VALIDATION_AVAILABLE = ClassUtils.isPresent((String)"javax.validation.ConstraintViolationException", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());
    private static final boolean IS_JPA_AVAILABLE = ClassUtils.isPresent((String)"javax.persistence.EntityManager", (ClassLoader)RepositoryRestMvcConfiguration.class.getClassLoader());

    @Bean
    public RepositoriesFactoryBean repositories() {
        return new RepositoriesFactoryBean();
    }

    @Bean
    public DefaultFormattingConversionService defaultConversionService() {
        DefaultFormattingConversionService conversionService = new DefaultFormattingConversionService();
        conversionService.addConverter((GenericConverter)UUIDConverter.INSTANCE);
        conversionService.addConverter((GenericConverter)ISO8601DateConverter.INSTANCE);
        this.configureConversionService((ConfigurableConversionService)conversionService);
        return conversionService;
    }

    @Bean
    public DomainClassConverter<?> domainClassConverter() {
        return new DomainClassConverter((ConversionService)this.defaultConversionService());
    }

    @Bean
    public UriDomainClassConverter uriDomainClassConverter() {
        return new UriDomainClassConverter();
    }

    @Bean
    public ValidatingRepositoryEventListener validatingRepositoryEventListener() {
        ValidatingRepositoryEventListener listener = new ValidatingRepositoryEventListener();
        this.configureValidatingRepositoryEventListener(listener);
        return listener;
    }

    @Bean
    @Lazy
    public ValidationExceptionHandler validationExceptionHandler() {
        if (IS_JAVAX_VALIDATION_AVAILABLE) {
            return new ValidationExceptionHandler();
        }
        return null;
    }

    @Bean
    @Lazy
    public JpaHelper jpaHelper() {
        if (IS_JPA_AVAILABLE) {
            return new JpaHelper();
        }
        return null;
    }

    @Bean
    public RepositoryRestConfiguration config() {
        RepositoryRestConfiguration config = new RepositoryRestConfiguration();
        this.configureRepositoryRestConfiguration(config);
        return config;
    }

    @Bean
    public AnnotatedHandlerBeanPostProcessor annotatedHandlerBeanPostProcessor() {
        return new AnnotatedHandlerBeanPostProcessor();
    }

    @Bean
    public DomainObjectMerger domainObjectMerger() throws Exception {
        return new DomainObjectMerger(this.repositories().getObject(), (ConversionService)this.defaultConversionService());
    }

    @Bean
    public RepositoryController repositoryController() throws Exception {
        return new RepositoryController(this.repositories().getObject(), this.config(), this.domainClassConverter(), (ConversionService)this.defaultConversionService(), this.entityLinks());
    }

    @Bean
    public RepositoryEntityController repositoryEntityController() throws Exception {
        return new RepositoryEntityController(this.repositories().getObject(), this.config(), this.domainClassConverter(), (ConversionService)this.defaultConversionService(), this.entityLinks());
    }

    @Bean
    public RepositoryPropertyReferenceController propertyReferenceController() throws Exception {
        return new RepositoryPropertyReferenceController(this.repositories().getObject(), this.config(), this.domainClassConverter(), (ConversionService)this.defaultConversionService(), this.entityLinks());
    }

    @Bean
    public RepositorySearchController repositorySearchController() throws Exception {
        return new RepositorySearchController(this.repositories().getObject(), this.config(), this.domainClassConverter(), (ConversionService)this.defaultConversionService(), this.entityLinks());
    }

    @Bean
    public BaseUriMethodArgumentResolver baseUriMethodArgumentResolver() {
        return new BaseUriMethodArgumentResolver();
    }

    @Bean
    public PagingAndSortingMethodArgumentResolver pagingAndSortingMethodArgumentResolver() {
        return new PagingAndSortingMethodArgumentResolver();
    }

    @Bean
    public ServerHttpRequestMethodArgumentResolver serverHttpRequestMethodArgumentResolver() {
        return new ServerHttpRequestMethodArgumentResolver();
    }

    @Bean
    public RepositoryInformationHandlerMethodArgumentResolver repoInfoMethodArgumentResolver() {
        return new RepositoryInformationHandlerMethodArgumentResolver();
    }

    @Bean
    public RepositoryRestRequestHandlerMethodArgumentResolver repoRequestArgumentResolver() {
        return new RepositoryRestRequestHandlerMethodArgumentResolver();
    }

    @Bean
    public EntityLinks entityLinks() throws Exception {
        return new RepositoryEntityLinks(this.repositories().getObject(), this.config());
    }

    @Bean
    public PersistentEntityResourceHandlerMethodArgumentResolver persistentEntityArgumentResolver() {
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        return new PersistentEntityResourceHandlerMethodArgumentResolver(messageConverters);
    }

    @Bean
    public PersistentEntityToJsonSchemaConverter jsonSchemaConverter() {
        return new PersistentEntityToJsonSchemaConverter();
    }

    @Bean
    public ObjectMapper objectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(SerializationFeature.INDENT_OUTPUT, true);
        objectMapper.registerModule(this.persistentEntityJackson2Module());
        Jackson2DatatypeHelper.configureObjectMapper((ObjectMapper)objectMapper);
        this.configureJacksonObjectMapper(objectMapper);
        return objectMapper;
    }

    @Bean
    public MappingJackson2HttpMessageConverter jacksonHttpMessageConverter() {
        MappingJackson2HttpMessageConverter jacksonConverter = new MappingJackson2HttpMessageConverter();
        jacksonConverter.setObjectMapper(this.objectMapper());
        jacksonConverter.setSupportedMediaTypes(Arrays.asList(MediaType.APPLICATION_JSON, MediaType.valueOf((String)"application/schema+json"), MediaType.valueOf((String)"application/x-spring-data-verbose+json"), MediaType.valueOf((String)"application/x-spring-data-compact+json")));
        return jacksonConverter;
    }

    @Bean
    public UriListHttpMessageConverter uriListHttpMessageConverter() {
        return new UriListHttpMessageConverter();
    }

    @Bean
    public RequestMappingHandlerAdapter repositoryExporterHandlerAdapter() {
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        RepositoryRestHandlerAdapter handlerAdapter = new RepositoryRestHandlerAdapter();
        handlerAdapter.setMessageConverters(messageConverters);
        handlerAdapter.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers());
        return handlerAdapter;
    }

    @Bean
    public RequestMappingHandlerMapping repositoryExporterHandlerMapping() {
        return new RepositoryRestHandlerMapping();
    }

    @Bean
    public Module persistentEntityJackson2Module() {
        return new PersistentEntityJackson2Module((ConversionService)this.defaultConversionService());
    }

    @Bean
    public ExceptionHandlerExceptionResolver exceptionHandlerExceptionResolver() {
        ExceptionHandlerExceptionResolver er = new ExceptionHandlerExceptionResolver();
        er.setCustomArgumentResolvers(this.defaultMethodArgumentResolvers());
        List<HttpMessageConverter<?>> messageConverters = this.defaultMessageConverters();
        this.configureHttpMessageConverters(messageConverters);
        er.setMessageConverters(messageConverters);
        this.configureExceptionHandlerExceptionResolver(er);
        return er;
    }

    private List<HttpMessageConverter<?>> defaultMessageConverters() {
        ArrayList messageConverters = new ArrayList();
        messageConverters.add((HttpMessageConverter<?>)this.jacksonHttpMessageConverter());
        messageConverters.add(this.uriListHttpMessageConverter());
        return messageConverters;
    }

    private List<HandlerMethodArgumentResolver> defaultMethodArgumentResolvers() {
        return Arrays.asList(new HandlerMethodArgumentResolver[]{this.baseUriMethodArgumentResolver(), this.pagingAndSortingMethodArgumentResolver(), this.serverHttpRequestMethodArgumentResolver(), this.repoInfoMethodArgumentResolver(), this.repoRequestArgumentResolver(), this.persistentEntityArgumentResolver()});
    }

    protected void configureRepositoryRestConfiguration(RepositoryRestConfiguration config) {
    }

    protected void configureConversionService(ConfigurableConversionService conversionService) {
    }

    protected void configureValidatingRepositoryEventListener(ValidatingRepositoryEventListener validatingListener) {
    }

    protected void configureExceptionHandlerExceptionResolver(ExceptionHandlerExceptionResolver exceptionResolver) {
    }

    protected void configureHttpMessageConverters(List<HttpMessageConverter<?>> messageConverters) {
    }

    protected void configureJacksonObjectMapper(ObjectMapper objectMapper) {
    }
}

