/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.data.rest.repository.RepositoryConstraintViolationException;
import org.springframework.validation.FieldError;

public class RepositoryConstraintViolationExceptionMessage {
    private final RepositoryConstraintViolationException violationException;
    private final List<ValidationError> errors = new ArrayList<ValidationError>();

    public RepositoryConstraintViolationExceptionMessage(RepositoryConstraintViolationException violationException, MessageSource msgSrc, Locale locale) {
        this.violationException = violationException;
        for (FieldError fe : violationException.getErrors().getFieldErrors()) {
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(fe.getObjectName());
            args.add(fe.getField());
            args.add(fe.getRejectedValue());
            if (null != fe.getArguments()) {
                for (Object o : fe.getArguments()) {
                    args.add(o);
                }
            }
            String msg = msgSrc.getMessage(fe.getCode(), args.toArray(), fe.getDefaultMessage(), locale);
            this.errors.add(new ValidationError(fe.getObjectName(), msg, String.format("%s", fe.getRejectedValue()), fe.getField()));
        }
    }

    @JsonProperty(value="errors")
    public List<ValidationError> getErrors() {
        return this.errors;
    }

    public static class ValidationError {
        String entity;
        String message;
        String invalidValue;
        String property;

        public ValidationError(String entity, String message, String invalidValue, String property) {
            this.entity = entity;
            this.message = message;
            this.invalidValue = invalidValue;
            this.property = property;
        }

        public String getEntity() {
            return this.entity;
        }

        public String getMessage() {
            return this.message;
        }

        public String getInvalidValue() {
            return this.invalidValue;
        }

        public String getProperty() {
            return this.property;
        }
    }
}

