/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.net.URI;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.config.RepositoryRestConfiguration;
import org.springframework.data.rest.config.ResourceMapping;
import org.springframework.data.rest.core.util.UriUtils;
import org.springframework.data.rest.repository.support.ResourceMappingUtils;
import org.springframework.data.rest.webmvc.RepositoryController;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkBuilder;
import org.springframework.hateoas.core.AbstractEntityLinks;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.web.util.UriComponentsBuilder;

public class RepositoryEntityLinks
extends AbstractEntityLinks {
    private final Repositories repositories;
    private final RepositoryRestConfiguration config;

    @Autowired
    public RepositoryEntityLinks(Repositories repositories, RepositoryRestConfiguration config) {
        this.repositories = repositories;
        this.config = config;
    }

    public boolean supports(Class<?> delimiter) {
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity(delimiter);
        return null != persistentEntity;
    }

    public LinkBuilder linkFor(Class<?> type) {
        RepositoryInformation repoInfo = this.repositories.getRepositoryInformationFor(type);
        if (null == repoInfo) {
            throw new IllegalArgumentException(type + " is not managed by any repository.");
        }
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity(type);
        if (null == persistentEntity) {
            throw new IllegalArgumentException(type + " is not managed by any repository.");
        }
        return new PersistentEntityLinkBuilder(this.config.getBaseUri(), repoInfo, persistentEntity);
    }

    public LinkBuilder linkFor(Class<?> type, Object ... parameters) {
        return this.linkFor(type);
    }

    public Link linkToCollectionResource(Class<?> type) {
        RepositoryInformation repoInfo = this.repositories.getRepositoryInformationFor(type);
        if (null == repoInfo) {
            throw new IllegalArgumentException(type + " is not managed by any repository.");
        }
        ResourceMapping mapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)this.config, (RepositoryInformation)repoInfo);
        return this.linkFor(type).withRel(mapping.getRel());
    }

    public Link linkToSingleResource(Class<?> type, Object id) {
        RepositoryInformation repoInfo = this.repositories.getRepositoryInformationFor(type);
        if (null == repoInfo) {
            throw new IllegalArgumentException(type + " is not managed by any repository.");
        }
        ResourceMapping repoMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)this.config, (RepositoryInformation)repoInfo);
        PersistentEntity persistentEntity = this.repositories.getPersistentEntity(type);
        ResourceMapping entityMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)this.config, (PersistentEntity)persistentEntity);
        return this.linkFor(type).slash(id).withRel(repoMapping.getRel() + "." + entityMapping.getRel());
    }

    private class PersistentEntityLinkBuilder
    implements LinkBuilder {
        private final UriComponentsBuilder builder;
        private final ResourceMapping repoMapping;
        private final ResourceMapping entityMapping;

        private PersistentEntityLinkBuilder(URI baseUri, RepositoryInformation repoInfo, PersistentEntity persistentEntity) {
            this.repoMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)RepositoryEntityLinks.this.config, (RepositoryInformation)repoInfo);
            this.entityMapping = ResourceMappingUtils.getResourceMapping((RepositoryRestConfiguration)RepositoryEntityLinks.this.config, (PersistentEntity)persistentEntity);
            if (null == baseUri) {
                URI u = ControllerLinkBuilder.linkTo(RepositoryController.class).toUri();
                if (u.toString().endsWith("/")) {
                    String s = u.toString();
                    baseUri = URI.create(s.substring(0, s.lastIndexOf(47)));
                } else {
                    baseUri = u;
                }
            }
            this.builder = UriComponentsBuilder.fromUri((URI)UriUtils.buildUri((URI)baseUri, (String[])new String[]{this.repoMapping.getPath()}));
        }

        public LinkBuilder slash(Object object) {
            String propName;
            String path = String.format("%s", object);
            if (object instanceof PersistentProperty && this.entityMapping.hasResourceMappingFor(propName = ((PersistentProperty)object).getName())) {
                path = this.entityMapping.getResourceMappingFor(propName).getPath();
            }
            this.builder.pathSegment(new String[]{path});
            return this;
        }

        public LinkBuilder slash(Identifiable<?> identifiable) {
            return this.slash(identifiable.getId());
        }

        public URI toUri() {
            return this.builder.build().toUri();
        }

        public Link withRel(String rel) {
            return new Link(this.builder.build().toUriString(), rel);
        }

        public Link withSelfRel() {
            return this.withRel("self");
        }
    }
}

