/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc;

import java.util.Collections;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.repository.support.Repositories;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.AbstractRepositoryRestController;
import org.springframework.data.rest.webmvc.RepositoryLinksResource;
import org.springframework.data.rest.webmvc.RepositoryRestController;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityLinks;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RepositoryRestController
public class RepositoryController
extends AbstractRepositoryRestController {
    private final Repositories repositories;
    private final EntityLinks entityLinks;
    private final ResourceMappings mappings;

    @Autowired
    public RepositoryController(PagedResourcesAssembler<Object> assembler, Repositories repositories, EntityLinks entityLinks, ResourceMappings mappings) {
        super(assembler);
        Assert.notNull((Object)repositories, (String)"Repositories must not be null!");
        Assert.notNull((Object)entityLinks, (String)"EntityLinks must not be null!");
        Assert.notNull((Object)mappings, (String)"ResourceMappings must not be null!");
        this.repositories = repositories;
        this.entityLinks = entityLinks;
        this.mappings = mappings;
    }

    @RequestMapping(value={"/", ""}, method={RequestMethod.OPTIONS})
    public HttpEntity<?> optionsForRepositories() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAllow(Collections.singleton(HttpMethod.GET));
        return new ResponseEntity((MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(value={"/", ""}, method={RequestMethod.HEAD})
    public ResponseEntity<?> headForRepositories() {
        return new ResponseEntity(HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/", ""}, method={RequestMethod.GET})
    public HttpEntity<RepositoryLinksResource> listRepositories() {
        RepositoryLinksResource resource = new RepositoryLinksResource();
        for (Class domainType : this.repositories) {
            ResourceMetadata metadata = this.mappings.getMetadataFor(domainType);
            if (!metadata.isExported()) continue;
            resource.add(this.entityLinks.linkToCollectionResource(domainType));
        }
        return new ResponseEntity((Object)resource, HttpStatus.OK);
    }
}

