/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.config;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.repository.support.RepositoryInvoker;
import org.springframework.data.rest.webmvc.IncomingRequest;
import org.springframework.data.rest.webmvc.PersistentEntityResource;
import org.springframework.data.rest.webmvc.ResourceNotFoundException;
import org.springframework.data.rest.webmvc.RootResourceInformation;
import org.springframework.data.rest.webmvc.config.JsonPatchHandler;
import org.springframework.data.rest.webmvc.config.RootResourceInformationHandlerMethodArgumentResolver;
import org.springframework.data.rest.webmvc.json.DomainObjectReader;
import org.springframework.data.rest.webmvc.support.BackendIdHandlerMethodArgumentResolver;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServletServerHttpRequest;
import org.springframework.util.Assert;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class PersistentEntityResourceHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final String ERROR_MESSAGE = "Could not read an object of type %s from the request!";
    private static final String NO_CONVERTER_FOUND = "No suitable HttpMessageConverter found to read request body into object of type %s from request with content type of %s!";
    private final RootResourceInformationHandlerMethodArgumentResolver resourceInformationResolver;
    private final BackendIdHandlerMethodArgumentResolver idResolver;
    private final DomainObjectReader reader;
    private final List<HttpMessageConverter<?>> messageConverters;

    public PersistentEntityResourceHandlerMethodArgumentResolver(List<HttpMessageConverter<?>> messageConverters, RootResourceInformationHandlerMethodArgumentResolver resourceInformationResolver, BackendIdHandlerMethodArgumentResolver idResolver, DomainObjectReader reader) {
        Assert.notEmpty(messageConverters, (String)"MessageConverters must not be null or empty!");
        Assert.notNull((Object)resourceInformationResolver, (String)"RootResourceInformationHandlerMethodArgumentResolver must not be empty!");
        Assert.notNull((Object)idResolver, (String)"BackendIdHandlerMethodArgumentResolver must not be null!");
        Assert.notNull((Object)reader, (String)"DomainObjectReader must not be null!");
        this.messageConverters = messageConverters;
        this.resourceInformationResolver = resourceInformationResolver;
        this.idResolver = idResolver;
        this.reader = reader;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return PersistentEntityResource.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        RootResourceInformation resourceInformation = this.resourceInformationResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
        HttpServletRequest nativeRequest = (HttpServletRequest)webRequest.getNativeRequest(HttpServletRequest.class);
        ServletServerHttpRequest request = new ServletServerHttpRequest(nativeRequest);
        IncomingRequest incoming = new IncomingRequest((ServerHttpRequest)request);
        Class<?> domainType = resourceInformation.getDomainType();
        MediaType contentType = request.getHeaders().getContentType();
        for (HttpMessageConverter<?> converter : this.messageConverters) {
            Object obj;
            if (!converter.canRead(PersistentEntityResource.class, contentType)) continue;
            Serializable id = this.idResolver.resolveArgument(parameter, mavContainer, webRequest, binderFactory);
            Object objectToUpdate = PersistentEntityResourceHandlerMethodArgumentResolver.getObjectToUpdate(id, resourceInformation);
            boolean forUpdate = false;
            Object entityIdentifier = null;
            PersistentEntity<?, ?> entity = resourceInformation.getPersistentEntity();
            if (objectToUpdate != null) {
                forUpdate = true;
                entityIdentifier = entity.getIdentifierAccessor(objectToUpdate).getIdentifier();
            }
            if ((obj = this.read(resourceInformation, incoming, converter, objectToUpdate)) == null) {
                throw new HttpMessageNotReadableException(String.format(ERROR_MESSAGE, domainType));
            }
            if (entityIdentifier != null) {
                entity.getPropertyAccessor(obj).setProperty(entity.getIdProperty(), entityIdentifier);
            }
            PersistentEntityResource.Builder build = PersistentEntityResource.build(obj, entity);
            return forUpdate ? build.build() : build.forCreation();
        }
        throw new HttpMessageNotReadableException(String.format(NO_CONVERTER_FOUND, domainType, contentType));
    }

    private Object read(RootResourceInformation information, IncomingRequest request, HttpMessageConverter<Object> converter, Object objectToUpdate) {
        if (request.isPatchRequest() && converter instanceof MappingJackson2HttpMessageConverter) {
            if (objectToUpdate == null) {
                throw new ResourceNotFoundException();
            }
            ObjectMapper mapper = ((MappingJackson2HttpMessageConverter)converter).getObjectMapper();
            Object result = this.readPatch(request, mapper, objectToUpdate);
            return result;
        }
        if (converter instanceof MappingJackson2HttpMessageConverter) {
            ObjectMapper mapper = ((MappingJackson2HttpMessageConverter)converter).getObjectMapper();
            return objectToUpdate == null ? this.read(request, converter, information) : this.readPutForUpdate(request, mapper, objectToUpdate);
        }
        return this.read(request, converter, information);
    }

    private Object readPatch(IncomingRequest request, ObjectMapper mapper, Object existingObject) {
        try {
            JsonPatchHandler handler = new JsonPatchHandler(mapper, this.reader);
            return handler.apply(request, existingObject);
        }
        catch (Exception o_O) {
            if (o_O instanceof HttpMessageNotReadableException) {
                throw (HttpMessageNotReadableException)o_O;
            }
            throw new HttpMessageNotReadableException(String.format(ERROR_MESSAGE, existingObject.getClass()), (Throwable)o_O);
        }
    }

    private Object readPutForUpdate(IncomingRequest request, ObjectMapper mapper, Object existingObject) {
        try {
            JsonPatchHandler handler = new JsonPatchHandler(mapper, this.reader);
            JsonNode jsonNode = mapper.readTree(request.getBody());
            return handler.applyPut((ObjectNode)jsonNode, existingObject);
        }
        catch (Exception o_O) {
            throw new HttpMessageNotReadableException(String.format(ERROR_MESSAGE, existingObject.getClass()), (Throwable)o_O);
        }
    }

    private Object read(IncomingRequest request, HttpMessageConverter<Object> converter, RootResourceInformation information) {
        try {
            return converter.read(information.getDomainType(), (HttpInputMessage)request.getServerHttpRequest());
        }
        catch (IOException o_O) {
            throw new HttpMessageNotReadableException(String.format(ERROR_MESSAGE, information.getDomainType()), (Throwable)o_O);
        }
    }

    private static Object getObjectToUpdate(Serializable id, RootResourceInformation information) {
        if (id == null) {
            return null;
        }
        RepositoryInvoker invoker = information.getInvoker();
        return invoker.invokeFindOne(id);
    }
}

