/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.rest.webmvc.support;

import java.beans.ConstructorProperties;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.rest.core.mapping.ResourceMappings;
import org.springframework.data.rest.core.mapping.ResourceMetadata;
import org.springframework.data.rest.webmvc.support.ExcerptProjector;
import org.springframework.util.Assert;

public class DefaultExcerptProjector
implements ExcerptProjector {
    private final ProjectionFactory factory;
    private final ResourceMappings mappings;

    @Override
    public Object projectExcerpt(Object source) {
        Assert.notNull((Object)source, (String)"Projection source must not be null!");
        ResourceMetadata metadata = this.mappings.getMetadataFor(source.getClass());
        Class projection = metadata == null ? null : metadata.getExcerptProjection();
        return projection == null || projection.equals(source.getClass()) ? source : this.factory.createProjection(projection, source);
    }

    @Override
    public boolean hasExcerptProjection(Class<?> type) {
        ResourceMetadata metadata = this.mappings.getMetadataFor(type);
        return metadata == null ? false : metadata.getExcerptProjection() != null;
    }

    @ConstructorProperties(value={"factory", "mappings"})
    public DefaultExcerptProjector(ProjectionFactory factory, ResourceMappings mappings) {
        this.factory = factory;
        this.mappings = mappings;
    }
}

