/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.query;

import java.util.Arrays;
import org.springframework.data.solr.core.query.AbstractFunction;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.SimpleField;
import org.springframework.util.Assert;

public class DefaultValueFunction
extends AbstractFunction {
    private static final String OPERATION = "def";

    private DefaultValueFunction(Object field, Object defaultValue) {
        super(Arrays.asList(field, defaultValue));
    }

    public static DefaultValueFunction defaultValue(String fieldName, Object defaultValue) {
        Assert.hasText((String)fieldName, (String)"Fieldname must not be 'empty' for default value operation.");
        Assert.notNull((Object)defaultValue, (String)"DefaultValue must not be 'null'.");
        return DefaultValueFunction.defaultValue(new SimpleField(fieldName), defaultValue);
    }

    public static DefaultValueFunction defaultValue(Field field, Object defaultValue) {
        Assert.notNull((Object)field, (String)"Field must not be 'null' for default value operation.");
        return new DefaultValueFunction(field, defaultValue);
    }

    public static DefaultValueFunction defaultValue(Function function, Object defaultValue) {
        Assert.notNull((Object)function, (String)"Function must not be 'null' for default value operation.");
        Assert.notNull((Object)defaultValue, (String)"DefaultValue must not be 'null'.");
        return new DefaultValueFunction(function, defaultValue);
    }

    @Override
    public String getOperation() {
        return OPERATION;
    }
}

