/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core.schema;

import java.util.Collection;
import org.springframework.data.solr.core.mapping.SolrPersistentEntity;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.schema.SchemaDefinition;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

public class SolrSchemaResolver {
    public SchemaDefinition resolveSchemaForEntity(SolrPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"Schema cannot be resolved for 'null'.");
        SchemaDefinition schemaDefinition = new SchemaDefinition(entity.getCollectionName());
        entity.doWithProperties(persistentProperty -> {
            SchemaDefinition.FieldDefinition fieldDefinition = this.createFieldDefinitionForProperty((SolrPersistentProperty)persistentProperty);
            if (fieldDefinition != null) {
                schemaDefinition.addFieldDefinition(fieldDefinition);
            }
        });
        return schemaDefinition;
    }

    @Nullable
    protected SchemaDefinition.FieldDefinition createFieldDefinitionForProperty(@Nullable SolrPersistentProperty property) {
        if (property == null || property.isReadonly() || property.isTransient()) {
            return null;
        }
        SchemaDefinition.FieldDefinition definition = new SchemaDefinition.FieldDefinition(property.getFieldName());
        definition.setMultiValued(property.isMultiValued());
        definition.setIndexed(property.isSearchable());
        definition.setStored(property.isStored());
        definition.setType(property.getSolrTypeName());
        definition.setDefaultValue(property.getDefaultValue());
        definition.setRequired(property.isRequired());
        Collection<String> copyFields = property.getCopyFields();
        if (!CollectionUtils.isEmpty(copyFields)) {
            definition.setCopyFields(copyFields);
        }
        return definition;
    }
}

