/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.repository.query;

import java.util.Collection;
import java.util.Iterator;
import org.springframework.core.convert.converter.Converter;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.domain.Sort;
import org.springframework.data.geo.Box;
import org.springframework.data.geo.Distance;
import org.springframework.data.geo.Point;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.data.solr.core.mapping.SolrPersistentProperty;
import org.springframework.data.solr.core.query.AnyCriteria;
import org.springframework.data.solr.core.query.Criteria;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.SimpleQuery;
import org.springframework.data.solr.repository.query.BindableSolrParameter;
import org.springframework.data.solr.repository.query.SolrParameterAccessor;
import org.springframework.lang.Nullable;

class SolrQueryCreator
extends AbstractQueryCreator<Query, Query> {
    private final MappingContext<?, SolrPersistentProperty> context;

    public SolrQueryCreator(PartTree tree, SolrParameterAccessor parameters, MappingContext<?, SolrPersistentProperty> context) {
        super(tree, (ParameterAccessor)parameters);
        this.context = context;
    }

    protected Query create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return new SimpleQuery(this.from(part.getType(), new Criteria(path.toDotPath((Converter)SolrPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected Query and(Part part, @Nullable Query base, Iterator<Object> iterator) {
        if (base == null) {
            return this.create(part, (Iterator)iterator);
        }
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        return (Query)base.addCriteria(this.from(part.getType(), new Criteria(path.toDotPath((Converter)SolrPersistentProperty.PropertyToFieldNameConverter.INSTANCE)), iterator));
    }

    protected Query or(Query base, Query query) {
        Criteria part = query.getCriteria();
        part.setPartIsOr(true);
        if (part.hasSiblings()) {
            boolean first = true;
            for (Criteria nested : part.getSiblings()) {
                if (first) {
                    nested.setPartIsOr(true);
                    first = false;
                }
                base.addCriteria(nested);
            }
        } else {
            base.addCriteria(part);
        }
        return base;
    }

    protected Query complete(@Nullable Query query, Sort sort) {
        return (query != null ? query : new SimpleQuery(AnyCriteria.any())).addSort(sort);
    }

    private Criteria from(Part.Type type, @Nullable Criteria instance, Iterator<?> parameters) {
        Criteria criteria = instance;
        if (criteria == null) {
            criteria = new Criteria();
        }
        switch (type) {
            case TRUE: {
                return criteria.is((Object)true);
            }
            case FALSE: {
                return criteria.is((Object)false);
            }
            case SIMPLE_PROPERTY: {
                return criteria.is(this.appendBoostAndGetParameterValue(criteria, parameters));
            }
            case NEGATING_SIMPLE_PROPERTY: {
                return criteria.is(this.appendBoostAndGetParameterValue(criteria, parameters)).not();
            }
            case IS_NULL: {
                return criteria.isNull();
            }
            case IS_NOT_NULL: {
                return criteria.isNotNull();
            }
            case REGEX: {
                return criteria.expression(this.appendBoostAndGetParameterValue(criteria, parameters).toString());
            }
            case LIKE: 
            case STARTING_WITH: {
                return criteria.startsWith(this.asStringArray(this.appendBoostAndGetParameterValue(criteria, parameters)));
            }
            case NOT_LIKE: {
                return criteria.startsWith(this.asStringArray(this.appendBoostAndGetParameterValue(criteria, parameters))).not();
            }
            case ENDING_WITH: {
                return criteria.endsWith(this.asStringArray(this.appendBoostAndGetParameterValue(criteria, parameters)));
            }
            case CONTAINING: {
                return criteria.contains(this.asStringArray(this.appendBoostAndGetParameterValue(criteria, parameters)));
            }
            case AFTER: 
            case GREATER_THAN: {
                return criteria.greaterThan(this.appendBoostAndGetParameterValue(criteria, parameters));
            }
            case GREATER_THAN_EQUAL: {
                return criteria.greaterThanEqual(this.appendBoostAndGetParameterValue(criteria, parameters));
            }
            case BEFORE: 
            case LESS_THAN: {
                return criteria.lessThan(this.appendBoostAndGetParameterValue(criteria, parameters));
            }
            case LESS_THAN_EQUAL: {
                return criteria.lessThanEqual(this.appendBoostAndGetParameterValue(criteria, parameters));
            }
            case BETWEEN: {
                return criteria.between(this.appendBoostAndGetParameterValue(criteria, parameters), this.appendBoostAndGetParameterValue(criteria, parameters));
            }
            case IN: {
                return criteria.in(this.asArray(this.appendBoostAndGetParameterValue(criteria, parameters)));
            }
            case NOT_IN: {
                return criteria.in(this.asArray(this.appendBoostAndGetParameterValue(criteria, parameters))).not();
            }
            case NEAR: {
                return this.createNearCriteria(parameters, criteria);
            }
            case WITHIN: {
                return criteria.within((Point)this.getBindableValue((BindableSolrParameter)parameters.next()), (Distance)this.getBindableValue((BindableSolrParameter)parameters.next()));
            }
        }
        throw new InvalidDataAccessApiUsageException("Illegal criteria found '" + type + "'.");
    }

    private Object appendBoostAndGetParameterValue(Criteria criteria, Iterator<?> iterator) {
        Object param = iterator.next();
        if (param instanceof BindableSolrParameter) {
            BindableSolrParameter bindable = (BindableSolrParameter)param;
            this.appendBoost(criteria, bindable);
            return bindable.getValue();
        }
        return param;
    }

    private Criteria appendBoost(Criteria criteria, BindableSolrParameter parameter) {
        if (!Float.isNaN(parameter.getBoost())) {
            criteria.boost(parameter.getBoost());
        }
        return criteria;
    }

    @Nullable
    private Object getBindableValue(@Nullable BindableSolrParameter parameter) {
        if (parameter == null) {
            return null;
        }
        return parameter.getValue();
    }

    private Criteria createNearCriteria(Iterator<?> parameters, Criteria criteria) {
        Object value = this.getBindableValue((BindableSolrParameter)parameters.next());
        if (value instanceof Box) {
            return criteria.near((Box)value);
        }
        return criteria.near((Point)value, (Distance)this.getBindableValue((BindableSolrParameter)parameters.next()));
    }

    private Object[] asArray(Object o) {
        if (o instanceof Collection) {
            return ((Collection)o).toArray();
        }
        if (o.getClass().isArray()) {
            return (Object[])o;
        }
        return new Object[]{o};
    }

    private String[] asStringArray(Object o) {
        if (o instanceof Collection) {
            Collection col = (Collection)o;
            if (col.isEmpty()) {
                return new String[0];
            }
            if (!(col.iterator().next() instanceof String)) {
                throw new IllegalArgumentException("Parameter has to be a collection of String.");
            }
            return ((Collection)o).toArray(new String[col.size()]);
        }
        if (o.getClass().isArray()) {
            if (!(o instanceof String[])) {
                throw new IllegalArgumentException("Parameter has to be an array of String.");
            }
            return (String[])o;
        }
        return new String[]{o.toString()};
    }
}

