/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.solr.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.solr.core.QueryParserBase;
import org.springframework.data.solr.core.query.FacetOptions;
import org.springframework.data.solr.core.query.FacetQuery;
import org.springframework.data.solr.core.query.Field;
import org.springframework.data.solr.core.query.FilterQuery;
import org.springframework.data.solr.core.query.Function;
import org.springframework.data.solr.core.query.GroupOptions;
import org.springframework.data.solr.core.query.HighlightOptions;
import org.springframework.data.solr.core.query.HighlightQuery;
import org.springframework.data.solr.core.query.PivotField;
import org.springframework.data.solr.core.query.Query;
import org.springframework.data.solr.core.query.QueryParameter;
import org.springframework.data.solr.core.query.SolrDataQuery;
import org.springframework.data.solr.core.query.SpellcheckOptions;
import org.springframework.data.solr.core.query.StatsOptions;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class DefaultQueryParser
extends QueryParserBase<SolrDataQuery> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultQueryParser.class);

    public DefaultQueryParser(@Nullable MappingContext mappingContext) {
        super(mappingContext);
    }

    @Override
    public final SolrQuery doConstructSolrQuery(SolrDataQuery query, @Nullable Class<?> domainType) {
        Assert.notNull((Object)query, (String)"Cannot construct solrQuery from null value.");
        Assert.notNull((Object)query.getCriteria(), (String)"Query has to have a criteria.");
        SolrQuery solrQuery = new SolrQuery();
        solrQuery.setParam("q", new String[]{this.getQueryString(query, domainType)});
        if (query instanceof Query) {
            this.processQueryOptions(solrQuery, (Query)query, domainType);
        }
        if (query instanceof FacetQuery) {
            this.processFacetOptions(solrQuery, (FacetQuery)query, domainType);
        }
        if (query instanceof HighlightQuery) {
            this.processHighlightOptions(solrQuery, (HighlightQuery)query, domainType);
        }
        return solrQuery;
    }

    private void processQueryOptions(SolrQuery solrQuery, Query query, @Nullable Class<?> domainType) {
        this.appendPagination(solrQuery, query.getOffset(), query.getRows());
        this.appendProjectionOnFields(solrQuery, query.getProjectionOnFields(), domainType);
        this.appendFilterQuery(solrQuery, query.getFilterQueries(), domainType);
        this.appendSort(solrQuery, query.getSort(), domainType);
        this.appendDefaultOperator(solrQuery, query.getDefaultOperator());
        this.appendTimeAllowed(solrQuery, query.getTimeAllowed());
        this.appendDefType(solrQuery, query.getDefType());
        this.appendRequestHandler(solrQuery, query.getRequestHandler());
        this.processGroupOptions(solrQuery, query, domainType);
        this.processStatsOptions(solrQuery, query, domainType);
        this.processSpellcheckOptions(solrQuery, query, domainType);
        this.appendGeoParametersIfRequired(solrQuery, query, domainType);
        LOGGER.debug("Constructed SolrQuery:\r\n {}", (Object)solrQuery);
    }

    private void processFacetOptions(SolrQuery solrQuery, FacetQuery query, @Nullable Class<?> domainType) {
        if (this.enableFaceting(solrQuery, query)) {
            this.appendFacetingOnFields(solrQuery, query, domainType);
            this.appendFacetingQueries(solrQuery, query, domainType);
            this.appendFacetingOnPivot(solrQuery, query, domainType);
            this.appendRangeFacetingOnFields(solrQuery, query, domainType);
        }
    }

    private void setObjectNameOnGroupQuery(Query query, Object object, String name) {
        if (query instanceof QueryParserBase.NamedObjectsQuery) {
            ((QueryParserBase.NamedObjectsQuery)query).setName(object, name);
        }
    }

    private void processStatsOptions(SolrQuery solrQuery, Query query, @Nullable Class<?> domainType) {
        StatsOptions statsOptions = query.getStatsOptions();
        if (statsOptions == null || CollectionUtils.isEmpty(statsOptions.getFields()) && CollectionUtils.isEmpty(statsOptions.getFacets()) && CollectionUtils.isEmpty(statsOptions.getSelectiveFacets())) {
            return;
        }
        solrQuery.set("stats", true);
        for (Field field : statsOptions.getFields()) {
            String mappedFieldName = this.getMappedFieldName(field, domainType);
            solrQuery.add("stats.field", new String[]{mappedFieldName});
            String selectiveCalcDistinctParam = "f." + mappedFieldName + "." + "stats.calcdistinct";
            Boolean selectiveCountDistincts = statsOptions.isSelectiveCalcDistincts(field);
            if (selectiveCountDistincts == null) continue;
            solrQuery.add(selectiveCalcDistinctParam, new String[]{String.valueOf(selectiveCountDistincts)});
        }
        for (Field field : statsOptions.getFacets()) {
            solrQuery.add("stats.facet", new String[]{this.getMappedFieldName(field, domainType)});
        }
        for (Map.Entry entry : statsOptions.getSelectiveFacets().entrySet()) {
            Field field = (Field)entry.getKey();
            String prefix = "f." + this.getMappedFieldName(field, domainType) + ".";
            String paramName = prefix + "stats.facet";
            for (Field facetField : (Collection)entry.getValue()) {
                solrQuery.add(paramName, new String[]{this.getMappedFieldName(facetField, domainType)});
            }
        }
    }

    private void processGroupOptions(SolrQuery solrQuery, Query query, Class<?> domainType) {
        GroupOptions groupOptions = query.getGroupOptions();
        if (groupOptions == null || CollectionUtils.isEmpty(groupOptions.getGroupByFields()) && CollectionUtils.isEmpty(groupOptions.getGroupByFunctions()) && CollectionUtils.isEmpty(groupOptions.getGroupByQueries())) {
            return;
        }
        solrQuery.set("group", true);
        solrQuery.set("group.main", groupOptions.isGroupMain());
        solrQuery.set("group.format", new String[]{"grouped"});
        if (!CollectionUtils.isEmpty(groupOptions.getGroupByFields())) {
            for (Field field : groupOptions.getGroupByFields()) {
                solrQuery.add("group.field", new String[]{this.getMappedFieldName(field, domainType)});
            }
        }
        if (!CollectionUtils.isEmpty(groupOptions.getGroupByFunctions())) {
            for (Function function : groupOptions.getGroupByFunctions()) {
                String functionFragment = this.createFunctionFragment(function, 0, domainType, Function.Context.Target.QUERY);
                this.setObjectNameOnGroupQuery(query, function, functionFragment);
                solrQuery.add("group.func", new String[]{functionFragment});
            }
        }
        if (!CollectionUtils.isEmpty(groupOptions.getGroupByQueries())) {
            for (Query groupQuery : groupOptions.getGroupByQueries()) {
                String queryFragment = this.getQueryString(groupQuery, domainType);
                this.setObjectNameOnGroupQuery(query, groupQuery, queryFragment);
                solrQuery.add("group.query", new String[]{queryFragment});
            }
        }
        if (groupOptions.getSort() != null) {
            for (Sort.Order order : groupOptions.getSort()) {
                solrQuery.add("group.sort", new String[]{this.getMappedFieldName(order.getProperty().trim(), domainType) + " " + (order.isAscending() ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc)});
            }
        }
        if (groupOptions.getCachePercent() > 0) {
            solrQuery.add("group.cache.percent", new String[]{String.valueOf(groupOptions.getCachePercent())});
        }
        if (groupOptions.getLimit() != null) {
            solrQuery.set("group.limit", groupOptions.getLimit().intValue());
        }
        if (groupOptions.getOffset() != null && groupOptions.getOffset() >= 0) {
            solrQuery.set("group.offset", groupOptions.getOffset().intValue());
        }
        solrQuery.set("group.ngroups", groupOptions.isTotalCount());
        solrQuery.set("group.facet", groupOptions.isGroupFacets());
        solrQuery.set("group.truncate", groupOptions.isTruncateFacets());
    }

    private void processSpellcheckOptions(SolrQuery solrQuery, Query query, @Nullable Class<?> domainType) {
        if (query.getSpellcheckOptions() == null) {
            return;
        }
        SpellcheckOptions options = query.getSpellcheckOptions();
        if (options.getQuery() != null && options.getQuery().getCriteria() != null) {
            solrQuery.set("spellcheck.q", new String[]{this.createQueryStringFromCriteria(options.getQuery().getCriteria(), domainType)});
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.add("spellcheck", new String[]{"on"});
        for (Map.Entry<String, Object> entry : options.getParams().entrySet()) {
            if (entry.getValue() instanceof Iterable) {
                for (Object o : (Iterable)entry.getValue()) {
                    params.add(entry.getKey(), new String[]{o.toString()});
                }
                continue;
            }
            if (ObjectUtils.isArray((Object)entry.getValue())) {
                for (Object o : ObjectUtils.toObjectArray((Object)entry.getValue())) {
                    params.add(entry.getKey(), new String[]{o.toString()});
                }
                continue;
            }
            params.add(entry.getKey(), new String[]{entry.getValue().toString()});
        }
        solrQuery.add((SolrParams)params);
    }

    protected void processHighlightOptions(SolrQuery solrQuery, HighlightQuery query, @Nullable Class<?> domainType) {
        if (query.hasHighlightOptions()) {
            HighlightOptions highlightOptions = query.getHighlightOptions();
            solrQuery.setHighlight(true);
            if (!highlightOptions.hasFields()) {
                solrQuery.addHighlightField(HighlightOptions.ALL_FIELDS.getName());
            } else {
                for (Field field : highlightOptions.getFields()) {
                    solrQuery.addHighlightField(this.getMappedFieldName(field, domainType));
                }
                for (HighlightOptions.FieldWithHighlightParameters fieldWithHighlightParameters : highlightOptions.getFieldsWithHighlightParameters()) {
                    this.addPerFieldHighlightParameters(solrQuery, fieldWithHighlightParameters, domainType);
                }
            }
            for (HighlightOptions.HighlightParameter option : highlightOptions.getHighlightParameters()) {
                this.addOptionToSolrQuery(solrQuery, option);
            }
            if (highlightOptions.hasQuery()) {
                solrQuery.add("hl.q", new String[]{this.getQueryString(highlightOptions.getQuery(), domainType)});
            }
        }
    }

    private void addOptionToSolrQuery(SolrQuery solrQuery, QueryParameter option) {
        if (option != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)option.getName())) {
            solrQuery.add(option.getName(), new String[]{(String)this.conversionService.convert(option.getValue(), String.class)});
        }
    }

    private void addFieldSpecificParameterToSolrQuery(SolrQuery solrQuery, Field field, QueryParameter option, @Nullable Class<?> domainType) {
        if (option != null && field != null && org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)option.getName())) {
            if (option.getValue() == null) {
                solrQuery.add(this.createPerFieldOverrideParameterName(field, option.getName(), domainType), new String[]{null});
            } else {
                String value = option.getValue().toString();
                if (this.conversionService.canConvert(option.getValue().getClass(), String.class)) {
                    value = (String)this.conversionService.convert(option.getValue(), String.class);
                }
                solrQuery.add(this.createPerFieldOverrideParameterName(field, option.getName(), domainType), new String[]{value});
            }
        }
    }

    private void addPerFieldHighlightParameters(SolrQuery solrQuery, HighlightOptions.FieldWithHighlightParameters field, @Nullable Class<?> domainType) {
        for (HighlightOptions.HighlightParameter option : field) {
            this.addFieldSpecificParameterToSolrQuery(solrQuery, field, option, domainType);
        }
    }

    protected String createPerFieldOverrideParameterName(Field field, String parameterName, @Nullable Class<?> domainType) {
        return "f." + this.getMappedFieldName(field, domainType) + "." + parameterName;
    }

    private boolean enableFaceting(SolrQuery solrQuery, FacetQuery query) {
        FacetOptions facetOptions = query.getFacetOptions();
        if (facetOptions == null || !facetOptions.hasFacets()) {
            return false;
        }
        solrQuery.setFacet(true);
        solrQuery.setFacetMinCount(facetOptions.getFacetMinCount());
        solrQuery.setFacetLimit(facetOptions.getPageable().getPageSize());
        if (facetOptions.getPageable().getPageNumber() > 0) {
            long offset = Math.max(0L, facetOptions.getPageable().getOffset());
            solrQuery.set("facet.offset", new String[]{"" + offset});
        }
        if (FacetOptions.FacetSort.INDEX.equals((Object)facetOptions.getFacetSort())) {
            solrQuery.setFacetSort("index");
        }
        return true;
    }

    private void appendFacetingOnFields(SolrQuery solrQuery, FacetQuery query, @Nullable Class<?> domainType) {
        FacetOptions facetOptions = query.getFacetOptions();
        solrQuery.addFacetField(this.convertFieldListToStringArray(facetOptions.getFacetOnFields(), domainType));
        if (facetOptions.hasFacetPrefix()) {
            solrQuery.setFacetPrefix(facetOptions.getFacetPrefix());
        }
        for (FacetOptions.FieldWithFacetParameters parametrizedField : facetOptions.getFieldsWithParameters()) {
            this.addPerFieldFacetParameters(solrQuery, parametrizedField, domainType);
            if (parametrizedField.getSort() == null || !FacetOptions.FacetSort.INDEX.equals((Object)parametrizedField.getSort())) continue;
            this.addFieldSpecificParameterToSolrQuery(solrQuery, parametrizedField, new FacetOptions.FacetParameter("facet.sort", "index"), domainType);
        }
    }

    private void addPerFieldFacetParameters(SolrQuery solrQuery, FacetOptions.FieldWithFacetParameters field, @Nullable Class<?> domainType) {
        for (FacetOptions.FacetParameter parameter : field) {
            this.addFieldSpecificParameterToSolrQuery(solrQuery, field, parameter, domainType);
        }
    }

    private void appendRangeFacetingOnFields(SolrQuery solrQuery, FacetQuery query, @Nullable Class<?> domainType) {
        FacetOptions facetRangeOptions = query.getFacetOptions();
        if (facetRangeOptions == null) {
            return;
        }
        for (FacetOptions.FieldWithRangeParameters<?, ?, ?> rangeField : facetRangeOptions.getFieldsWithRangeParameters()) {
            FacetOptions.FacetParameter param;
            if (rangeField instanceof FacetOptions.FieldWithDateRangeParameters) {
                this.appendFieldFacetingByDateRange(solrQuery, (FacetOptions.FieldWithDateRangeParameters)rangeField, domainType);
            } else if (rangeField instanceof FacetOptions.FieldWithNumericRangeParameters) {
                this.appendFieldFacetingByNumberRange(solrQuery, (FacetOptions.FieldWithNumericRangeParameters)rangeField, domainType);
            }
            if (rangeField.getHardEnd() != null && rangeField.getHardEnd().booleanValue()) {
                param = new FacetOptions.FacetParameter("facet.range.hardend", true);
                this.addFieldSpecificParameterToSolrQuery(solrQuery, rangeField, param, domainType);
            }
            if (rangeField.getOther() != null) {
                param = new FacetOptions.FacetParameter("facet.range.other", rangeField.getOther());
                this.addFieldSpecificParameterToSolrQuery(solrQuery, rangeField, param, domainType);
            }
            if (rangeField.getInclude() == null) continue;
            param = new FacetOptions.FacetParameter("facet.range.include", rangeField.getInclude());
            this.addFieldSpecificParameterToSolrQuery(solrQuery, rangeField, param, domainType);
        }
    }

    private void appendFieldFacetingByNumberRange(SolrQuery solrQuery, FacetOptions.FieldWithNumericRangeParameters field, @Nullable Class<?> domainType) {
        solrQuery.addNumericRangeFacet(this.getMappedFieldName(field, domainType), (Number)field.getStart(), (Number)field.getEnd(), (Number)field.getGap());
    }

    private void appendFieldFacetingByDateRange(SolrQuery solrQuery, FacetOptions.FieldWithDateRangeParameters field, @Nullable Class<?> domainType) {
        solrQuery.addDateRangeFacet(this.getMappedFieldName(field, domainType), (Date)field.getStart(), (Date)field.getEnd(), (String)field.getGap());
    }

    private void appendFacetingQueries(SolrQuery solrQuery, FacetQuery query, @Nullable Class<?> domainType) {
        FacetOptions facetOptions = query.getFacetOptions();
        for (SolrDataQuery fq : facetOptions.getFacetQueries()) {
            String facetQueryString = this.getQueryString(fq, domainType);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)facetQueryString)) continue;
            solrQuery.addFacetQuery(facetQueryString);
        }
    }

    private void appendFacetingOnPivot(SolrQuery solrQuery, FacetQuery query, @Nullable Class<?> domainType) {
        FacetOptions facetOptions = query.getFacetOptions();
        String[] pivotFields = this.convertFieldListToStringArray(facetOptions.getFacetOnPivots(), domainType);
        solrQuery.addFacetPivotField(pivotFields);
    }

    protected void appendFilterQuery(SolrQuery solrQuery, List<FilterQuery> filterQueries, @Nullable Class<?> domainType) {
        if (CollectionUtils.isEmpty(filterQueries)) {
            return;
        }
        List<String> filterQueryStrings = this.getFilterQueryStrings(filterQueries, domainType);
        if (!filterQueryStrings.isEmpty()) {
            solrQuery.setFilterQueries(this.convertStringListToArray(filterQueryStrings));
        }
    }

    protected void appendSort(SolrQuery solrQuery, @Nullable Sort sort, @Nullable Class<?> domainType) {
        if (sort == null) {
            return;
        }
        for (Sort.Order order : sort) {
            solrQuery.addSort(this.getMappedFieldName(order.getProperty(), domainType), order.isAscending() ? SolrQuery.ORDER.asc : SolrQuery.ORDER.desc);
        }
    }

    private String[] convertFieldListToStringArray(List<? extends Field> fields, @Nullable Class<?> domainType) {
        String[] strResult = new String[fields.size()];
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (field instanceof PivotField) {
                if (field.getName().contains(",")) {
                    String[] args = field.getName().split(",");
                    Object[] mapped = new String[args.length];
                    for (int j = 0; j < args.length; ++j) {
                        mapped[j] = this.getMappedFieldName(args[j], domainType);
                    }
                    strResult[i] = StringUtils.arrayToCommaDelimitedString((Object[])mapped);
                    continue;
                }
                strResult[i] = field.getName();
                continue;
            }
            strResult[i] = this.getMappedFieldName(field, domainType);
        }
        return strResult;
    }

    private String[] convertStringListToArray(List<String> listOfString) {
        String[] strResult = new String[listOfString.size()];
        listOfString.toArray(strResult);
        return strResult;
    }

    private List<String> getFilterQueryStrings(List<FilterQuery> filterQueries, @Nullable Class<?> domainType) {
        ArrayList<String> filterQueryStrings = new ArrayList<String>(filterQueries.size());
        for (FilterQuery filterQuery : filterQueries) {
            String filterQueryString = this.getQueryString(filterQuery, domainType);
            if (!org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)filterQueryString)) continue;
            filterQueryStrings.add(filterQueryString);
        }
        return filterQueryStrings;
    }
}

