/*
 * Decompiled with CFR 0.152.
 */
package org.springframework;

import java.util.HashMap;
import java.util.Map;
import org.springframework.nativex.type.AccessChecker;
import org.springframework.nativex.type.Type;
import org.springframework.nativex.type.TypeSystem;

public class PropertiesAccessChecker
implements AccessChecker {
    private static Map<String, String[]> requiredTypes = new HashMap<String, String[]>();

    private static void addRequiredTypes(String propertiesClass, String ... dependantTypes) {
        requiredTypes.put(propertiesClass, dependantTypes);
    }

    public boolean check(TypeSystem typeSystem, String typename) {
        String[] dependants;
        boolean isOK = true;
        if ((typename.endsWith("Properties") || typename.contains("Properties$")) && (dependants = requiredTypes.get(typename)) != null) {
            for (String dependant : dependants) {
                Type resolvedDependant = typeSystem.resolveDotted(dependant, true);
                if (resolvedDependant != null) continue;
                isOK = false;
                break;
            }
        }
        return isOK;
    }

    static {
        PropertiesAccessChecker.addRequiredTypes("org.springframework.boot.autoconfigure.cache.CacheProperties$Couchbase", "com.couchbase.client.java.Cluster", "org.springframework.data.couchbase.CouchbaseClientFactory", "org.springframework.data.couchbase.cache.CouchbaseCacheManager");
        PropertiesAccessChecker.addRequiredTypes("org.springframework.boot.autoconfigure.cache.CacheProperties$Redis", "org.springframework.data.redis.connection.RedisConnectionFactory");
        PropertiesAccessChecker.addRequiredTypes("org.springframework.boot.autoconfigure.cache.CacheProperties$EhCache", "net.sf.ehcache.Cache", "net.sf.ehcache.CacheManager");
        PropertiesAccessChecker.addRequiredTypes("org.springframework.boot.autoconfigure.cache.CacheProperties$JCache", "org.springframework.cache.jcache.JCacheCacheManager", "javax.cache.Caching");
        PropertiesAccessChecker.addRequiredTypes("org.springframework.boot.autoconfigure.cache.CacheProperties$Caffeine", "com.github.benmanes.caffeine.cache.Caffeine", "org.springframework.cache.caffeine.CaffeineCacheManager");
        PropertiesAccessChecker.addRequiredTypes("org.springframework.boot.autoconfigure.cache.CacheProperties$Infinispan", "org.infinispan.spring.embedded.provider.SpringEmbeddedCacheManager");
    }
}

