/*
 * Decompiled with CFR 0.152.
 */
package org.springframework;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import org.springframework.nativex.type.ComponentProcessor;
import org.springframework.nativex.type.Field;
import org.springframework.nativex.type.NativeContext;
import org.springframework.nativex.type.Type;

public class SynthesizerComputationComponentProcessor
implements ComponentProcessor {
    private static String[] DONT_NEED_PROXY = new String[]{"org.springframework.boot.autoconfigure.SpringBootApplication", "org.springframework.boot.SpringBootConfiguration", "org.springframework.context.annotation.Configuration", "org.springframework.context.annotation.ComponentScan", "org.springframework.web.bind.annotation.RestController", "org.springframework.stereotype.Controller", "org.springframework.web.bind.annotation.GetMapping"};

    public boolean handle(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        return type != null;
    }

    public void process(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        Predicate<Type> isSpringAnnotation = anno -> anno.getDottedName().startsWith("org.springframework");
        HashSet collector = new HashSet();
        for (Object annotationType : type.getAnnotations()) {
            annotationType.collectAnnotations(collector, isSpringAnnotation);
        }
        List methods = type.getMethods();
        for (Object method : methods) {
            for (Type methodAnnotationType : method.getAnnotationTypes()) {
                methodAnnotationType.collectAnnotations(collector, isSpringAnnotation);
            }
            for (int pi = 0; pi < method.getParameterCount(); ++pi) {
                List parameterAnnotationTypes = method.getParameterAnnotationTypes(pi);
                Iterator iterator = parameterAnnotationTypes.iterator();
                while (iterator.hasNext()) {
                    Type parameterAnnotationType = (Type)iterator.next();
                    parameterAnnotationType.collectAnnotations(collector, isSpringAnnotation);
                }
            }
        }
        List fields = type.getFields();
        for (Field field : fields) {
            for (Type fieldAnnotationType : field.getAnnotationTypes()) {
                fieldAnnotationType.collectAnnotations(collector, isSpringAnnotation);
            }
        }
        HashSet aliasForTargets = new HashSet();
        for (Type annotationType : collector) {
            annotationType.collectAliasReferencedMetas(aliasForTargets);
        }
        ArrayList<String> proxied = new ArrayList<String>();
        for (String aliasForTarget : aliasForTargets) {
            if (this.ignore(aliasForTarget)) continue;
            ArrayList<String> interfaces = new ArrayList<String>();
            interfaces.add(aliasForTarget);
            interfaces.add("org.springframework.core.annotation.SynthesizedAnnotation");
            imageContext.addProxy(interfaces);
            proxied.add(aliasForTarget);
        }
        imageContext.log("SynthesizerComputerComponentProcessor: From examining " + type.getDottedName() + " determined " + proxied.size() + " types as synthesized proxies: " + proxied);
    }

    private boolean ignore(String name) {
        for (String entry : DONT_NEED_PROXY) {
            if (!entry.equals(name)) continue;
            return true;
        }
        return false;
    }
}

