/*
 * Decompiled with CFR 0.152.
 */
package org.springframework;

import java.util.ArrayList;
import java.util.List;
import org.springframework.nativex.type.ComponentProcessor;
import org.springframework.nativex.type.NativeContext;
import org.springframework.nativex.type.Type;

public class TransactionalComponentProcessor
implements ComponentProcessor {
    public boolean handle(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        boolean hasTxMethods = type != null && type.hasTransactionalMethods();
        boolean isInteresting = type != null && (type.isTransactional() || hasTxMethods);
        return isInteresting;
    }

    public void process(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        ArrayList<String> transactionalInterfaces = new ArrayList<String>();
        for (Type intface : type.getInterfaces()) {
            transactionalInterfaces.add(intface.getDottedName());
        }
        if (transactionalInterfaces.size() == 0) {
            imageContext.log("TransactionalComponentProcessor: unable to find interfaces to proxy on " + componentType);
            return;
        }
        transactionalInterfaces.add("org.springframework.aop.SpringProxy");
        transactionalInterfaces.add("org.springframework.aop.framework.Advised");
        transactionalInterfaces.add("org.springframework.core.DecoratingProxy");
        imageContext.addProxy(transactionalInterfaces);
        imageContext.log("TransactionalComponentProcessor: creating proxy for these interfaces: " + transactionalInterfaces);
    }
}

