/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.nativex.hint.Flag;
import org.springframework.nativex.type.ComponentProcessor;
import org.springframework.nativex.type.Method;
import org.springframework.nativex.type.NativeContext;
import org.springframework.nativex.type.Type;
import org.springframework.nativex.type.TypeName;
import org.springframework.nativex.type.TypeSystem;
import org.springframework.util.StringUtils;

public class SpringDataComponentProcessor
implements ComponentProcessor {
    private static Log logger = LogFactory.getLog(SpringDataComponentProcessor.class);
    private static final String LOG_PREFIX = "SDCP: ";
    private static final String SPRING_DATA_NAMESPACE = "org.springframework.data";
    private static final String SPRING_DATA_DOMAIN_NAMESPACE = "org.springframework.data.domain";
    private static final Pattern REPOSITORY_METHOD_PATTERN = Pattern.compile("^(find|read|get|query|search|stream|count|exists|delete|remove).*");
    private static final Set<String> COMMON_REPOSITORY_DECLARATION_NAMES = new HashSet<String>(Arrays.asList("org.springframework.data.repository.Repository", "org.springframework.data.repository.CrudRepository", "org.springframework.data.repository.PagingAndSortingRepository", "org.springframework.data.repository.reactive.ReactiveCrudRepository", "org.springframework.data.repository.reactive.ReactiveSortingRepository"));
    private static final Set<String> STORE_REPOSITORY_DECLARATION_NAMES = new HashSet<String>(Arrays.asList("org.springframework.data.cassandra.repository.CassandraRepository", "org.springframework.data.cassandra.repository.ReactiveCassandraRepository", "org.springframework.data.couchbase.repository.CouchbaseRepository", "org.springframework.data.couchbase.repository.ReactiveCouchbaseRepository", "org.springframework.data.elasticsearch.repository.ElasticsearchRepository", "org.springframework.data.elasticsearch.repository.ReactiveElasticsearchRepository", "org.springframework.data.jpa.repository.JpaRepository", "org.springframework.data.mongodb.repository.MongoRepository", "org.springframework.data.mongodb.repository.ReactiveMongoRepository", "org.springframework.data.neo4j.repository.Neo4jRepository", "org.springframework.data.r2dbc.repository.R2dbcRepository"));
    public static final String REPOSITORY_REST_RESOURCE_DESCRIPTOR = "Lorg/springframework/data/rest/core/annotation/RepositoryRestResource;";
    private static String repositoryName;
    private static String queryAnnotationName;
    private final SpringDataComponentLog log = SpringDataComponentLog.instance();
    private Set<String> keysSeen = new HashSet<String>();

    public boolean handle(NativeContext imageContext, String key, List<String> values) {
        return repositoryName != null && values.contains(repositoryName);
    }

    public void process(NativeContext imageContext, String key, List<String> values) {
        this.keysSeen.add(key);
        try {
            Type repositoryType = imageContext.getTypeSystem().resolveName(key);
            Type repositoryDomainType = this.resolveRepositoryDomainType(repositoryType, imageContext.getTypeSystem());
            if (repositoryDomainType == null) {
                logger.debug((Object)("SDCP: Unable to work out repository contents for repository " + key));
                return;
            }
            this.log.repositoryFoundForType(repositoryType, repositoryDomainType);
            this.registerRepositoryInterface(repositoryType, imageContext);
            this.registerDomainType(repositoryDomainType, imageContext);
            this.registerQueryMethodResultTypes(repositoryType, repositoryDomainType, imageContext);
            this.detectCustomRepositoryImplementations(repositoryType, imageContext);
        }
        catch (Throwable t) {
            logger.debug((Object)("WARNING: Problem with SpringDataComponentProcessor: " + t.getMessage()));
        }
    }

    private void registerRepositoryInterface(Type repositoryType, NativeContext imageContext) {
        imageContext.addReflectiveAccess(repositoryType, new Flag[]{Flag.allPublicMethods, Flag.allDeclaredConstructors});
        imageContext.addProxy(new String[]{repositoryType.getDottedName(), "org.springframework.aop.SpringProxy", "org.springframework.aop.framework.Advised", "org.springframework.core.DecoratingProxy"});
        imageContext.addProxy(new String[]{repositoryType.getDottedName(), repositoryName, "org.springframework.transaction.interceptor.TransactionalProxy", "org.springframework.aop.framework.Advised", "org.springframework.core.DecoratingProxy"});
        if (repositoryType.isAtComponent()) {
            imageContext.addProxy(new String[]{repositoryType.getDottedName(), repositoryName, "org.springframework.transaction.interceptor.TransactionalProxy", "org.springframework.aop.framework.Advised", "org.springframework.core.DecoratingProxy", "java.io.Serializable"});
        }
        if (repositoryType.implementsInterface("org/springframework/data/repository/reactive/ReactiveCrudRepository")) {
            imageContext.initializeAtBuildTime(repositoryType);
        }
        this.registerDataRestComponentsIfNecessary(repositoryType, imageContext);
    }

    private void detectCustomRepositoryImplementations(Type repositoryType, NativeContext imageContext) {
        ArrayList<Type> customImplementations = new ArrayList<Type>();
        this.log.message("Looking for custom repository implementations of " + repositoryType.getDottedName());
        Type customImplementation = imageContext.getTypeSystem().resolveName(repositoryType.getName() + this.customRepositoryImplementationPostfix(), true);
        if (customImplementation != null) {
            this.log.customImplementationFound(repositoryType, customImplementation);
            customImplementations.add(customImplementation);
        }
        this.log.message("Inspecting repository interfaces for potential extensions.");
        for (Type repoInterface : repositoryType.getInterfaces()) {
            if (this.isPartOfSpringData(repoInterface)) {
                this.log.message("Skipping spring data interface " + repoInterface.getDottedName());
                continue;
            }
            this.log.message("Detected non spring data interface " + repoInterface.getDottedName());
            String customImplementationName = repoInterface.getName() + this.customRepositoryImplementationPostfix();
            Type customImplementation2 = imageContext.getTypeSystem().resolveName(customImplementationName, true);
            if (customImplementation2 == null) continue;
            this.log.customImplementationFound(repoInterface, customImplementation2);
            customImplementations.add(customImplementation2);
        }
        for (Type customImpl : customImplementations) {
            imageContext.addReflectiveAccessHierarchy(customImpl, 12);
            for (Method method : customImpl.getMethods()) {
                for (Type signatureType : method.getSignatureTypes(true)) {
                    this.registerDomainType(signatureType, imageContext);
                }
            }
        }
    }

    private void registerQueryMethodResultTypes(Type repositoryType, Type repositoryDomainType, NativeContext imageContext) {
        List methods = repositoryType.getMethods(this::isQueryMethod);
        methods.addAll(repositoryType.getMethodsWithAnnotationName(queryAnnotationName, true));
        for (Method method : methods) {
            this.registerSpringDataAnnotations(method, imageContext);
            for (Type signatureType : method.getSignatureTypes(true)) {
                this.registerDomainType(signatureType, imageContext);
                if (!this.isProjectionInterface(repositoryDomainType, signatureType)) continue;
                this.log.message(String.format("Registering proxy for '%s'. Might be projection return type of %s#%s", signatureType.getDottedName(), repositoryName, method.getName()));
                imageContext.addProxy(new String[]{signatureType.getDottedName(), "org.springframework.data.projection.TargetAware", "org.springframework.aop.SpringProxy", "org.springframework.core.DecoratingProxy"});
            }
        }
    }

    private boolean isProjectionInterface(Type repositoryDomainType, Type signatureType) {
        return signatureType.isInterface() && !signatureType.isPartOfDomain("java.") && !this.isPartOfSpringData(signatureType) && !signatureType.isAssignableFrom(repositoryDomainType);
    }

    private Type resolveRepositoryDomainType(Type repositoryType, TypeSystem typeSystem) {
        for (String repositoryDeclarationName : this.repositoryDeclarationNames()) {
            String domainTypeName = repositoryType.findTypeParameterInSupertype(repositoryDeclarationName, 0);
            if (!StringUtils.hasText((String)domainTypeName)) continue;
            this.log.message(String.format("Found %s for domain type %s.", repositoryDeclarationName, domainTypeName));
            return typeSystem.resolveName(domainTypeName);
        }
        return null;
    }

    private void registerDomainType(Type domainType, NativeContext imageContext) {
        if (domainType.isPartOfDomain(SPRING_DATA_DOMAIN_NAMESPACE) || imageContext.hasReflectionConfigFor(domainType.getDottedName())) {
            return;
        }
        this.log.message(String.format("Registering reflective access for %s", domainType.getDottedName()));
        imageContext.addReflectiveAccess(domainType.getDottedName(), new Flag[]{Flag.allDeclaredMethods, Flag.allDeclaredConstructors, Flag.allDeclaredFields});
        domainType.getAnnotations().forEach(it -> this.registerSpringDataAnnotation((Type)it, imageContext));
        domainType.getFields().forEach(field -> field.getAnnotationTypes().forEach(it -> this.registerSpringDataAnnotation((Type)it, imageContext)));
        List methods = domainType.getMethods(m -> m.getName().startsWith("get"));
        for (Method method : methods) {
            this.registerSpringDataAnnotations(method, imageContext);
            Set signatureTypes = method.getSignatureTypes(true);
            for (Type signatureType : signatureTypes) {
                if (imageContext.hasReflectionConfigFor(signatureType.getDottedName())) continue;
                if (domainType.isPartOfDomain("java.") || domainType.isPartOfDomain("reactor.")) {
                    imageContext.addReflectiveAccess(domainType.getDottedName(), new Flag[]{Flag.allPublicConstructors, Flag.allPublicMethods});
                    return;
                }
                this.registerDomainType(signatureType, imageContext);
            }
        }
    }

    protected boolean isQueryMethod(Method m) {
        return REPOSITORY_METHOD_PATTERN.matcher(m.getName()).matches();
    }

    private Set<String> repositoryDeclarationNames() {
        LinkedHashSet<String> repositoryDeclarationNames = new LinkedHashSet<String>(this.commonRepositoryDeclarationNames());
        repositoryDeclarationNames.addAll(this.storeSpecificRepositoryDeclarationNames());
        return repositoryDeclarationNames;
    }

    protected Set<String> commonRepositoryDeclarationNames() {
        return COMMON_REPOSITORY_DECLARATION_NAMES;
    }

    protected Set<String> storeSpecificRepositoryDeclarationNames() {
        return STORE_REPOSITORY_DECLARATION_NAMES;
    }

    protected String customRepositoryImplementationPostfix() {
        return "Impl";
    }

    private void registerSpringDataAnnotations(Method method, NativeContext context) {
        for (Type annotation : method.getAnnotationTypes()) {
            this.registerSpringDataAnnotation(annotation, context);
        }
        if (method.getParameterCount() == 0) {
            return;
        }
        for (int i = 0; i < method.getParameterCount(); ++i) {
            method.getParameterAnnotationTypes(i).forEach(it -> this.registerSpringDataAnnotation((Type)it, context));
        }
    }

    private void registerSpringDataAnnotation(Type annotation, NativeContext context) {
        if (!context.hasReflectionConfigFor(annotation) && this.isPartOfSpringData(annotation)) {
            context.addReflectiveAccess(annotation.getDottedName(), 11);
            context.addProxy(new String[]{annotation.getDottedName(), "org.springframework.core.annotation.SynthesizedAnnotation"});
            this.log.annotationFound(annotation);
        }
    }

    private boolean isRestResource(Type type) {
        return type.hasAnnotationInHierarchy(REPOSITORY_REST_RESOURCE_DESCRIPTOR);
    }

    private void registerDataRestComponentsIfNecessary(Type type, NativeContext context) {
        if (!this.isRestResource(type)) {
            return;
        }
        this.log.message(String.format("%s is a REST resource.", type.getDottedName()));
        Map annotationValuesInHierarchy = type.getAnnotationValuesInHierarchy(REPOSITORY_REST_RESOURCE_DESCRIPTOR);
        if (annotationValuesInHierarchy.containsKey("excerptProjection")) {
            String excerptProjectionSignatureType = (String)annotationValuesInHierarchy.get("excerptProjection");
            Type targetProjectionType = context.getTypeSystem().resolve(TypeName.fromTypeSignature((String)excerptProjectionSignatureType));
            if (targetProjectionType != null) {
                if (targetProjectionType.getDottedName().equals("org.springframework.data.rest.core.annotation.RepositoryRestResource$None")) {
                    return;
                }
                this.log.message("resolved excerpt projection: " + targetProjectionType.getDottedName());
                this.registerDomainType(targetProjectionType, context);
                context.addProxy(new String[]{targetProjectionType.getDottedName(), "org.springframework.data.projection.TargetAware", "org.springframework.aop.SpringProxy", "org.springframework.core.DecoratingProxy"});
            } else {
                this.log.message("excerpt projection " + excerptProjectionSignatureType + " not found!");
            }
        }
    }

    public void printSummary() {
        this.log.printSummary();
    }

    private boolean isPartOfSpringData(Type type) {
        return type.isPartOfDomain(SPRING_DATA_NAMESPACE);
    }

    static {
        try {
            repositoryName = "org.springframework.data.repository.Repository";
            queryAnnotationName = "org.springframework.data.annotation.QueryAnnotation";
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    static class SpringDataComponentLog {
        private final boolean verbose;
        private final HashMap<Type, Type> repositoryInterfaces = new LinkedHashMap<Type, Type>();
        private final Set<Type> annotations = new LinkedHashSet<Type>();
        private final Set<Type> customImplementations = new LinkedHashSet<Type>();

        private SpringDataComponentLog(boolean verbose) {
            this.verbose = verbose;
        }

        static SpringDataComponentLog instance() {
            return new SpringDataComponentLog(Boolean.valueOf(System.getProperty("spring.native.verbose", "false")));
        }

        void message(String msg) {
            if (this.verbose) {
                logger.debug((Object)(SpringDataComponentProcessor.LOG_PREFIX + msg));
            }
        }

        void repositoryFoundForType(Type repo, Type domainType) {
            this.repositoryInterfaces.put(repo, domainType);
            this.message(String.format("Registering repository '%s' for type '%s'.", repo.getDottedName(), domainType.getDottedName()));
        }

        void annotationFound(Type annotation) {
            this.annotations.add(annotation);
            this.message(String.format("Registering annotation '%s'.", annotation.getDottedName()));
        }

        void customImplementationFound(Type repositoryInterface, Type customImplementation) {
            this.customImplementations.add(customImplementation);
            this.message(String.format("Registering custom repository implementation '%s' for '%s'.", customImplementation.getDottedName(), repositoryInterface.getDottedName()));
        }

        void printSummary() {
            if (this.repositoryInterfaces.isEmpty()) {
                this.message("No Spring Data repositories found.");
                return;
            }
            logger.debug((Object)String.format("SDCP: Found %s repositories, %s custom implementations and registered %s annotations used by domain types.", this.repositoryInterfaces.size(), this.customImplementations.size(), this.annotations.size()));
        }
    }
}

