/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.kafka;

import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.springframework.nativex.type.ComponentProcessor;
import org.springframework.nativex.type.Method;
import org.springframework.nativex.type.NativeContext;
import org.springframework.nativex.type.Type;

public class KafkaComponentProcessor
implements ComponentProcessor {
    private final Set<String> added = new HashSet<String>();

    public boolean handle(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        if (type == null) {
            return false;
        }
        List methods = type.getMethodsWithAnnotationName("org.springframework.kafka.annotation.KafkaListener", true);
        return methods.size() > 0 || type.implementsInterface("org/springframework/kafka/listener/MessageListener");
    }

    public void process(NativeContext imageContext, String componentType, List<String> classifiers) {
        Type type = imageContext.getTypeSystem().resolveName(componentType);
        LinkedHashSet listeners = new LinkedHashSet();
        listeners.addAll(type.getMethodsWithAnnotationName("org.springframework.kafka.annotation.KafkaListener", true));
        if (type.implementsInterface("org/springframework/kafka/listener/MessageListener")) {
            listeners.addAll(type.getMethod("onMessage"));
        }
        HashSet<String> types = new HashSet<String>();
        for (Method method : listeners) {
            for (Type param : method.getParameterTypes()) {
                if (param.hasAnnotation("Lorg/apache/avro/specific/AvroGenerated;", false)) {
                    String name = param.getDottedName();
                    if (!this.added.add(name)) continue;
                    types.add(name);
                    continue;
                }
                if (!this.isContainer(param)) continue;
                Set params = method.getTypesInSignature();
                params.forEach(p -> {
                    String name;
                    Type paramType = imageContext.getTypeSystem().resolveName(p);
                    if (paramType != null && paramType.hasAnnotation("Lorg/apache/avro/specific/AvroGenerated;", false) && this.added.add(name = paramType.getDottedName())) {
                        types.add(name);
                    }
                });
            }
        }
        for (String toRegister : types) {
            imageContext.addReflectiveAccess(toRegister, 6);
        }
    }

    private boolean isContainer(Type param) {
        return param.getName().startsWith("org/apache/kafka/clients/consumer/ConsumerRecord") || param.getName().equals("java.util.List");
    }
}

