/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.nativex.substitutions.framework;

import com.oracle.svm.core.annotate.Alias;
import com.oracle.svm.core.annotate.Substitute;
import com.oracle.svm.core.annotate.TargetClass;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.apache.commons.logging.Log;
import org.springframework.lang.Nullable;
import org.springframework.nativex.substitutions.OnlyIfPresent;
import org.springframework.nativex.substitutions.WithAot;
import org.springframework.nativex.substitutions.framework.Target_StaticSpringFactories;
import org.springframework.util.Assert;

@TargetClass(className="org.springframework.core.io.support.SpringFactoriesLoader", onlyWith={WithAot.class, OnlyIfPresent.class})
final class Target_SpringFactoriesLoader {
    @Alias
    private static Log logger;

    Target_SpringFactoriesLoader() {
    }

    @Substitute
    public static <T> List<T> loadFactories(Class<T> factoryType, @Nullable ClassLoader classLoader) {
        Assert.notNull(factoryType, (String)"'factoryType' must not be null");
        List result = (List)Target_StaticSpringFactories.factories.get(factoryType);
        if (result == null) {
            return new ArrayList(0);
        }
        ArrayList factories = new ArrayList(result.size());
        for (Supplier supplier : result) {
            try {
                factories.add(supplier.get());
            }
            catch (Throwable throwable) {
                logger.trace((Object)("Could not instantiate factory for " + factoryType), throwable);
            }
        }
        return factories;
    }

    @Substitute
    public static List<String> loadFactoryNames(Class<?> factoryType, @Nullable ClassLoader classLoader) {
        List stored;
        ArrayList<String> result = new ArrayList<String>();
        List names = (List)Target_StaticSpringFactories.names.get(factoryType);
        if (names != null) {
            result.addAll(names);
        }
        if ((stored = (List)Target_StaticSpringFactories.factories.get(factoryType)) != null) {
            for (Supplier supplier : stored) {
                try {
                    result.add(supplier.get().getClass().getName());
                }
                catch (Throwable throwable) {
                    logger.trace((Object)("Could not get factory name for " + factoryType), throwable);
                }
            }
        }
        return result;
    }
}

