/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.hateoas;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.hateoas.Link;
import org.springframework.util.StringUtils;

public class Links
implements Iterable<Link> {
    private static final Pattern LINK_HEADER_PATTERN = Pattern.compile("(<[^>]*>;rel=\"[^\"]*\")");
    static final Links NO_LINKS = new Links(Collections.<Link>emptyList());
    private final List<Link> links;

    public Links(List<Link> links) {
        this.links = links == null ? Collections.emptyList() : Collections.unmodifiableList(links);
    }

    public Links(Link ... links) {
        this(Arrays.asList(links));
    }

    public Link getLink(String rel) {
        for (Link link : this.links) {
            if (!link.getRel().equals(rel)) continue;
            return link;
        }
        return null;
    }

    public List<Link> getLinks(String rel) {
        ArrayList<Link> result = new ArrayList<Link>();
        for (Link link : this.links) {
            if (!link.getRel().endsWith(rel)) continue;
            result.add(link);
        }
        return result;
    }

    public boolean hasLink(String rel) {
        return this.getLink(rel) != null;
    }

    public static Links valueOf(String source) {
        if (!StringUtils.hasText((String)source)) {
            return NO_LINKS;
        }
        Matcher matcher = LINK_HEADER_PATTERN.matcher(source);
        ArrayList<Link> links = new ArrayList<Link>();
        while (matcher.find()) {
            Link link = Link.valueOf(matcher.group());
            if (link == null) continue;
            links.add(link);
        }
        return new Links(links);
    }

    public boolean isEmpty() {
        return this.links.isEmpty();
    }

    public String toString() {
        return StringUtils.collectionToCommaDelimitedString(this.links);
    }

    @Override
    public Iterator<Link> iterator() {
        return this.links.iterator();
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof Links)) {
            return false;
        }
        Links that = (Links)arg0;
        return this.links.equals(that.links);
    }

    public int hashCode() {
        int result = 17;
        return result += 31 * this.links.hashCode();
    }
}

